/*
 * testprog2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprog2.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-04-2011
 *  \brief Programa para el testeo de las funciones de reducción e inversión de matrices.
 *  
 *  \n\n Este programa hace una prueba de la función para reducción de una matriz, 
 *  y de inversión de una matriz. Ambas funciones usan el método de gauss para 
 *  cumplir su objetivo.
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsra.h>

int main(int argc, char** argv)
{
	PdsMatrix *Mat=NULL;
	PdsMatrix *Mat1=NULL;
	PdsMatrix *Mat2=NULL;
	PdsMatrix *Mat3=NULL;
	PdsMatrix *Mat4=NULL;
	PdsRaReal m;
	int id;
	
	////////////////////////////////////////////////////////////////////////

	Mat =pds_matrix_new(3,6);
	Mat1=pds_matrix_new(3,3);
	Mat2=pds_matrix_new(3,6);
	//Mat3=pds_matrix_new(3,3);
	Mat4=pds_matrix_new(3,3);

	if((Mat==NULL)||(Mat1==NULL)||(Mat2==NULL))	printf("ERROR: La matriz no ha podido crearse.\n");
	else
	{
		_MATSETVAL(Mat1,0,0, 1.3); _MATSETVAL(Mat1,0,1, 0.1); _MATSETVAL(Mat1,0,2,-0.1);
		_MATSETVAL(Mat1,1,0,-0.5); _MATSETVAL(Mat1,1,1,-4.2); _MATSETVAL(Mat1,1,2, 0.2);
		_MATSETVAL(Mat1,2,0, 0.1); _MATSETVAL(Mat1,2,1,-1.2); _MATSETVAL(Mat1,2,2,-0.1);
		printf("\nMat1=\n");
		pds_matrix_printf(Mat1);

		pds_matrix_copy_identity(Mat,0,3,1.0);
		pds_matrix_copy_matrix(Mat,0,0,Mat1,0,0);
		printf("\nMat=\n");
		pds_matrix_printf(Mat);

		id=pds_matrix_reduced_matrix(Mat,Mat2);
		if(id==FALSE) printf("ERROR:Al reducir Mat en Mat2");
		printf("\nMat2=Reduced{Mat}\n");
		pds_matrix_printf(Mat2);

		Mat3=pds_matrix_inverse_matrix_new(Mat1);	
		if(Mat3==NULL) printf("ERROR:Al invertir Mat1 en Mat3");
		printf("\nMat3=Mat1^{-1}\n");
		pds_matrix_printf(Mat3);

		id=pds_matrix_mul_matrix(Mat4,Mat1,Mat3);
		printf("\nMat4=Mat1*Mat3\n");
		pds_matrix_printf(Mat4);

		printf("\n");
		pds_matrix_destroy(&Mat);
		if(Mat==NULL) printf("La matriz Mat  ha sido liberada y limpiada.\n");
		pds_matrix_destroy(&Mat1);
		if(Mat1==NULL) printf("La matriz Mat1 ha sido liberada y limpiada.\n");
		pds_matrix_destroy(&Mat2);
		if(Mat2==NULL) printf("La matriz Mat2 ha sido liberada y limpiada.\n");
		pds_matrix_destroy(&Mat3);
		if(Mat3==NULL) printf("La matriz Mat3 ha sido liberada y limpiada.\n");
		pds_matrix_destroy(&Mat4);
		if(Mat4==NULL) printf("La matriz Mat4 ha sido liberada y limpiada.\n");
	}

	printf("\n");

	return EXIT_SUCCESS;
}
