/**
	\mainpage PDS Real Arrays

	<br>
	\author Fernando Pujaico Rivera
	\date 30 de Agosto del 2015
	\version v0.10

	\tableofcontents

	\section desc_sec Descripción
	Aquí encontrarás un conjunto de funciones para trabajar con matrices, 
	vectores, etc.<br>
	<center>
	<table>
		<tr>
			<td>\ref PdsVectorGroup "PdsVector"</td>
			<td>Vectores de valores reales: 
			<ul>
			<li>Sumar, restar, dividir, multiplicar, ordenar,</li>
			<li>comparar, correlación, covarianza, máximos,</li>
			<li>mínimos, media, norma, rms, varianza,</li>
			<li>guardar y leer desde archivos,</li>
			<li>imprimir en pantalla, etc.</li>
			</ul>
			</td>
		</tr>

		<tr>
			<td>\ref PdsMatrixGroup "PdsMatrix"</td>
			<td>Matrices de valores reales: 
			<ul>
			<li>Sumar, restar, dividir, multiplicar, ordenar,</li>
			<li>copiar, Matriz identidad, máximos,</li>
			<li>mínimos, inversa, transpuesta, pseudo inversa</li>
			<li>reguralización no lineal</li>
			<li>guardar y leer desde archivos,</li>
			<li>imprimir en pantalla, etc.</li>
			</ul>
			</td>
		</tr>

		<tr>
			<td>\ref PdsFifoGroup "PdsFifo"</td>
			<td>Vectores de valores reales agrupados formando una FIFO: 
			<ul>
			<li>escribir, leer, estados de la FIFO,</li>
			<li>imprimir en pantalla, etc.</li>
			</ul>
			</td>
		</tr>

		<tr>
			<td>\ref PdsLVectorGroup "PdsListVector"</td>
			<td>Vectores de valores reales agrupados formando una lista doblemente enlazada: 
			<ul>
			<li>Colocar un elementos , quitar elementos,</li>
			<li>imprimir en pantalla, etc.</li>
			</ul>
			</td>
		</tr>

		<tr>
			<td>~</td>
			<td>Funciones utiles para leer datos desde archivos ASCII: 
			<ul>
			<li>Número de lineas y columnas de datos en un archivo,</li>
			<li>Número de elementos (datos) en un archivo.</li>
			</ul>
			</td>
		</tr>
	</table>
	</center>

	\section complink_sec Compilando y enlazando la biblioteca

	\subsection comp_subsec Compilado e instalando
	Para compilar la biblioteca <b>PDS Real Arrays</b> es necesario tener en cuenta
	el siguiente diagrama de dependencias de bibliotecas. 
	<center>
	\image html compilar.png "Crear/Compilar la biblioteca PDS Real Arrays."
	</center>
	Como se puede ver, son necesarios los archivos de definiciones `*.h`  y 
	las bibliotecas empaquetadas en binario (`*.a`, `*.so`).
	En este caso la biblioteca <b>PDS Real Arrays</b> solo depende 
	de archivos de la biblioteca estándar de C ( <b>libc</b> y <b>libm</b> ).
	Por lo que para instalar solo es necesario:<br>
\code{.sh}
	# Define donde se instalará la biblioteca, ejemplo: /usr
	./configure	--prefix=/usr
	# Compilar e instalar la biblioteca
	make
	sudo make install
\endcode

	\subsection link_subsec Usando y enlazando la biblioteca
	Una vez instalada la biblioteca <b>PDS Real Arrays</b>, para que esta pueda
	ser	usada por algún otro proyecto, es necesario tener en cuenta el
	siguiente diagrama de dependencia de la biblioteca. 
	<center>
	\image html enlazar.png "Usar/Enlazar la biblioteca PDS Real Arrays."
	</center>
	Como se ve, esta solo necesita la biblioteca estándar de C.
	 
	Por lo que para usar <b>PDS Real Arrays</b> en un proyecto (como test.c), se
	debe agregar la siguiente cabecera al inicio del código fuente.
\code{.h}
	#include <pds/pdsra.h>
\endcode 
	Esto incluirá todas las definiciones de las funciones de la biblioteca.
	Luego para compilar su código test.c.
\code{.sh}
 #Statically linked.

	gcc -static -o test test.c -lpdsra

 #Dynamically linked.

	gcc -o test test.c -lpdsra
\endcode


*/

