/*
 * pdscolormap.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdscolormap.h
 *  \author Fernando Pujaico Rivera
 *  \date 01-04-2011
 *  \brief varaibles con mapas de colores
 *  
 *  <br> 
 */

#ifndef __PDSCOLORMAP_H__
#define __PDSCOLORMAP_H__

#ifdef __cplusplus
static const "C" {
#endif 

#include <stdio.h>
#include <stdlib.h>



/** \defgroup PdsColormapGroup Módulo PdsColormap.
 *  \brief Variable que definen mapas de colores.
 *  
 *  <br> 
 * @{
 */

#ifndef PDS_OK
/*!
  \def PDS_OK
  Valor retornado en caso de exito, este es un valor diferente que cero.
*/
	#define PDS_OK 1
#endif

#ifndef PDS_WRONG
/*!
  \def PDS_WRONG
  Valor retornado en caso de fracaso, este valor es igual a cero.
*/
	#define PDS_WRONG 0
#endif

/*! \var PDS_COLORMAP_GRAY
 *  Mapa de colores en escala de grises.
 *  <center>
 *  \image html pds_matrix_save_bmp_with_colormap_gray.bmp "colormap"
 *  \image html colormap_gray.png "red vs green vs blue"
 *  </center>
 *  \ingroup PdsColormapGroup
*/
static const unsigned char PDS_COLORMAP_GRAY[256][3]=
{
    {  0,  0,  0},
    {  1,  1,  1},
    {  2,  2,  2},
    {  3,  3,  3},
    {  4,  4,  4},
    {  5,  5,  5},
    {  6,  6,  6},
    {  7,  7,  7},
    {  8,  8,  8},
    {  9,  9,  9},
    { 10, 10, 10},
    { 11, 11, 11},
    { 12, 12, 12},
    { 13, 13, 13},
    { 14, 14, 14},
    { 15, 15, 15},
    { 16, 16, 16},
    { 17, 17, 17},
    { 18, 18, 18},
    { 19, 19, 19},
    { 20, 20, 20},
    { 21, 21, 21},
    { 22, 22, 22},
    { 23, 23, 23},
    { 24, 24, 24},
    { 25, 25, 25},
    { 26, 26, 26},
    { 27, 27, 27},
    { 28, 28, 28},
    { 29, 29, 29},
    { 30, 30, 30},
    { 31, 31, 31},
    { 32, 32, 32},
    { 33, 33, 33},
    { 34, 34, 34},
    { 35, 35, 35},
    { 36, 36, 36},
    { 37, 37, 37},
    { 37, 37, 37},
    { 38, 38, 38},
    { 39, 39, 39},
    { 41, 41, 41},
    { 42, 42, 42},
    { 43, 43, 43},
    { 44, 44, 44},
    { 46, 46, 46},
    { 47, 47, 47},
    { 48, 48, 48},
    { 48, 48, 48},
    { 49, 49, 49},
    { 50, 50, 50},
    { 51, 51, 51},
    { 52, 52, 52},
    { 53, 53, 53},
    { 54, 54, 54},
    { 55, 55, 55},
    { 56, 56, 56},
    { 57, 57, 57},
    { 58, 58, 58},
    { 59, 59, 59},
    { 60, 60, 60},
    { 61, 61, 61},
    { 62, 62, 62},
    { 63, 63, 63},
    { 64, 64, 64},
    { 65, 65, 65},
    { 66, 66, 66},
    { 67, 67, 67},
    { 68, 68, 68},
    { 69, 69, 69},
    { 70, 70, 70},
    { 71, 71, 71},
    { 72, 72, 72},
    { 73, 73, 73},
    { 74, 74, 74},
    { 75, 75, 75},
    { 76, 76, 76},
    { 77, 77, 77},
    { 78, 78, 78},
    { 79, 79, 79},
    { 80, 80, 80},
    { 81, 81, 81},
    { 82, 82, 82},
    { 83, 83, 83},
    { 84, 84, 84},
    { 85, 85, 85},
    { 86, 86, 86},
    { 87, 87, 87},
    { 88, 88, 88},
    { 89, 89, 89},
    { 90, 90, 90},
    { 91, 91, 91},
    { 92, 92, 92},
    { 93, 93, 93},
    { 94, 94, 94},
    { 95, 95, 95},
    { 96, 96, 96},
    { 97, 97, 97},
    { 98, 98, 98},
    { 99, 99, 99},
    {100,100,100},
    {101,101,101},
    {102,102,102},
    {103,103,103},
    {104,104,104},
    {105,105,105},
    {106,106,106},
    {107,107,107},
    {108,108,108},
    {109,109,109},
    {110,110,110},
    {111,111,111},
    {112,112,112},
    {113,113,113},
    {114,114,114},
    {115,115,115},
    {116,116,116},
    {117,117,117},
    {118,118,118},
    {119,119,119},
    {120,120,120},
    {121,121,121},
    {122,122,122},
    {122,122,122},
    {123,123,123},
    {124,124,124},
    {126,126,126},
    {127,127,127},
    {128,128,128},
    {129,129,129},
    {131,131,131},
    {132,132,132},
    {133,133,133},
    {133,133,133},
    {134,134,134},
    {135,135,135},
    {136,136,136},
    {137,137,137},
    {138,138,138},
    {139,139,139},
    {140,140,140},
    {141,141,141},
    {142,142,142},
    {143,143,143},
    {144,144,144},
    {145,145,145},
    {146,146,146},
    {147,147,147},
    {148,148,148},
    {149,149,149},
    {150,150,150},
    {151,151,151},
    {152,152,152},
    {153,153,153},
    {154,154,154},
    {155,155,155},
    {156,156,156},
    {157,157,157},
    {158,158,158},
    {159,159,159},
    {160,160,160},
    {161,161,161},
    {162,162,162},
    {163,163,163},
    {164,164,164},
    {165,165,165},
    {166,166,166},
    {167,167,167},
    {168,168,168},
    {169,169,169},
    {170,170,170},
    {171,171,171},
    {172,172,172},
    {173,173,173},
    {174,174,174},
    {175,175,175},
    {176,176,176},
    {177,177,177},
    {178,178,178},
    {179,179,179},
    {180,180,180},
    {181,181,181},
    {182,182,182},
    {183,183,183},
    {184,184,184},
    {185,185,185},
    {186,186,186},
    {187,187,187},
    {188,188,188},
    {189,189,189},
    {190,190,190},
    {191,191,191},
    {192,192,192},
    {193,193,193},
    {194,194,194},
    {195,195,195},
    {196,196,196},
    {197,197,197},
    {198,198,198},
    {199,199,199},
    {200,200,200},
    {201,201,201},
    {202,202,202},
    {203,203,203},
    {204,204,204},
    {205,205,205},
    {206,206,206},
    {207,207,207},
    {207,207,207},
    {208,208,208},
    {209,209,209},
    {211,211,211},
    {212,212,212},
    {213,213,213},
    {214,214,214},
    {216,216,216},
    {217,217,217},
    {218,218,218},
    {218,218,218},
    {219,219,219},
    {220,220,220},
    {221,221,221},
    {222,222,222},
    {223,223,223},
    {224,224,224},
    {225,225,225},
    {226,226,226},
    {227,227,227},
    {228,228,228},
    {229,229,229},
    {230,230,230},
    {231,231,231},
    {232,232,232},
    {233,233,233},
    {234,234,234},
    {235,235,235},
    {236,236,236},
    {237,237,237},
    {238,238,238},
    {239,239,239},
    {240,240,240},
    {241,241,241},
    {242,242,242},
    {243,243,243},
    {244,244,244},
    {245,245,245},
    {246,246,246},
    {247,247,247},
    {248,248,248},
    {249,249,249},
    {250,250,250},
    {251,251,251},
    {252,252,252},
    {253,253,253},
    {254,254,254},
    {255,255,255},
};


/*! \var PDS_COLORMAP_JET
 *  Mapa de colores JET
 *  <center>
 *  \image html pds_matrix_save_bmp_with_colormap_jet.bmp "colormap"
 *  \image html colormap_jet.png "red vs green vs blue"
 *  </center>
 *  \ingroup PdsColormapGroup
*/
static const unsigned char PDS_COLORMAP_JET[256][3]=
{
    {  0,  0,143},
    {  0,  0,147},
    {  0,  0,151},
    {  0,  0,155},
    {  0,  0,159},
    {  0,  0,163},
    {  0,  0,167},
    {  0,  0,171},
    {  0,  0,175},
    {  0,  0,179},
    {  0,  0,183},
    {  0,  0,186},
    {  0,  0,190},
    {  0,  0,194},
    {  0,  0,198},
    {  0,  0,202},
    {  0,  0,206},
    {  0,  0,210},
    {  0,  0,214},
    {  0,  0,218},
    {  0,  0,222},
    {  0,  0,226},
    {  0,  0,230},
    {  0,  0,234},
    {  0,  0,238},
    {  0,  0,242},
    {  0,  0,246},
    {  0,  0,250},
    {  0,  0,254},
    {  0,  3,255},
    {  0,  7,255},
    {  0, 11,255},
    {  0, 14,255},
    {  0, 18,255},
    {  0, 22,255},
    {  0, 26,255},
    {  0, 30,255},
    {  0, 34,255},
    {  0, 38,255},
    {  0, 42,255},
    {  0, 46,255},
    {  0, 50,255},
    {  0, 54,255},
    {  0, 58,255},
    {  0, 62,255},
    {  0, 66,255},
    {  0, 70,255},
    {  0, 74,255},
    {  0, 78,255},
    {  0, 82,255},
    {  0, 86,255},
    {  0, 90,255},
    {  0, 94,255},
    {  0, 98,255},
    {  0,101,255},
    {  0,105,255},
    {  0,109,255},
    {  0,113,255},
    {  0,117,255},
    {  0,121,255},
    {  0,125,255},
    {  0,129,255},
    {  0,133,255},
    {  0,136,255},
    {  0,140,255},
    {  0,144,255},
    {  0,148,255},
    {  0,152,255},
    {  0,156,255},
    {  0,160,255},
    {  0,164,255},
    {  0,168,255},
    {  0,172,255},
    {  0,176,255},
    {  0,180,255},
    {  0,183,255},
    {  0,187,255},
    {  0,191,255},
    {  0,195,255},
    {  0,199,255},
    {  0,203,255},
    {  0,207,255},
    {  0,211,255},
    {  0,215,255},
    {  0,219,255},
    {  0,223,255},
    {  0,227,255},
    {  0,231,255},
    {  0,235,255},
    {  0,239,255},
    {  0,243,255},
    {  0,247,255},
    {  0,251,255},
    {  0,255,255},
    {  4,255,251},
    {  8,255,247},
    { 11,255,244},
    { 15,255,240},
    { 19,255,236},
    { 23,255,232},
    { 27,255,228},
    { 31,255,224},
    { 35,255,220},
    { 39,255,216},
    { 43,255,212},
    { 47,255,208},
    { 51,255,204},
    { 55,255,200},
    { 59,255,196},
    { 63,255,192},
    { 67,255,188},
    { 71,255,184},
    { 75,255,180},
    { 79,255,176},
    { 83,255,172},
    { 87,255,168},
    { 91,255,164},
    { 94,255,161},
    { 98,255,157},
    {102,255,153},
    {106,255,149},
    {110,255,145},
    {114,255,141},
    {118,255,137},
    {122,255,133},
    {126,255,130},
    {130,255,126},
    {134,255,122},
    {137,255,118},
    {141,255,114},
    {145,255,110},
    {149,255,106},
    {153,255,102},
    {157,255, 98},
    {161,255, 94},
    {165,255, 90},
    {169,255, 86},
    {173,255, 82},
    {177,255, 78},
    {180,255, 75},
    {184,255, 71},
    {188,255, 67},
    {192,255, 63},
    {196,255, 59},
    {200,255, 55},
    {204,255, 51},
    {208,255, 47},
    {212,255, 43},
    {216,255, 39},
    {220,255, 35},
    {224,255, 31},
    {228,255, 27},
    {232,255, 23},
    {236,255, 19},
    {240,255, 15},
    {244,255, 11},
    {248,255,  7},
    {252,255,  3},
    {255,254,  0},
    {255,250,  0},
    {255,247,  0},
    {255,243,  0},
    {255,239,  0},
    {255,235,  0},
    {255,231,  0},
    {255,227,  0},
    {255,223,  0},
    {255,219,  0},
    {255,215,  0},
    {255,211,  0},
    {255,207,  0},
    {255,203,  0},
    {255,199,  0},
    {255,195,  0},
    {255,191,  0},
    {255,187,  0},
    {255,183,  0},
    {255,179,  0},
    {255,175,  0},
    {255,171,  0},
    {255,167,  0},
    {255,164,  0},
    {255,160,  0},
    {255,156,  0},
    {255,152,  0},
    {255,148,  0},
    {255,144,  0},
    {255,140,  0},
    {255,136,  0},
    {255,133,  0},
    {255,129,  0},
    {255,125,  0},
    {255,121,  0},
    {255,117,  0},
    {255,113,  0},
    {255,109,  0},
    {255,105,  0},
    {255,101,  0},
    {255, 97,  0},
    {255, 93,  0},
    {255, 89,  0},
    {255, 85,  0},
    {255, 82,  0},
    {255, 78,  0},
    {255, 74,  0},
    {255, 70,  0},
    {255, 66,  0},
    {255, 62,  0},
    {255, 58,  0},
    {255, 54,  0},
    {255, 50,  0},
    {255, 46,  0},
    {255, 42,  0},
    {255, 38,  0},
    {255, 34,  0},
    {255, 30,  0},
    {255, 26,  0},
    {255, 22,  0},
    {255, 18,  0},
    {255, 14,  0},
    {255, 10,  0},
    {255,  6,  0},
    {255,  2,  0},
    {253,  0,  0},
    {250,  0,  0},
    {246,  0,  0},
    {242,  0,  0},
    {238,  0,  0},
    {234,  0,  0},
    {230,  0,  0},
    {226,  0,  0},
    {222,  0,  0},
    {218,  0,  0},
    {214,  0,  0},
    {210,  0,  0},
    {206,  0,  0},
    {202,  0,  0},
    {198,  0,  0},
    {194,  0,  0},
    {190,  0,  0},
    {186,  0,  0},
    {182,  0,  0},
    {178,  0,  0},
    {174,  0,  0},
    {170,  0,  0},
    {167,  0,  0},
    {163,  0,  0},
    {159,  0,  0},
    {155,  0,  0},
    {151,  0,  0},
    {147,  0,  0},
    {143,  0,  0},
    {139,  0,  0},
    {135,  0,  0},
    {132,  0,  0},
    {128,  0,  0},
};


/*! \var PDS_COLORMAP_HOT
 *  Mapa de colores HOT
 *  <center>
 *  \image html pds_matrix_save_bmp_with_colormap_hot.bmp "colormap"
 *  \image html colormap_hot.png "red vs green vs blue"
 *  </center>
 *  \ingroup PdsColormapGroup
*/
static const unsigned char PDS_COLORMAP_HOT[256][3]=
{
    { 11,  0,  0},
    { 13,  0,  0},
    { 16,  0,  0},
    { 18,  0,  0},
    { 21,  0,  0},
    { 24,  0,  0},
    { 26,  0,  0},
    { 29,  0,  0},
    { 32,  0,  0},
    { 34,  0,  0},
    { 37,  0,  0},
    { 40,  0,  0},
    { 43,  0,  0},
    { 45,  0,  0},
    { 48,  0,  0},
    { 50,  0,  0},
    { 53,  0,  0},
    { 55,  0,  0},
    { 58,  0,  0},
    { 61,  0,  0},
    { 63,  0,  0},
    { 66,  0,  0},
    { 68,  0,  0},
    { 71,  0,  0},
    { 73,  0,  0},
    { 76,  0,  0},
    { 79,  0,  0},
    { 81,  0,  0},
    { 84,  0,  0},
    { 87,  0,  0},
    { 90,  0,  0},
    { 92,  0,  0},
    { 95,  0,  0},
    { 98,  0,  0},
    {100,  0,  0},
    {102,  0,  0},
    {105,  0,  0},
    {108,  0,  0},
    {110,  0,  0},
    {113,  0,  0},
    {116,  0,  0},
    {118,  0,  0},
    {121,  0,  0},
    {124,  0,  0},
    {127,  0,  0},
    {129,  0,  0},
    {132,  0,  0},
    {134,  0,  0},
    {137,  0,  0},
    {139,  0,  0},
    {142,  0,  0},
    {145,  0,  0},
    {147,  0,  0},
    {150,  0,  0},
    {152,  0,  0},
    {155,  0,  0},
    {157,  0,  0},
    {160,  0,  0},
    {163,  0,  0},
    {165,  0,  0},
    {168,  0,  0},
    {171,  0,  0},
    {173,  0,  0},
    {176,  0,  0},
    {179,  0,  0},
    {182,  0,  0},
    {184,  0,  0},
    {187,  0,  0},
    {189,  0,  0},
    {192,  0,  0},
    {194,  0,  0},
    {197,  0,  0},
    {200,  0,  0},
    {202,  0,  0},
    {205,  0,  0},
    {208,  0,  0},
    {211,  0,  0},
    {213,  0,  0},
    {216,  0,  0},
    {218,  0,  0},
    {221,  0,  0},
    {223,  0,  0},
    {226,  0,  0},
    {229,  0,  0},
    {231,  0,  0},
    {234,  0,  0},
    {236,  0,  0},
    {239,  0,  0},
    {241,  0,  0},
    {244,  0,  0},
    {247,  0,  0},
    {249,  0,  0},
    {252,  0,  0},
    {255,  0,  0},
    {255,  2,  0},
    {255,  5,  0},
    {255,  8,  0},
    {255, 11,  0},
    {255, 13,  0},
    {255, 16,  0},
    {255, 18,  0},
    {255, 21,  0},
    {255, 23,  0},
    {255, 26,  0},
    {255, 29,  0},
    {255, 31,  0},
    {255, 34,  0},
    {255, 37,  0},
    {255, 40,  0},
    {255, 42,  0},
    {255, 45,  0},
    {255, 47,  0},
    {255, 50,  0},
    {255, 52,  0},
    {255, 55,  0},
    {255, 58,  0},
    {255, 60,  0},
    {255, 63,  0},
    {255, 66,  0},
    {255, 68,  0},
    {255, 70,  0},
    {255, 73,  0},
    {255, 76,  0},
    {255, 78,  0},
    {255, 81,  0},
    {255, 84,  0},
    {255, 86,  0},
    {255, 89,  0},
    {255, 92,  0},
    {255, 95,  0},
    {255, 97,  0},
    {255,100,  0},
    {255,102,  0},
    {255,105,  0},
    {255,107,  0},
    {255,110,  0},
    {255,113,  0},
    {255,115,  0},
    {255,118,  0},
    {255,121,  0},
    {255,123,  0},
    {255,126,  0},
    {255,129,  0},
    {255,131,  0},
    {255,134,  0},
    {255,136,  0},
    {255,139,  0},
    {255,141,  0},
    {255,144,  0},
    {255,147,  0},
    {255,150,  0},
    {255,152,  0},
    {255,155,  0},
    {255,157,  0},
    {255,160,  0},
    {255,162,  0},
    {255,165,  0},
    {255,168,  0},
    {255,170,  0},
    {255,173,  0},
    {255,176,  0},
    {255,179,  0},
    {255,181,  0},
    {255,184,  0},
    {255,186,  0},
    {255,189,  0},
    {255,191,  0},
    {255,194,  0},
    {255,197,  0},
    {255,199,  0},
    {255,202,  0},
    {255,205,  0},
    {255,207,  0},
    {255,210,  0},
    {255,213,  0},
    {255,215,  0},
    {255,218,  0},
    {255,220,  0},
    {255,223,  0},
    {255,225,  0},
    {255,228,  0},
    {255,231,  0},
    {255,234,  0},
    {255,236,  0},
    {255,239,  0},
    {255,241,  0},
    {255,244,  0},
    {255,246,  0},
    {255,249,  0},
    {255,252,  0},
    {255,254,  0},
    {255,255,  3},
    {255,255,  7},
    {255,255, 11},
    {255,255, 15},
    {255,255, 19},
    {255,255, 23},
    {255,255, 27},
    {255,255, 31},
    {255,255, 35},
    {255,255, 39},
    {255,255, 43},
    {255,255, 46},
    {255,255, 50},
    {255,255, 54},
    {255,255, 58},
    {255,255, 62},
    {255,255, 66},
    {255,255, 70},
    {255,255, 74},
    {255,255, 78},
    {255,255, 82},
    {255,255, 86},
    {255,255, 90},
    {255,255, 94},
    {255,255, 98},
    {255,255,102},
    {255,255,106},
    {255,255,110},
    {255,255,114},
    {255,255,118},
    {255,255,122},
    {255,255,126},
    {255,255,129},
    {255,255,133},
    {255,255,137},
    {255,255,141},
    {255,255,144},
    {255,255,148},
    {255,255,152},
    {255,255,156},
    {255,255,160},
    {255,255,164},
    {255,255,168},
    {255,255,172},
    {255,255,176},
    {255,255,180},
    {255,255,184},
    {255,255,188},
    {255,255,192},
    {255,255,196},
    {255,255,200},
    {255,255,204},
    {255,255,208},
    {255,255,212},
    {255,255,215},
    {255,255,219},
    {255,255,223},
    {255,255,227},
    {255,255,231},
    {255,255,235},
    {255,255,239},
    {255,255,243},
    {255,255,247},
    {255,255,251},
    {255,255,255},
};


/*! \var PDS_COLORMAP_BONE
 *  Mapa de colores BONE
 *  <center>
 *  \image html pds_matrix_save_bmp_with_colormap_bone.bmp "colormap"
 *  \image html colormap_bone.png "red vs green vs blue"
 *  </center>
 *  \ingroup PdsColormapGroup
*/
static const unsigned char PDS_COLORMAP_BONE[256][3]=
{
    {  0,  0,  1},
    {  1,  1,  2},
    {  2,  2,  3},
    {  3,  3,  5},
    {  4,  4,  6},
    {  5,  5,  7},
    {  5,  5,  8},
    {  6,  6, 10},
    {  7,  7, 11},
    {  8,  8, 12},
    {  9,  9, 13},
    { 10, 10, 15},
    { 11, 11, 16},
    { 12, 12, 17},
    { 12, 12, 18},
    { 13, 13, 20},
    { 14, 14, 21},
    { 15, 15, 22},
    { 16, 16, 23},
    { 17, 17, 24},
    { 18, 18, 26},
    { 19, 19, 27},
    { 19, 19, 28},
    { 20, 20, 29},
    { 21, 21, 31},
    { 22, 22, 32},
    { 23, 23, 33},
    { 24, 24, 34},
    { 25, 25, 35},
    { 25, 25, 36},
    { 26, 26, 37},
    { 27, 27, 38},
    { 28, 28, 40},
    { 29, 29, 41},
    { 30, 30, 42},
    { 31, 31, 43},
    { 32, 32, 44},
    { 32, 32, 46},
    { 33, 33, 47},
    { 34, 34, 48},
    { 35, 35, 49},
    { 36, 36, 51},
    { 37, 37, 52},
    { 37, 37, 53},
    { 38, 38, 54},
    { 39, 39, 56},
    { 40, 40, 57},
    { 41, 41, 58},
    { 42, 42, 59},
    { 43, 43, 61},
    { 44, 44, 62},
    { 45, 45, 63},
    { 46, 46, 64},
    { 46, 46, 65},
    { 47, 47, 67},
    { 48, 48, 68},
    { 49, 49, 69},
    { 50, 50, 70},
    { 51, 51, 71},
    { 52, 52, 72},
    { 52, 52, 73},
    { 53, 53, 74},
    { 54, 54, 76},
    { 55, 55, 77},
    { 56, 56, 78},
    { 57, 57, 79},
    { 58, 58, 81},
    { 59, 59, 82},
    { 59, 59, 83},
    { 60, 60, 84},
    { 61, 61, 85},
    { 62, 62, 87},
    { 63, 63, 88},
    { 64, 64, 89},
    { 65, 65, 90},
    { 66, 66, 92},
    { 66, 66, 93},
    { 67, 67, 94},
    { 68, 68, 95},
    { 69, 69, 97},
    { 70, 70, 98},
    { 71, 71, 99},
    { 72, 72,100},
    { 73, 73,102},
    { 73, 73,103},
    { 74, 74,104},
    { 75, 75,105},
    { 76, 76,106},
    { 77, 77,107},
    { 78, 78,108},
    { 79, 79,109},
    { 79, 79,110},
    { 80, 80,112},
    { 81, 81,113},
    { 82, 82,114},
    { 83, 83,115},
    { 84, 85,116},
    { 85, 86,117},
    { 86, 87,118},
    { 87, 88,118},
    { 88, 90,119},
    { 89, 91,120},
    { 90, 92,121},
    { 90, 93,122},
    { 91, 94,123},
    { 92, 96,124},
    { 93, 97,125},
    { 94, 98,126},
    { 95, 99,127},
    { 96,101,128},
    { 97,102,129},
    { 97,103,129},
    { 98,104,130},
    { 99,106,131},
    {100,107,132},
    {101,108,133},
    {102,109,134},
    {103,111,135},
    {103,112,135},
    {104,113,136},
    {105,114,137},
    {106,115,138},
    {107,117,139},
    {108,118,140},
    {109,119,141},
    {110,120,142},
    {110,121,142},
    {111,122,143},
    {112,123,144},
    {113,124,145},
    {113,126,145},
    {114,127,146},
    {115,128,147},
    {116,129,148},
    {117,131,149},
    {118,132,150},
    {119,133,151},
    {120,134,152},
    {120,135,152},
    {121,137,153},
    {122,138,154},
    {123,139,155},
    {124,140,156},
    {125,142,157},
    {126,143,158},
    {127,144,158},
    {128,145,159},
    {129,147,160},
    {130,148,161},
    {130,149,162},
    {131,150,163},
    {132,152,164},
    {133,153,165},
    {134,154,165},
    {135,155,166},
    {136,156,167},
    {137,157,168},
    {137,158,169},
    {138,159,170},
    {139,160,171},
    {140,162,172},
    {141,163,173},
    {142,164,174},
    {143,165,175},
    {144,167,176},
    {144,168,176},
    {145,169,177},
    {146,170,178},
    {147,172,179},
    {148,173,180},
    {149,174,181},
    {150,175,182},
    {150,176,182},
    {151,178,183},
    {152,179,184},
    {153,180,185},
    {154,181,186},
    {155,183,187},
    {156,184,188},
    {157,185,189},
    {157,186,189},
    {158,188,190},
    {159,189,191},
    {160,190,192},
    {161,191,193},
    {162,192,194},
    {163,193,195},
    {164,194,196},
    {164,195,196},
    {165,196,197},
    {166,198,198},
    {167,199,199},
    {169,200,200},
    {170,201,201},
    {172,202,202},
    {173,203,203},
    {175,203,203},
    {176,204,204},
    {178,205,205},
    {179,206,206},
    {180,207,207},
    {181,208,208},
    {183,209,209},
    {184,210,210},
    {185,211,211},
    {187,212,212},
    {188,213,213},
    {190,213,213},
    {191,214,214},
    {192,215,215},
    {193,216,216},
    {195,217,217},
    {196,218,218},
    {198,218,218},
    {199,219,219},
    {201,220,220},
    {202,221,221},
    {203,222,222},
    {204,223,223},
    {206,223,223},
    {207,224,224},
    {209,225,225},
    {210,226,226},
    {211,227,227},
    {213,228,228},
    {214,229,229},
    {215,230,230},
    {216,230,230},
    {218,231,231},
    {219,232,232},
    {221,233,233},
    {222,234,234},
    {224,235,235},
    {225,236,236},
    {226,236,236},
    {227,237,237},
    {229,238,238},
    {230,239,239},
    {232,240,240},
    {233,241,241},
    {234,242,242},
    {236,243,243},
    {237,243,243},
    {238,244,244},
    {240,245,245},
    {241,246,246},
    {243,247,247},
    {244,248,248},
    {245,249,249},
    {247,250,250},
    {248,250,250},
    {249,251,251},
    {251,252,252},
    {252,253,253},
    {254,254,254},
    {255,255,255},
};


/*! \var PDS_COLORMAP_JOLLY
 *  Mapa de colores JOLLY
 *  <center>
 *  \image html pds_matrix_save_bmp_with_colormap_jolly.bmp "colormap"
 *  \image html colormap_jolly.png "red vs green vs blue"
 *  </center>
 *  \ingroup PdsColormapGroup
*/
static const unsigned char PDS_COLORMAP_JOLLY[256][3]=
{
    {  0,  0,  0},
    {  0,  0,  3},
    {  0,  0,  6},
    {  0,  0,  9},
    {  0,  0, 12},
    {  0,  0, 15},
    {  0,  0, 18},
    {  0,  0, 21},
    {  0,  0, 24},
    {  0,  0, 27},
    {  0,  0, 30},
    {  0,  0, 33},
    {  0,  0, 36},
    {  0,  0, 39},
    {  0,  0, 42},
    {  0,  0, 45},
    {  0,  0, 48},
    {  0,  0, 51},
    {  0,  0, 54},
    {  0,  0, 57},
    {  0,  0, 60},
    {  0,  0, 63},
    {  0,  0, 66},
    {  0,  0, 69},
    {  0,  0, 72},
    {  0,  0, 75},
    {  0,  0, 78},
    {  0,  0, 81},
    {  0,  0, 84},
    {  0,  0, 87},
    {  0,  0, 90},
    {  0,  0, 93},
    {  0,  0, 96},
    {  0,  0, 99},
    {  0,  0,102},
    {  0,  0,105},
    {  0,  0,108},
    {  0,  0,111},
    {  0,  0,114},
    {  0,  0,117},
    {  0,  0,120},
    {  0,  0,123},
    {  0,  0,126},
    {  0,  0,129},
    {  0,  0,132},
    {  0,  0,135},
    {  0,  0,138},
    {  0,  0,141},
    {  0,  0,144},
    {  0,  0,147},
    {  0,  0,150},
    {  0,  0,153},
    {  0,  0,156},
    {  0,  0,159},
    {  0,  0,162},
    {  0,  0,165},
    {  0,  0,168},
    {  0,  0,171},
    {  0,  0,174},
    {  0,  0,177},
    {  0,  0,180},
    {  0,  0,183},
    {  0,  0,186},
    {  0,  0,189},
    {  0,  0,192},
    {  0,  0,195},
    {  0,  0,198},
    {  0,  0,201},
    {  0,  0,204},
    {  0,  0,207},
    {  0,  0,210},
    {  0,  0,213},
    {  0,  0,216},
    {  0,  0,219},
    {  0,  0,222},
    {  0,  0,225},
    {  0,  0,228},
    {  0,  0,231},
    {  0,  0,234},
    {  0,  0,237},
    {  0,  0,240},
    {  0,  0,243},
    {  0,  0,246},
    {  0,  0,249},
    {  0,  0,252},
    {  0,  0,255},
    {  0,  3,252},
    {  0,  6,249},
    {  0,  9,246},
    {  0, 12,243},
    {  0, 15,240},
    {  0, 18,237},
    {  0, 21,234},
    {  0, 24,231},
    {  0, 27,228},
    {  0, 30,225},
    {  0, 33,222},
    {  0, 36,219},
    {  0, 39,216},
    {  0, 42,213},
    {  0, 45,210},
    {  0, 48,207},
    {  0, 51,204},
    {  0, 54,201},
    {  0, 57,198},
    {  0, 60,195},
    {  0, 63,192},
    {  0, 66,189},
    {  0, 69,186},
    {  0, 72,183},
    {  0, 75,180},
    {  0, 78,177},
    {  0, 81,174},
    {  0, 84,171},
    {  0, 87,168},
    {  0, 90,165},
    {  0, 93,162},
    {  0, 96,159},
    {  0, 99,156},
    {  0,102,153},
    {  0,105,150},
    {  0,108,147},
    {  0,111,144},
    {  0,114,141},
    {  0,117,138},
    {  0,120,135},
    {  0,123,132},
    {  0,126,129},
    {  0,129,126},
    {  0,132,123},
    {  0,135,120},
    {  0,138,117},
    {  0,141,114},
    {  0,144,111},
    {  0,147,108},
    {  0,150,105},
    {  0,153,102},
    {  0,156, 99},
    {  0,159, 96},
    {  0,162, 93},
    {  0,165, 90},
    {  0,168, 87},
    {  0,171, 84},
    {  0,174, 81},
    {  0,177, 78},
    {  0,180, 75},
    {  0,183, 72},
    {  0,186, 69},
    {  0,189, 66},
    {  0,192, 63},
    {  0,195, 60},
    {  0,198, 57},
    {  0,201, 54},
    {  0,204, 51},
    {  0,207, 48},
    {  0,210, 45},
    {  0,213, 42},
    {  0,216, 39},
    {  0,219, 36},
    {  0,222, 33},
    {  0,225, 30},
    {  0,228, 27},
    {  0,231, 24},
    {  0,234, 21},
    {  0,237, 18},
    {  0,240, 15},
    {  0,243, 12},
    {  0,246,  9},
    {  0,249,  6},
    {  0,252,  3},
    {  0,255,  0},
    {  3,252,  0},
    {  6,249,  0},
    {  9,246,  0},
    { 12,243,  0},
    { 15,240,  0},
    { 18,237,  0},
    { 21,234,  0},
    { 24,231,  0},
    { 27,228,  0},
    { 30,225,  0},
    { 33,222,  0},
    { 36,219,  0},
    { 39,216,  0},
    { 42,213,  0},
    { 45,210,  0},
    { 48,207,  0},
    { 51,204,  0},
    { 54,201,  0},
    { 57,198,  0},
    { 60,195,  0},
    { 63,192,  0},
    { 66,189,  0},
    { 69,186,  0},
    { 72,183,  0},
    { 75,180,  0},
    { 78,177,  0},
    { 81,174,  0},
    { 84,171,  0},
    { 87,168,  0},
    { 90,165,  0},
    { 93,162,  0},
    { 96,159,  0},
    { 99,156,  0},
    {102,153,  0},
    {105,150,  0},
    {108,147,  0},
    {111,144,  0},
    {114,141,  0},
    {117,138,  0},
    {120,135,  0},
    {123,132,  0},
    {126,129,  0},
    {129,126,  0},
    {132,123,  0},
    {135,120,  0},
    {138,117,  0},
    {141,114,  0},
    {144,111,  0},
    {147,108,  0},
    {150,105,  0},
    {153,102,  0},
    {156, 99,  0},
    {159, 96,  0},
    {162, 93,  0},
    {165, 90,  0},
    {168, 87,  0},
    {171, 84,  0},
    {174, 81,  0},
    {177, 78,  0},
    {180, 75,  0},
    {183, 72,  0},
    {186, 69,  0},
    {189, 66,  0},
    {192, 63,  0},
    {195, 60,  0},
    {198, 57,  0},
    {201, 54,  0},
    {204, 51,  0},
    {207, 48,  0},
    {210, 45,  0},
    {213, 42,  0},
    {216, 39,  0},
    {219, 36,  0},
    {222, 33,  0},
    {225, 30,  0},
    {228, 27,  0},
    {231, 24,  0},
    {234, 21,  0},
    {237, 18,  0},
    {240, 15,  0},
    {243, 12,  0},
    {246,  9,  0},
    {249,  6,  0},
    {252,  3,  0},
    {255,  0,  0},
};

/**
 * @}
 */

#ifdef __cplusplus
}
#endif 

#endif

