

#include <stdlib.h>
#include <pds/pdsra.h>
    
int main(int argc, char** argv)
{
    PdsMatrix *Mat=NULL;
    PdsMatrix *Mat1=NULL;
    PdsMatrix *Mat2=NULL;
    
    PdsRaReal m;
    PdsRaNatural lin,col;
    
    Mat1=pds_matrix_new(3,3);
    Mat2=pds_matrix_new(3,3);
    
    if((Mat1==NULL)||(Mat2==NULL))
    {
        printf("ERROR: The matrix Mat1 or Mat2 could not be created.\n");
        return EXIT_FAILURE;
    }
    
    pds_matrix_init_rand(Mat1);
    printf("Mat1=\n");  pds_matrix_printf(Mat1);
    
    pds_matrix_init_rand(Mat2);
    printf("Mat2=\n");  pds_matrix_printf(Mat2);
    
    Mat=pds_matrix_mul_matrix_new(Mat1,Mat2);
    if(Mat==NULL)
    {
        printf("ERROR: Matrix Mat could not be created.\n");
        return EXIT_FAILURE;
    }
    
    printf("Mat=Mat1*Mat2=\n");
    pds_matrix_printf(Mat);
    
    pds_matrix_get_min_value_and_pos(Mat,&m,&lin,&col);
    printf("MIN::Mat[%d][%d]=%f\n",lin,col,m);
    
    pds_matrix_get_max_value_and_pos(Mat,&m,&lin,&col);
    printf("MAX::Mat[%d][%d]=%f\n",lin,col,m);
    
    pds_matrix_destroy(&Mat);
    if(Mat==NULL) printf("Matrix Mat  has been released and cleaned.\n");
    
    pds_matrix_destroy(&Mat1);
    if(Mat1==NULL) printf("Matrix Mat1 has been released and cleaned.\n");
    
    pds_matrix_destroy(&Mat2);
    if(Mat2==NULL) printf("Matrix Mat2 has been released and cleaned.\n");
    
    return EXIT_SUCCESS;
}
