/*
 * testprog6.c
 * 
 * Copyright 2018 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprog6.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-07-2018
 *  \brief Programa para el testeo de las funciones de estatistica.
 *  
 */

#include <stdlib.h>
#include <pds/pdsra.h>

int main(int argc, char** argv)
{
    PdsRegionRect A=pds_region_rect(0,0,7,8);
    PdsRegionRect B=pds_region_rect(2,3,2,2);

    printf("Region A:");    pds_region_rect_stylized_fprintf(stdout,A);
    printf("Region B:");    pds_region_rect_stylized_fprintf(stdout,B);

    PdsRegionRect R;
    int ID=pds_region_rect_intersection(A,B,&R);
    if( ID==PDS_OK )
    {   
        printf("Intereseccion{A,B}:");
        pds_region_rect_stylized_fprintf(stdout,R);
    }
    else    printf("No existe interesecion\n");

    if(pds_region_rect_is_inside(B,A)==PDS_OK)
        printf("B está dentro de A\n");
    else    printf("B NO está dentro de A\n");

	return EXIT_SUCCESS;
}
