<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

if (isset($_GET['mode']))
{
	$mode = $_GET['mode'];
}
else
{
	$mode = "normal";
}

if (isset($_POST['user_id']))
{
	$user_id = $_POST['user_id'];
}
else
{
	$user_id = $_SESSION['userid'];
}

$req = Requete ("SELECT * FROM users WHERE user_id = $user_id;",$conn);

while ($rs = ObjetSuivant($req))
{
	$user_nom = $rs->user_nom;
	$user_prenom = $rs->user_prenom;
}

if (isset($_POST['periode']))
{
	switch ($_POST['periode'])
	{
		case 1:
			$periode = "AND YEAR(pre_date) = ".date('Y')." AND MONTH(pre_date) = ".date('m');
			break;
		case 2:
			$periode = "AND DATEDIFF(NOW(),pre_date) < 93";
			break;
		case 3:
			$periode = "AND YEAR(pre_date) = ".date('Y');
			break;
		case 4:
			$periode = "";
			break;
		default:
			$periode = "";
			break;
	}
	$prd = $_POST['periode'];
}
else
{
	$periode = "";
	$prd = 4;
}

if ($mode == 'normal')
{
	$args = "?user_id=$user_id&periode=$prd&mode=$mode";
}
else
{
	$args = "?mode=$mode&periode=$prd";
}
?>

<div class="content">

	<p><a href="javascript:void();" onClick="javascript:window.open('prestations_impr.php<?php echo $args; ?>');"><img src="images/impr.jpg" border="0"></a><?php if ($mode != 'all_users') { ?>&nbsp;&nbsp;<a href="prestations.php?mode=all_users"><?php echo TXT_PRESTATIONS_AFFICHER_PRESTA_TOUE_LE_MONDE; ?></a><?php } ?></p>
	
	<form name="list_prestations" action="prestations.php?mode=<?php echo $mode; ?>" method="post">
		<p>
			
<?php
if ($mode != 'all_users')
{
	echo "<strong>".TXT_PRESTATIONS_AFFICHER_PRESTA_DE."</strong>\n";
	echo "<select name=\"user_id\">\n";
	$req = Requete ("SELECT * FROM users ORDER BY user_nom;",$conn);

	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"$rs->user_id\">$rs->user_prenom $rs->user_nom</option>\n";
	}
	echo "</select>\n";
}
else
{
	echo "<strong>".TXT_PRESTATIONS_AFFICHER_PRESTA."</strong>\n";
}
?>
			
			<select name="periode">
				<option value="1"><?php echo TXT_PRESTATIONS_DEPUIS_DEBUT_MOIS; ?></option>
				<option value="2"><?php echo TXT_PRESTATIONS_TROIS_DERNIERS_MOIS; ?></option>
				<option value="3"><?php echo TXT_PRESTATIONS_DEBUT_ANNEE; ?></option>
				<option value="4"><?php echo TXT_PRESTATIONS_TOUTES; ?></option>
			</select>
			<input type="submit" class="bouton" value="<?php echo TXT_PRESTATIONS_OK; ?>">
		</p>
	</form>
	
	<form class="text" name="export" action="process_export.php" method="post">
			<p>
				<strong><?php echo TXT_PRESTATIONS_EXPORTER_PRESTA; ?></strong>
				<select name="user_id">
					<option value="0" selected><?php echo TXT_PRESTATIONS_TOUT_LE_MONDE; ?></option>

<?php
$req = Requete ("SELECT * FROM users ORDER BY user_nom;",$conn);

while ($rs = ObjetSuivant($req))
{
	echo "<option value=\"$rs->user_id\">$rs->user_nom $rs->user_prenom</option>\n";
}

?>

				</select>
				<input type="hidden" name="exptype" value="1">
				<input class="bouton" type="submit" value="<?php echo TXT_PRESTATIONS_OK; ?>">
			</p>
		</form>

	<br />

<?php	

if ($mode == 'all_users')
{
	echo "<h2>Toutes les prestations</h2>\n";
	$sql = "SELECT * FROM prestations, projets, ";
	if ($_SESSION['conf_taches'])
	{
		$sql .= "taches, ";
	}
	$sql .= "lieux, users WHERE prestations.pre_fk_projet = projets.proj_id ";
	if ($_SESSION['conf_taches'])
	{
		$sql .= "AND prestations.pre_fk_tache = taches.tache_id ";
	}
	$sql .= "AND lieux.lieu_id = prestations.pre_fk_lieu AND users.user_id = prestations.pre_fk_user $periode ORDER BY pre_date DESC;";
}
else
{
	echo "<h2>prestations de $user_prenom $user_nom</h2>\n";
	$sql = "SELECT * FROM prestations, projets, ";
	if ($_SESSION['conf_taches'])
	{
		$sql .= "taches, ";
	}
	$sql .= "lieux WHERE prestations.pre_fk_user = $user_id AND prestations.pre_fk_projet = projets.proj_id ";
	if ($_SESSION['conf_taches'])
	{
		$sql .= "AND prestations.pre_fk_tache = taches.tache_id ";
	}
	$sql .= "AND lieux.lieu_id = prestations.pre_fk_lieu $periode ORDER BY pre_date DESC;";
}
$req = Requete ($sql,$conn);

if (NombreLignes($req) > 0)
{
?>

	<table border="0" width="100%" align="center" cellpadding="3" cellspacing="0">
		<tr>
			<th><?php echo TXT_PRESTATIONS_DATE; ?></th>
<?php
if ($mode == 'all_users')
{
	echo "<th>".TXT_PRESTATIONS_NOM."</th>\n";
}
?>
			<th><?php echo TXT_PRESTATIONS_LIEU; ?></th>
			<th><?php echo TXT_PROJET_PROJET; ?></th>
<?php
if ($_SESSION['conf_taches'])
{
?>
			<th><?php echo TXT_TACHE_TACHE; ?></th>
<?php
}
?>
			<th><?php echo TXT_PRESTATIONS_HEURES; ?></th>
			<th><?php echo TXT_PRESTATIONS_A_FAIT_QUOI; ?></th>
			<th><?php echo TXT_PRESTATIONS_ACTIONS; ?></th>
		</tr>
		
<?php
	$count = 0;
	while ($rs = ObjetSuivant($req))
	{
		$count += 1;
		if ($count % 2 > 0)
		{
			$class = "data1";
		}
		else
		{
			$class = "data2";
		}
		echo "<tr class=\"".$class."\">\n";
		echo "<td>".day_month_year($rs->pre_date)."</td>\n";
		if ($mode == 'all_users')
		{
			echo "<td>".$rs->user_prenom." ".$rs->user_nom."</td>\n";
		}
		echo "<td>".$rs->lieu_nom."</td>\n";
		echo "<td>".$rs->proj_titre_abr."</td>\n";
		if ($_SESSION['conf_taches'])
		{
			echo "<td>".$rs->tache_nom."</td>\n";
		}
		echo "<td>".heures($rs->pre_heures)."</td>\n";
		if (is_null($rs->pre_desc))
		{
			echo "<td>&nbsp;</td>\n";
		}
		else
		{
			echo "<td>".$rs->pre_desc."</td>\n";
		}
		echo "<td class=\"cellright\">\n";
		echo "<a href=\"prest_detail.php?prev=list&id=".$rs->pre_id."\"><img src=\"images/b_search.png\" border=\"0\" alt=\"".TXT_PRESTATIONS_DETAILS."\" title=\"".TXT_PRESTATIONS_DETAILS."\"></a>&nbsp;";
		if (($mode == 'normal' && $user_id == $_SESSION['userid']) || $_SESSION['level'] == 0)
		{
			echo "<a href=\"mod_prest_date.php?prev=list&id=".$rs->pre_id."\"><img src=\"images/b_edit.gif\" border=\"0\" alt=\"".TXT_PRESTATIONS_MODIFIER."\" title=\"".TXT_PRESTATIONS_MODIFIER."\"></a>&nbsp;";
		}
		if ($_SESSION['level'] == 0)
		{
			echo "<a href=\"delete.php?mode=prest&id=".$rs->pre_id."\"><img src=\"images/b_drop.gif\" border=\"0\" alt=\"".TXT_PRESTATIONS_SUPPRIMER."\" title=\"".TXT_PRESTATIONS_SUPPRIMER."\"></a>";
		}
		echo "</td>\n";
		echo "</tr>\n";
	}
	echo "</table>\n";
}
else
{
	echo "<p>".TXT_PRESTATIONS_AUCUNE_PRESTA_ENCODEE."</p>\n";
}
?>

<br />

</div>

<?php
require_once ('include/footer.php');
?>