<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

if (isset($_POST['pre_date']))
{
	$pre_date = $_POST['pre_date'];
	if (isset($_SESSION['ses_pre_date']))
	{
		unset($_SESSION['ses_pre_date']);
	}
}
elseif (isset($_GET['date']))
{
	$pre_date = $_GET['date'];
	if (isset($_SESSION['ses_pre_date']))
	{
		unset($_SESSION['ses_pre_date']);
	}
}
else
{
	$pre_date = $_SESSION['ses_pre_date'];
}
$pre_desc = "";
$user_id = $_SESSION['userid'];
$lieu_id = 0;
$zone_id = 0;
$depl_id = 0;
$prod_id = 0;
$pre_heures = "";
$proj_id = 0;
if (!isset($_SESSION['ses_proj_id']))
{
	$_SESSION['ses_proj_id'] = 0;
}
$dom_id = 0;
if (!isset($_SESSION['ses_dom_id']))
{
	$_SESSION['ses_dom_id'] = 0;
}
$tache_id = 0;
$pre_remarques = "";
?>

<div class="content">

<?php
if ($pre_date > date ('Y-m-d'))
{
	echo "<h4 class=\"error\">".TXT_ADD_PRESTATION_ERREUR_SAISIE_IMPOSSIBLE."<br />".TXT_ADD_PRESTATION_ERREUR_DATE_SUPERIEURE."</h4>\n";
	exit;
}

if (!isset($_GET['mode']))
{
?>
	<h2>
		<input type="button" class="bouton" value="<?php echo TXT_ADD_PRESTATION_JOUR_PRECEDENT; ?>" onClick="javascript:document.location.href='add_prestation.php?date=<?php echo JourPrecedent($pre_date); ?>';">
		&nbsp;&nbsp;
		<?php echo TXT_ADD_PRESTATION_VOS_PRESTATIONS_DU; ?><?php echo day_month_year($pre_date); ?>
		&nbsp;&nbsp;
		<input type="button" class="bouton" value="<?php echo TXT_ADD_PRESTATION_JOUR_SUIVANT; ?>" onClick="javascript:document.location.href='add_prestation.php?date=<?php echo JourSuivant($pre_date); ?>';">
	</h2>

<?php
}
if (isset($_POST['form_mode']))
{
	if (strlen($_POST['pre_desc']) > 0)
	{
		$pre_desc = htmlentities($_POST['pre_desc']);
	}
	else
	{
		$pre_desc = "";
	}
	if (strlen($_POST['pre_remarques']) > 0)
	{
		$pre_remarques = htmlentities($_POST['pre_remarques']);
	}
	else
	{
		$pre_remarques = "";
	}
	$user_id = $_POST['user_id'];
	$lieu_id = $_POST['lieu_id'];
	if (isset($_POST['zone_id']))
	{
		$zone_id = $_POST['zone_id'];
	}
	if (isset($_POST['depl_id']))
	{
		$depl_id = $_POST['depl_id'];
	}
	if (isset($_POST['prod_id']))
	{
		$prod_id = $_POST['prod_id'];
	}
	$pre_heures = $_POST['pre_heures'];
	$proj_id = $_POST['proj_id'];
	if (isset($_POST['dom_id']))
	{
		$dom_id = $_POST['dom_id'];
	}
	if (isset($_POST['tache_id']))
	{
		$tache_id = $_POST['tache_id'];
	}
	
	if ($proj_id != $_SESSION['ses_proj_id'])
	{
		$dom_id = 0;
		$tache_id = 0;
	}
	if ($dom_id != $_SESSION['ses_dom_id'])
	{
		$tache_id = 0;
	}
	
	$_SESSION['ses_proj_id'] = $proj_id;
	$_SESSION['ses_dom_id'] = $dom_id;
	
	if ($_POST['form_mode'] == '0')
	{
		$error = FALSE;
		
		if ($pre_heures == "" || $proj_id < 1 || ($_SESSION['conf_domaines'] && $dom_id < 1) || ($_SESSION['conf_taches'] && $tache_id < 1))
		{
			$error = TRUE;
			$err_msg = "<h4 class=\"error\">".TXT_ADD_PRESTATION_VOUS_AVEZ_OUBLIE_CHAMPS_OBLIGATOIRES."</h4>\n";
		}
		
		if ($error)
		{
			echo $err_msg;
		}
		else
		{
			unset($_SESSION['ses_proj_id'], $_SESSION['ses_dom_id']);
			$_SESSION['ses_pre_date'] = $pre_date;
			
			$sql = "SELECT * FROM prestations ORDER BY pre_id DESC LIMIT 1;";
			$req = Requete ($sql,$conn);
			$ok = FALSE;
			while ($rs = ObjetSuivant($req))
			{
				$pre_id = $rs->pre_id + 1;
				$ok = TRUE;
			}
			if (!$ok)
			{
				$pre_id = 1;
			}
			$sql = "INSERT INTO prestations "
				. "(pre_id,pre_fk_user,pre_fk_projet,pre_fk_domaine,pre_fk_tache,pre_date,"
				. "pre_heures,pre_fk_lieu,pre_fk_deplacement,pre_fk_produit,pre_desc,pre_remarques,pre_fk_zone) "
				. "VALUES ($pre_id,$user_id,$proj_id,$dom_id,$tache_id,'$pre_date',"
				. "$pre_heures,$lieu_id,$depl_id,$prod_id,'$pre_desc','$pre_remarques',$zone_id);";
			$req = Requete ($sql,$conn);
			
			echo "<h2>".TXT_ADD_PRESTATION_VOTRE_PRESTATION_EST_ENREGISTREE."</h2>\n";
			echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_ADD_PRESTATION_AJOUTER_PRESTATION_MEME_DATE."(".day_month_year($pre_date).")\" onClick=\"javascript:document.location.href='add_prestation.php';\"><br />\n";
			echo "<input type=\"button\" class=\"bouton\" value=\"".TXT_ADD_PRESTATION_AJOUTER_PRESTATION_DATE_DIFFERENTE."\" onClick=\"javascript:document.location.href='add_prest_date.php';\"><br />\n";
			echo "</div>";
			require_once ('include/footer.php');
			exit;
		}
	}
}

$sql = "SELECT * FROM prestations, projets, ";
if ($_SESSION['conf_taches'])
{
	$sql .= "taches, ";
}
$sql .= "lieux, zones WHERE prestations.pre_fk_user = ".$_SESSION['userid']." AND prestations.pre_fk_projet = projets.proj_id ";
if ($_SESSION['conf_taches'])
{
	$sql .= "AND prestations.pre_fk_tache = taches.tache_id ";
}
$sql .= "AND lieux.lieu_id = prestations.pre_fk_lieu AND zones.zone_id = prestations.pre_fk_zone AND pre_date = '$pre_date' ORDER BY pre_id;";
$req = Requete ($sql,$conn);

if (NombreLignes($req) > 0)
{
?>

	<table border="0" width="100%" align="center" cellpadding="3" cellspacing="0">
		<tr>
			<th><?php echo TXT_ADD_PRESTATION_LIEU; ?></th>
			<th><?php echo TXT_PROJET_PROJET; ?></th>
<?php
if ($_SESSION['conf_taches'])
{
?>
			<th><?php echo TXT_TACHE_TACHE; ?></th>
<?php
}
?>
			<th><?php echo TXT_ADD_PRESTATION_HEURES; ?></th>
			<th><?php echo TXT_ADD_PRESTATION_A_FAIT_QUOI; ?></th>
			<th><?php echo TXT_ADD_PRESTATION_ACTIONS; ?></th>
		</tr>
		
<?php
	$count = 0;
	$total_heures = 0;
	while ($rs = ObjetSuivant($req))
	{
		$count += 1;
		if ($count % 2 > 0)
		{
			$class = "data1";
		}
		else
		{
			$class = "data2";
		}
		echo "<tr class=\"".$class."\">\n";
		echo "<td>".$rs->lieu_nom."</td>\n";
		echo "<td>".$rs->proj_titre_abr."</td>\n";
		if ($_SESSION['conf_taches'])
		{
			echo "<td>".$rs->tache_nom."</td>\n";
		}
		echo "<td>".heures($rs->pre_heures)."</td>\n";
		if (is_null($rs->pre_desc))
		{
			echo "<td>&nbsp;</td>\n";
		}
		else
		{
			echo "<td>".$rs->pre_desc."</td>\n";
		}
		echo "<td class=\"cellright\">\n";
		echo "<a href=\"prest_detail.php?prev=new&prdate=$pre_date&id=".$rs->pre_id."\"><img src=\"images/b_search.png\" border=\"0\" alt=\"".TXT_ADD_PRESTATION_DETAILS."\" title=\"".TXT_ADD_PRESTATION_DETAILS."\"></a>&nbsp;";
		echo "<a href=\"mod_prest_date.php?prev=new&pdate=$pre_date&id=".$rs->pre_id."\"><img src=\"images/b_edit.gif\" border=\"0\" alt=\"".TXT_ADD_PRESTATION_MODIFIER."\" title=\"".TXT_ADD_PRESTATION_MODIFIER."\"></a>&nbsp;";
		echo "<a href=\"delete.php?mode=prest&id=".$rs->pre_id."\"><img src=\"images/b_drop.gif\" border=\"0\" alt=\"".TXT_ADD_PRESTATION_SUPPRIMER."\" title=\"".TXT_ADD_PRESTATION_SUPPRIMER."\"></a>";
		echo "</td>\n";
		echo "</tr>\n";
		$total_heures += $rs->pre_heures;
	}
	echo "</table><br />\n";
	echo "<p><strong>".TXT_ADD_PRESTATION_TOTAL_HEURES_CE_JOUR.heures($total_heures)."</strong></p>\n";
	echo "<br />\n";
}
else
{
	echo "<h4>".TXT_ADD_PRESTATION_AUCUNE_PRESTATION_LE.day_month_year($pre_date)."</h4>\n";
}

?>

	<form name="add_prestation" action="add_prestation.php?mode=check" method="post" onSubmit="this['form_mode'].value='0';">
		<input type="hidden" name="form_mode" value="reload">
		<input type="hidden" name="pre_date" value="<?php echo $pre_date; ?>">
	
		<table width="80%" align="center" cellpadding="3" cellspacing="3">
			<tr>
				<th colspan="2"><?php echo TXT_ADD_PRESTATION_AJOUTER_PRESTATION; ?></th>
			</tr>
			<tr>
				<td class="cellright"><?php echo TXT_ADD_PRESTATION_QUI; ?></td>
<?php
if ($_SESSION['level'] > 0)
{
?>
				<td class="cellleft"><?php echo $_SESSION['userfirstname']." ".$_SESSION['username']; ?><input type="hidden" name="user_id" value="<?php echo $_SESSION['userid']; ?>"></td>
<?php
}
else
{
?>
				<td class="cellleft">
					<select name="user_id">
<?php
$req = Requete ("SELECT * FROM users ORDER BY user_nom;",$conn);
while ($rs = ObjetSuivant($req))
{
	echo "<option value=\"".$rs->user_id."\"";
	if ($rs->user_id == $user_id)
	{
		echo " selected";
	}
	echo ">".$rs->user_prenom." ".$rs->user_nom."</option>\n";
}
?>
					</select>
				</td>
<?php
}
?>
			</tr>
			<tr>
				<td class="cellright" valign="top"><?php echo TXT_ADD_PRESTATION_A_FAIT_QUOI; ?></td>
				<td class="cellleft"><textarea name="pre_desc" cols="50" rows="5"><?php echo stripslashes($pre_desc); ?></textarea></td>
			</tr>
			<tr>
				<td class="cellright"><?php echo TXT_ADD_PRESTATION_OU; ?></td>
				<td class="cellleft">
					<select name="lieu_id">
					
<?php
$req = Requete ("SELECT * FROM lieux ORDER BY lieu_nom;",$conn);
while ($rs = ObjetSuivant($req))
{
	echo "<option value=\"".$rs->lieu_id."\"";
	if ($rs->lieu_id == $lieu_id)
	{
		echo " selected";
	}
	echo ">".$rs->lieu_nom."</option>\n";
}
?>
					
					</select>
<?php
if ($_SESSION['conf_deplacements'])
{
?>
					<select name="depl_id">		
<?php
	$req = Requete ("SELECT * FROM deplacements ORDER BY depl_id;",$conn);
	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"".$rs->depl_id."\"";
		if ($rs->depl_id == $depl_id)
		{
			echo " selected";
		}
		echo ">".$rs->depl_nom."</option>\n";
	}
?>
					
					</select>
<?php
}
?>
				</td>
			</tr>
<?php
if ($_SESSION['conf_zones'])
{
?>
			<tr>
				<td class="cellright"><?php echo TXT_ADD_PRESTATION_POUR_QUEL_REGROUPEMENT; ?></td>
				<td class="cellleft">
					<select name="zone_id">
					
<?php
	$req = Requete ("SELECT * FROM zones WHERE zone_isactive = 1 ORDER BY zone_ordre;",$conn);
	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"".$rs->zone_id."\"";
		if ($rs->zone_id == $zone_id)
		{
			echo " selected";
		}
		echo ">".$rs->zone_nom."</option>\n";
	}
?>
					
					</select>
				</td>
			</tr>
<?php
}
if ($_SESSION['conf_produits'])
{
?>
			<tr>
				<td class="cellright"><?php echo TXT_ADD_PRESTATION_POUR_QUEL_PRODUIT; ?></td>
				<td class="cellleft">
					<select name="prod_id">
					
<?php
	$req = Requete ("SELECT * FROM produits ORDER BY prod_nom;",$conn);
	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"".$rs->prod_id."\"";
		if ($rs->prod_id == $prod_id)
		{
			echo " selected";
		}
		echo ">".$rs->prod_nom."</option>\n";
	}
?>
					
					</select>
				</td>
			</tr>
<?php
}
?>
			<tr>
				<td class="cellright"><?php echo TXT_ADD_PRESTATION_PENDANT_COMBIEN_DE_TEMPS; ?></td>
				<td class="cellleft"><input type="text" class="gen" name="pre_heures" value="<?php echo $pre_heures; ?>"size="5"> <span class="tablecomment"><?php echo TXT_ADD_PRESTATION_EXEMPLES; ?></span></td>
			</tr>
			<tr>
				<td class="cellright"><?php echo TXT_PROJET_POUR_QUEL_PROJET; ?> * </td>
				<td class="cellleft">
					<select name="proj_id"<?php if($_SESSION['conf_domaines']){ ?> onChange="javascript:document.forms[0].form_mode.value='1';document.forms[0].submit();"<?php } ?>>

<?php
echo "<option value=\"0\"";
if ($proj_id == 0)
{
	echo " selected";
}
echo ">--".TXT_PROJET_CHOISISSEZ_UN_PROJET."--</option>\n";
$req = Requete ("SELECT * FROM projets WHERE proj_isarchive = 0 ORDER BY proj_titre_abr;",$conn);
while ($rs = ObjetSuivant($req))
{
	echo "<option value=\"$rs->proj_id\"";
	if ($rs->proj_id == $proj_id)
	{
		echo " selected";
	}
	echo ">$rs->proj_titre_abr</option>\n";
}
?>

					</select>
				</td>
			</tr>
<?php
if ($_SESSION['conf_domaines'])
{
?>
			<tr>
				<td class="cellright"><?php echo TXT_DOMAINE_POUR_QUEL_DOMAINE; ?> * </td>
				<td class="cellleft">

<?php
	echo "<select name=\"dom_id\"";
	if ($_SESSION['conf_taches'])
	{
		echo " onChange=\"javascript:document.forms[0].form_mode.value='2';document.forms[0].submit();\"";
	}
	if ($proj_id > 0)
	{
		echo ">\n";
		echo "<option value=\"0\"";
		if ($dom_id == 0)
		{
			echo " selected";
		}
		echo ">--".TXT_DOMAINE_CHOISISSEZ_UN_DOMAINE."--</option>\n";
		$sql = "SELECT * FROM proj_dom, domaines WHERE pd_fk_projet = $proj_id AND proj_dom.pd_fk_domaine = domaines.dom_id AND NOT (domaines.dom_id = 0) ORDER BY dom_id;";
		$req = Requete ($sql,$conn);
		while ($rs = ObjetSuivant($req))
		{
			echo "<option value=\"$rs->dom_id\"";
			if ($rs->dom_id == $dom_id)
			{
				echo " selected";
			}
			echo ">$rs->dom_id $rs->dom_nom</option>\n";
		}
	}
	else
	{
		echo " disabled>\n";
		echo "<option value=\"0\">--".TXT_PROJET_CHOISISSEZ_D_ABORD_UN_PROJET."--</option>\n";
	}
?>

					</select>
				</td>
			</tr>
<?php
}
if ($_SESSION['conf_taches'])
{
?>
			<tr>
				<td class="cellright"><?php echo TXT_TACHE_POUR_QUELLE_TACHE; ?> * </td>
				<td class="cellleft">

<?php
	echo "<select name=\"tache_id\"";
	if ($_SESSION['conf_domaines'])
	{
		$req = Requete ("SELECT * FROM dom_taches, taches WHERE dom_taches.dt_fk_domaine = $dom_id AND dom_taches.dt_fk_tache = taches.tache_id AND NOT (taches.tache_id = 0) ORDER BY tache_nom;",$conn);
		if ($dom_id > 0)
		{
			echo ">\n";
			echo "<option value=\"0\"";
			if ($tache_id == 0)
			{
				echo " selected";
			}
			echo ">--".TXT_TACHE_CHOISISSEZ_UNE_TACHE."--</option>\n";
		}
		else
		{
			echo " disabled>\n";
			echo "<option value=\"0\" selected>--".TXT_DOMAINE_CHOISISSEZ_D_ABORD_UN_DOMAINE."--</option>\n";
		}
	}
	else
	{
		$req = Requete ("SELECT * FROM taches WHERE NOT (tache_id = 0) ORDER BY tache_nom;",$conn);
		echo ">\n";
	}
	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"$rs->tache_id\"";
		if ($rs->tache_id == $tache_id)
		{
			echo " selected";
		}
		echo ">$rs->tache_nom</option>\n";
	}
?>

					</select>
				</td>
			</tr>
<?php
}
?>
			<tr>
				<td class="cellright" valign="top"><?php echo TXT_ADD_PRESTATION_REMARQUES; ?></td>
				<td class="cellleft"><textarea name="pre_remarques" cols="50" rows="5"><?php echo stripslashes($pre_remarques); ?></textarea></td>
			</tr>
			<tr>
				<td colspan="2" class="cellcenter">
					<input type="submit" class="bouton" value="<?php echo TXT_ADD_PRESTATION_AJOUTER; ?>">
				</td>
			</tr>
			<tr>
				<td colspan="2" class="tablecomment"><?php echo TXT_ADD_PRESTATION_CHAMPS_OBLIGATOIRES; ?></td>
			</tr>
		</table>
	</form>
	
	<br />

</div>

<?php
require_once ('include/footer.php');
?>