<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

$id_field = $_GET['id'];
$mode = $_GET['mode'];

$chaine = "";
$ok = TRUE;
$prev_get = "";

if (isset($_GET['prev']))
{
	$prev = $_GET['prev'];
}

if ($id_field == 0 && !($id_field == 'all' && $mode = 'csv'))
{
	require_once ('include/header.php');
	require_once ('include/menu.php');
	require_once ("include/date_functions.php");
	
	echo "<div class=\"content\">\n";
	
	echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." ".TXT_DELETE_CETTE_VALEUR."</h2>\n";
	echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
	exit;
}
else
{	
	if (isset($_GET['conf']) && $_GET['conf'] == 1)
	{
		session_start();
		require_once ("include/checklogin.php");
		if ($mode != 'postit')
		{
			require_once ("include/checklevel.php");
		}
		
		switch($mode)
		{
			case 'prest':
				$sql = "DELETE FROM prestations WHERE pre_id = $id_field;";
				$req = Requete ($sql, $conn);
				header("Location: prestations.php");
				break;
			case 'user':
				$sql = "DELETE FROM users WHERE user_id = $id_field;";
				$req = Requete ($sql, $conn);
				header("Location: users.php");
				break;
			case 'csv':
				if ($id_field == 'all')
				{
					$sql = "SELECT * FROM fichiers_csv;";
				}
				else
				{
					$sql = "SELECT * FROM fichiers_csv WHERE csv_id = $id_field;";
				}
				$req = Requete ($sql, $conn);
				while ($rs = ObjetSuivant($req))
				{
					$file = "datafiles/".$rs->csv_fichier;
					unlink($file);
				}
				if ($id_field == 'all')
				{
					$sql = "DELETE FROM fichiers_csv;";
				}
				else
				{
					$sql = "DELETE FROM fichiers_csv WHERE csv_id = $id_field;";
				}
				$req = Requete ($sql, $conn);
				header("Location: fichiers_csv.php");
				break;
			case 'postit':
				$req = Requete ("SELECT * FROM postits WHERE post_id = $id_field;", $conn);
				while ($rs = ObjetSuivant($req))
				{
					$del_by_aut = $rs->post_deleted_by_aut;
					$del_by_dest = $rs->post_deleted_by_dest;
					if ($rs->post_fk_aut == $_SESSION['userid'])
					{
						$set = "post_deleted_by_aut=1";
						$del_by_aut = 1;
					}
					if ($rs->post_fk_dest == $_SESSION['userid'])
					{
						$set = "post_deleted_by_dest=1";
						$del_by_dest = 1;
					}
				}
				if ($del_by_aut == 1 && $del_by_dest == 1)
				{
					$sql = "DELETE FROM postits WHERE post_id = $id_field;";
					$req = Requete ($sql, $conn);
				}
				else
				{
					$sql = "UPDATE postits SET $set WHERE post_id = $id_field;";
					$req = Requete ($sql, $conn);
				}
				switch ($prev)
				{
					case 'accueil':
						header("Location: accueil.php");
						break;
					case 'new':
						header("Location: add_postit.php");
						break;
				}
				break;
			case 'projet':
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_projet = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					$item = TXT_PROJET_CE_PROJET;
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$sql = "DELETE FROM proj_dom WHERE pd_fk_projet = $id_field;";
				$req = Requete ($sql, $conn);
				$sql = "DELETE FROM projets WHERE proj_id = $id_field;";
				$req = Requete ($sql, $conn);
				header("Location: projets.php");
				break;
			case 'domaine':
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_domaine = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					$item = TXT_DOMAINE_CE_DOMAINE;
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER."</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$sql = "DELETE FROM proj_dom WHERE pd_fk_domaine = $id_field;";
				$req = Requete ($sql, $conn);
				$sql = "DELETE FROM dom_taches WHERE dt_fk_domaine = $id_field;";
				$req = Requete ($sql, $conn);
				$sql = "DELETE FROM domaines WHERE dom_id = $id_field;";
				$req = Requete ($sql, $conn);
				header("Location: domaines.php");
				break;
			case 'tache':
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_tache = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					$item = TXT_TACHE_CETTE_TACHE;
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$sql = "DELETE FROM dom_taches WHERE dt_fk_tache = $id_field;";
				$req = Requete ($sql, $conn);
				$sql = "DELETE FROM taches WHERE tache_id = $id_field;";
				$req = Requete ($sql, $conn);
				header("Location: taches.php");
				break;
			case 'produit':
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_produit = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					$item = "ce produit";
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$sql = "DELETE FROM produits WHERE prod_id = $id_field;";
				$req = Requete ($sql, $conn);
				header("Location: produits.php");
				break;
			case 'lieu':
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_lieu = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					$item = "ce lieu";
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$sql = "DELETE FROM lieux WHERE lieu_id = $id_field;";
				$req = Requete ($sql, $conn);
				header("Location: lieux.php");
				break;
			case 'zone':
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_zone = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					$item = "cette zone";
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$sql = "DELETE FROM zones WHERE zone_id = $id_field;";
				$req = Requete ($sql, $conn);
				header("Location: zones.php");
				break;
		}
	}
	else
	{
		require_once ('include/header.php');
		require_once ('include/menu.php');
		require_once ("include/date_functions.php");
		
		echo "<div class=\"content\">\n";
		
		if ($mode != 'postit')
		{
			require_once ("include/checklevel.php");
		}
		
		switch($mode)
		{
			case 'user':
				$item = TXT_DELETE_CET_UTILISATEUR;
				$chaine .= "<table border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
				$chaine .= "<tr>\n<th>".TXT_DELETE_NOM."</th>\n<th>".TXT_DELETE_PRENOM."</th>\n</tr>\n";
				$req = Requete ("SELECT * FROM users WHERE user_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<tr class=\"data1\">\n";
					$chaine .= "<td>".$rs->user_nom."</td>\n";
					$chaine .= "<td>".$rs->user_prenom."</td>\n";
					$chaine .= "</tr>\n";
				}
				$chaine .= "</table>\n";
				break;
			case 'csv':
				if ($id_field == 'all')
				{
					$item = TXT_DELETE_TOUS_LES_FICHIERS;
					$chaine = "";
				}
				else
				{
					$item = TXT_DELETE_CE_FICHIER;
					$chaine .= "<table border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
					$chaine .= "<tr>\n<th>".TXT_DELETE_DATE."</th>\n<th>".TXT_DELETE_NOM_FICHIER."</th>\n</tr>\n";
					$req = Requete ("SELECT * FROM fichiers_csv WHERE csv_id = $id_field;",$conn);
					while ($rs = ObjetSuivant($req))
					{
						$chaine .= "<tr class=\"data1\">\n";
						$chaine .= "<td>".day_month_year($rs->csv_date)."</td>\n";
						$chaine .= "<td>".$rs->csv_fichier."</td>\n";
						$chaine .= "</tr>\n";
					}
					$chaine .= "</table>\n";
				}
				break;
			case 'prest':
				$item = TXT_DELETE_CETTE_PRESTATION;
				$chaine .= "<table border=\"0\" width=\"100%\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
				$chaine .= "<tr>\n<th>".TXT_DELETE_DATE."</th>\n<th>".TXT_DELETE_LIEU."</th>\n<th>".TXT_DELETE_PROJET."</th>\n<th>".TXT_DELETE_TACHE."</th>\n<th>".TXT_DELETE_HEURES."</th>\n<th>".TXT_DELETE_REMARQUES."</th>\n</tr>\n";
				$req = Requete ("SELECT * FROM prestations, projets, taches, lieux WHERE prestations.pre_fk_projet = projets.proj_id AND prestations.pre_fk_tache = taches.tache_id AND lieux.lieu_id = prestations.pre_fk_lieu AND pre_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<tr class=\"data1\">\n";
					$chaine .= "<td>".day_month_year($rs->pre_date)."</td>\n";
					$chaine .= "<td>".$rs->lieu_nom."</td>\n";
					$chaine .= "<td>".$rs->proj_titre."</td>\n";
					$chaine .= "<td>".$rs->tache_nom."</td>\n";
					$chaine .= "<td>".heures($rs->pre_heures)."</td>\n";
					if (is_null($rs->pre_remarques))
					{
						$chaine .= "<td>&nbsp;</td>\n";
					}
					else
					{
						$chaine .= "<td>".$rs->pre_remarques."</td>\n";
					}
					$chaine .= "</tr>\n";
				}
				$chaine .= "</table>\n";
				break;
			case 'postit':
				$item = TXT_DELETE_CE_POSTIT;
				$chaine .= "<center>\n";
				$req = Requete ("SELECT * FROM postits, users WHERE postits.post_fk_aut = users.user_id AND postits.post_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<div class=\"postit\">\n";
					$chaine .= "<div class=\"postit-header\">";
					$chaine .= FormateDate($rs->post_date);
					$chaine .= "</div>\n";
					$chaine .= "<div class=\"postit-title\">".$rs->post_sujet."</strong></div><br />\n";
					$chaine .= $rs->post_texte."<br />\n";
					$chaine .= "</div>\n";
				}
				$chaine .= "</center>\n";
				$prev_get = "&prev=".$prev;
				break;
			case 'projet':
				$item = TXT_PROJET_CE_PROJET;
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_projet = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$chaine .= "<table border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
				$chaine .= "<tr>\n<th>".TXT_DELETE_NUMERO."</th>\n<th>".TXT_PROJET_PROJET."</th>\n</tr>\n";
				$req = Requete ("SELECT * FROM projets WHERE proj_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<tr class=\"data1\">\n";
					$chaine .= "<td>".$rs->proj_num."</td>\n";
					$chaine .= "<td>".$rs->proj_titre."</td>\n";
					$chaine .= "</tr>\n";
				}
				$chaine .= "</table>\n";
				break;
			case 'domaine':
				$item = TXT_DOMAINE_CE_DOMAINE;
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_domaine = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$chaine .= "<table border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
				$chaine .= "<tr>\n<th>".TXT_DELETE_CODE."</th>\n<th>".TXT_DOMAINE_DOMAINE."</th>\n</tr>\n";
				$req = Requete ("SELECT * FROM domaines WHERE dom_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<tr class=\"data1\">\n";
					$chaine .= "<td>".$rs->dom_id."</td>\n";
					$chaine .= "<td>".$rs->dom_nom."</td>\n";
					$chaine .= "</tr>\n";
				}
				$chaine .= "</table>\n";
				break;
			case 'tache':
				$item = TXT_TACHE_CETTE_TACHE;
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_tache = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$chaine .= "<table border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
				$chaine .= "<tr>\n<th>".TXT_TACHE_TACHE."</th>\n</tr>\n";
				$req = Requete ("SELECT * FROM taches WHERE tache_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<tr class=\"data1\">\n";
					$chaine .= "<td>".$rs->tache_nom."</td>\n";
					$chaine .= "</tr>\n";
				}
				$chaine .= "</table>\n";
				break;
			case 'produit':
				$item = TXT_DELETE_CE_PRODUIT;
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_produit = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$chaine .= "<table border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
				$chaine .= "<tr>\n<th>".TXT_DELETE_PRODUIT."</th>\n</tr>\n";
				$req = Requete ("SELECT * FROM produits WHERE prod_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<tr class=\"data1\">\n";
					$chaine .= "<td>".$rs->prod_nom."</td>\n";
					$chaine .= "</tr>\n";
				}
				$chaine .= "</table>\n";
				break;
			case 'lieu':
				$item = TXT_DELETE_CE_LIEU;
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_lieu = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$chaine .= "<table border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
				$chaine .= "<tr>\n<th>".TXT_DELETE_LIEU."</th>\n</tr>\n";
				$req = Requete ("SELECT * FROM lieux WHERE lieu_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<tr class=\"data1\">\n";
					$chaine .= "<td>".$rs->lieu_nom."</td>\n";
					$chaine .= "</tr>\n";
				}
				$chaine .= "</table>\n";
				break;
			case 'zone':
				$item = TXT_DELETE_CETTE_ZONE;
				$req = Requete ("SELECT * FROM prestations WHERE pre_fk_zone = $id_field;",$conn);
				if (NombreLignes($req) > 0)
				{
					echo "<h2>".TXT_DELETE_IMPOSSIBLE_SUPPRIMER." $item !</h2>\n";
					echo "<h4>".TXT_DELETE_PRESTATIONS_DEJA_ASSOCIEES."</h4>\n";
					echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
					exit;
				}
				$chaine .= "<table border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
				$chaine .= "<tr>\n<th>".TXT_DELETE_ZONE."</th>\n</tr>\n";
				$req = Requete ("SELECT * FROM zones WHERE zone_id = $id_field;",$conn);
				while ($rs = ObjetSuivant($req))
				{
					$chaine .= "<tr class=\"data1\">\n";
					$chaine .= "<td>".$rs->zone_nom."</td>\n";
					$chaine .= "</tr>\n";
				}
				$chaine .= "</table>\n";
				break;
		}
		
		if ($ok)
		{
			echo "<h2>".TXT_DELETE_VOULEZ_VOUS_SUPPRIMER." $item ?</h2>\n";
			echo $chaine;
			echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_SUPPRIMER."\" onClick=\"javascript:document.location.href='delete.php?mode=$mode&id=$id_field&conf=1$prev_get';\">&nbsp;&nbsp;&nbsp;";
			echo "<input type=\"button\" class=\"bouton\" value=\"".TXT_DELETE_ANNULER."\" onClick=\"javascript:history.back();\"></h2>\n";
		}
		
		echo "</div>\n";
	}
}

?>