<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

$sql_tables = "";
$sql_assoc = "";
if ($_SESSION['conf_domaines'])
{
	$sql_tables .= "domaines, ";
	$sql_assoc .= "AND domaines.dom_id = prestations.pre_fk_domaine ";
}
if ($_SESSION['conf_taches'])
{
	$sql_tables .= "taches, ";
	$sql_assoc .= "AND prestations.pre_fk_tache = taches.tache_id ";
}

echo "<div class=\"content\">\n";

$pre_id = $_GET['id'];
$prev = $_GET['prev'];
if (isset($_GET['prdate']))
{
	$date = $_GET['prdate'];
}
else
{
	$date = "";
}

switch ($prev)
{
	case 'new':
		$redirect = "add_prestation.php?date=$date";
		$vars = "prev=".$prev."&prdate=".$date;
		break;
	case 'list':
		$redirect = "prestations.php";
		$vars = "prev=".$prev;
		break;
	case 'proj':
		$proj_id = $_GET['p_id'];
		$redirect = "proj_detail.php?mode=his&id=".$proj_id;
		$vars = "prev=".$prev;
		$vars .= "&p_id=".$proj_id;
		break;
}

if (isset($_GET['mode']))
{
	$pre_date = $_GET['date'];
	switch ($_GET['mode'])
	{
		case 'rw':
			$sign = "<";
			$order = "DESC";
			break;
		case 'ff':
			$sign = ">";
			$order = "ASC";
			break;
	}
	
	$req = Requete ("SELECT * FROM prestations, projets, $sql_tables users, lieux, produits, deplacements, zones WHERE prestations.pre_fk_projet = projets.proj_id $sql_assoc AND prestations.pre_fk_user = users.user_id AND prestations.pre_fk_lieu = lieux.lieu_id AND prestations.pre_fk_produit = produits.prod_id AND prestations.pre_fk_deplacement = deplacements.depl_id AND zones.zone_id = prestations.pre_fk_zone AND pre_date = '$pre_date' AND pre_id $sign $pre_id LIMIT 1;",$conn);
	
	if (NombreLignes($req) == 0)
	{
		$req = Requete ("SELECT * FROM prestations, projets, $sql_tables users, lieux, produits, deplacements, zones WHERE prestations.pre_fk_projet = projets.proj_id $sql_assoc AND prestations.pre_fk_user = users.user_id AND prestations.pre_fk_lieu = lieux.lieu_id AND prestations.pre_fk_produit = produits.prod_id AND prestations.pre_fk_deplacement = deplacements.depl_id AND zones.zone_id = prestations.pre_fk_zone AND pre_date $sign '$pre_date' ORDER BY pre_id $order LIMIT 1;",$conn);
	}
}
else
{
	$req = Requete ("SELECT * FROM prestations, projets, $sql_tables users, lieux, produits, deplacements, zones WHERE prestations.pre_fk_projet = projets.proj_id $sql_assoc AND prestations.pre_fk_user = users.user_id AND prestations.pre_fk_lieu = lieux.lieu_id AND prestations.pre_fk_produit = produits.prod_id AND prestations.pre_fk_deplacement = deplacements.depl_id AND zones.zone_id = prestations.pre_fk_zone AND pre_id = $pre_id;",$conn);
}

if (NombreLignes($req) == 0)
{
	echo "<h4>".TXT_PREST_DETAIL_PLUS_PRESTA_DATE."</h4>\n";
	echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_PREST_DETAIL_RETOUR."\" onClick=\"javascript:history.back();\"></h2>\n";
}
else
{
	while ($rs = ObjetSuivant($req))
	{

?>
	
		<table width="80%" align="center" cellpadding="3" cellspacing="3">
			<tr>
				<th colspan="2"><?php echo TXT_PREST_DETAIL_DETAIL_PRESTA; ?></th>
			</tr>
			<tr>
				<td class="cellrightbold"><?php echo TXT_PREST_DETAIL_QUAND; ?></td>
				<td class="cellleft"><?php echo day_month_year($rs->pre_date); ?></td>
			</tr>
			<tr>
				<td class="cellrightbold"><?php echo TXT_PREST_DETAIL_QUI; ?></td>
				<td class="cellleft"><?php echo $rs->user_prenom." ".$rs->user_nom; ?></td>
			</tr>
			<tr>
				<td class="cellrightbold" valign="top"><?php echo TXT_PREST_DETAIL_A_FAIT_QUOI; ?></td>
				<td class="cellleft"><?php echo $rs->pre_desc; ?></td>
			</tr>
			<tr>
				<td class="cellrightbold"><?php echo TXT_PREST_DETAIL_OU; ?></td>
				<td class="cellleft"><?php echo $rs->lieu_nom; if($_SESSION['conf_deplacements']){echo " (".$rs->depl_nom.")";} ?></td>
			</tr>
<?php
if ($_SESSION['conf_zones'])
{
?>
			<tr>
				<td class="cellrightbold"><?php echo TXT_PREST_DETAIL_QUEL_REGROUPEMENT; ?></td>
				<td class="cellleft"><?php echo $rs->zone_nom; ?></td>
			</tr>
<?php
}
if ($_SESSION['conf_produits'])
{
?>
			<tr>
				<td class="cellrightbold"><?php echo TXT_PREST_DETAIL_QUEL_PRODUIT; ?></td>
				<td class="cellleft"><?php echo $rs->prod_nom; ?></td>
			</tr>
<?php
}
?>
			<tr>
				<td class="cellrightbold"><?php echo TXT_PREST_DETAIL_COMBIEN_TEMPS; ?></td>
				<td class="cellleft"><?php echo heures($rs->pre_heures); ?></td>
			</tr>
			<tr>
				<td class="cellrightbold"><?php echo TXT_PROJET_POUR_QUEL_PROJET; ?> </td>
				<td class="cellleft"><?php echo $rs->proj_titre_abr; ?></td>
			</tr>
<?php
if ($_SESSION['conf_domaines'])
{
?>
			<tr>
				<td class="cellrightbold"><?php echo TXT_DOMAINE_POUR_QUEL_DOMAINE; ?> </td>
				<td class="cellleft"><?php echo $rs->dom_id; ?> <?php echo $rs->dom_nom; ?></td>
			</tr>
<?php
}
if ($_SESSION['conf_taches'])
{
?>
			<tr>
				<td class="cellrightbold"><?php echo TXT_TACHE_POUR_QUELLE_TACHE; ?> </td>
				<td class="cellleft"><?php echo $rs->tache_nom; ?></td>
			</tr>
<?php
}
?>
			<tr>
				<td class="cellrightbold" valign="top"><?php echo TXT_PREST_DETAIL_REMARQUES; ?></td>
				<td class="cellleft"><?php echo $rs->pre_remarques; ?></td>
			</tr>
		</table>
		
		<h2>
			<input type="button" class="bouton" value="<?php echo TXT_PREST_DETAIL_PRECEDENTE; ?>" onClick="javascript:document.location.href='prest_detail.php?<?php echo $vars; ?>&mode=rw&id=<?php echo $rs->pre_id; ?>&date=<?php echo $rs->pre_date; ?>';">
			&nbsp;&nbsp;&nbsp;
			<input type="button" class="bouton" value="<?php echo TXT_PREST_DETAIL_SUIVANTE; ?>" onClick="javascript:document.location.href='prest_detail.php?<?php echo $vars; ?>&mode=ff&id=<?php echo $rs->pre_id; ?>&date=<?php echo $rs->pre_date; ?>';">
		</h2>
		
		<h2><input type="button" class="bouton" value="<?php echo TXT_PREST_DETAIL_RETOUR; ?>" onClick="javascript:document.location.href='<?php echo $redirect; ?>';"></h2>
	
	<br />

<?php
	}
}

echo "</div>\n";

require_once ('include/footer.php');
?>