<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

?>

<div class="content">

<?php
require_once ("include/checklevel.php");

$proj_id = $_GET['id'];

if (isset($_GET['mode']))
{
	$mode = $_GET['mode'];
}
else
{
	$mode = "ide";
}

$sql = "SELECT * FROM projets WHERE proj_id = $proj_id;";
$req = Requete($sql,$conn);

if (NombreLignes($req) > 0)
{
	while ($rs = ObjetSuivant($req))
	{
		$proj_titre_abr = $rs->proj_titre_abr;
?>

	<p><a href="projets.php"><?php echo TXT_PROJET_RETOUR_LISTE_PROJETS; ?></a></p>

	<h2><?php echo $proj_titre_abr; ?></h2>
	
	<h4>
		<a href="proj_detail.php?id=<?php echo $proj_id; ?>&mode=ide"><?php echo TXT_PROJ_DETAIL_IDENTIFICATION; ?></a> | 
		<a href="proj_detail.php?id=<?php echo $proj_id; ?>&mode=neg"><?php echo TXT_PROJ_DETAIL_NEGOCIATION; ?></a> | 
		<a href="proj_detail.php?id=<?php echo $proj_id; ?>&mode=der"><?php echo TXT_PROJ_DETAIL_DEROULEMENT; ?></a> | 
		<a href="proj_detail.php?id=<?php echo $proj_id; ?>&mode=clo"><?php echo TXT_PROJ_DETAIL_CLOTURE; ?></a> | 
		<a href="proj_detail.php?id=<?php echo $proj_id; ?>&mode=his"><?php echo TXT_PROJ_DETAIL_HISTORIQUE; ?></a>
	</h4>
		
<?php
		switch ($mode)
		{
			case 'ide':
?>

	<table align="center" cellpadding="3" cellspacing="3">
		<tr>
			<th colspan="2"><a href="mod_projet.php?id=<?php echo $proj_id; ?>&mode=<?php echo $mode; ?>"><img src="images/b_edit.gif" border="0" alt="<?php echo TXT_PROJ_DETAIL_MODIFIER; ?>" title="<?php echo TXT_PROJ_DETAIL_MODIFIER; ?>"></a>&nbsp;&nbsp;&nbsp;<?php echo $rs->proj_titre_abr; ?></th>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_NUMERO; ?></td>
			<td class="cellleft"><?php echo $rs->proj_num; ?></td>
		</tr>
		<tr>
			<td class="cellrightbold" valign="top"><?php echo TXT_PROJ_DETAIL_TITRE_ABR; ?></td>
			<td class="cellleft"><?php echo $rs->proj_titre_abr; ?></td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_TITRE_COMPLET; ?></td>
			<td class="cellleft"><?php echo $rs->proj_titre; ?></td>
		</tr>
		<tr>
				<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_SUIVI_PROJET; ?></td>
				<td class="cellleft">
<?php
$sql = "SELECT * FROM projets WHERE proj_id = ".$rs->proj_suivi_de.";";
$req2 = Requete($sql,$conn);

if (NombreLignes($req2) == 0)
{
	echo "-";
}
else
{
	while ($rs2 = ObjetSuivant($req2))
	{
		echo $rs2->proj_num." ".$rs2->proj_titre_abr;
	}
}
?>						
				</td>
			</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_NOM_FINANCEUR; ?></td>
			<td class="cellleft"><?php echo $rs->proj_nom_fin; ?></td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_NOM_BENEFICIAIRE; ?></td>
			<td class="cellleft"><?php echo $rs->proj_nom_ben; ?></td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_DATE_DEBUT; ?></td>
			<td class="cellleft"><?php echo day_month_year($rs->proj_date_debut); ?>&nbsp;<a href="mod_projet_date.php?id=<?php echo $proj_id; ?>&cas=date_debut"><?php echo TXT_PROJ_DETAIL_MODIFIER; ?></a></td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_DATE_FIN; ?></td>
<?php
		if ($rs->proj_date_fin == '0000-00-00')
		{
?>
			<td class="cellleft"><a href="proj_fin.php?id=<?php echo $proj_id; ?>"><?php echo TXT_ADD_PROJET_CHOISISSEZ_UNE_DATE; ?></a></td>
<?php
		}
		else
		{
?>
			<td class="cellleft"><?php echo day_month_year($rs->proj_date_fin); ?>&nbsp;<a href="mod_projet_date.php?id=<?php echo $proj_id; ?>&cas=date_fin"><?php echo TXT_PROJ_DETAIL_MODIFIER; ?></a></td>
<?php
		}
?>
		</tr>
		<tr>
			<td class="cellrightbold" valign="top"><?php echo TXT_DOMAINE_DOMAINES; ?> :  </td>
			<td class="cellleft">
<?php
$req2 = Requete ("SELECT * FROM proj_dom, domaines WHERE pd_fk_projet = $proj_id AND proj_dom.pd_fk_domaine = domaines.dom_id ORDER BY dom_id;",$conn);
$cpt = 0;
while ($rs2 = ObjetSuivant($req2))
{
	if ($cpt > 0)
	{
		echo "<br />";
	}
	echo $rs2->dom_id." ".$rs2->dom_nom;
	$cpt++;
}
?>
			</td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_PRODUIT_PRINCIPAL; ?></td>
			<td class="cellleft">
<?php
if ($rs->proj_fk_prod_princ > 0)
{
	$req2 = Requete ("SELECT * FROM produits WHERE prod_id = ".$rs->proj_fk_prod_princ.";",$conn);
	while ($rs2 = ObjetSuivant($req2))
	{
		echo $rs2->prod_nom;
	}
}
else
{
	echo "-";
}
?>
			</td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_PROBABILITE; ?></td>
			<td class="cellleft">
<?php
if ($rs->proj_fk_proba > 0)
{
	$req2 = Requete ("SELECT * FROM probabilites WHERE prob_id = ".$rs->proj_fk_proba.";",$conn);
	while ($rs2 = ObjetSuivant($req2))
	{
		echo $rs2->prob_nom;
	}
}
else
{
	echo "-";
}
?>
			</td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_PAYS; ?></td>
			<td class="cellleft">
<?php
if ($rs->proj_fk_pays > 0)
{
	$req2 = Requete ("SELECT * FROM pays WHERE pays_id = ".$rs->proj_fk_pays.";",$conn);
	while ($rs2 = ObjetSuivant($req2))
	{
		echo $rs2->pays_nom;
	}
}
else
{
	echo "-";
}
?>
			</td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_SOURCE_CONTRAT; ?></td>
			<td class="cellleft"><?php echo $rs->proj_source; ?></td>
		</tr>
	</table>

<?php
				break;
			case 'neg':
?>

	<table align="center" cellpadding="3" cellspacing="3">
		<tr>
			<th colspan="2"><a href="mod_projet.php?id=<?php echo $proj_id; ?>&mode=<?php echo $mode; ?>"><img src="images/b_edit.gif" border="0" alt="modifier" title="modifier"></a>&nbsp;&nbsp;&nbsp;<?php echo $rs->proj_titre_abr; ?></th>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_MONTANT_BUDGET; ?></td>
			<td class="cellleft"><?php echo $rs->proj_budget; ?></td>
		</tr>
		<tr>
			<td class="cellrightbold" valign="top"><?php echo TXT_PROJ_DETAIL_DESCRIPTION; ?></td>
			<td class="cellleft"><?php echo $rs->proj_negoc; ?></td>
		</tr>
	</table>
		
<?php
				break;
			case 'der':
?>

	<table align="center" cellpadding="3" cellspacing="3">
		<tr>
			<th colspan="2"><a href="mod_projet.php?id=<?php echo $proj_id; ?>&mode=<?php echo $mode; ?>"><img src="images/b_edit.gif" border="0" alt="<?php echo TXT_PROJ_DETAIL_MODIFIER; ?>" title="<?php echo TXT_PROJ_DETAIL_MODIFIER; ?>"></a>&nbsp;&nbsp;&nbsp;<?php echo $rs->proj_titre_abr; ?></th>
		</tr>
		<tr>
			<td class="cellrightbold" valign="top"><?php echo TXT_PROJ_DETAIL_DEROULEMENT_BIS; ?></td>
			<td class="cellleft"><?php echo $rs->proj_deroul; ?></td>
		</tr>
	</table>

<?php
				break;
			case 'clo':
?>

	<table align="center" cellpadding="3" cellspacing="3">
		<tr>
			<th colspan="2"><a href="mod_projet.php?id=<?php echo $proj_id; ?>&mode=<?php echo $mode; ?>"><img src="images/b_edit.gif" border="0" alt="<?php echo TXT_PROJ_DETAIL_MODIFIER; ?>" title="<?php echo TXT_PROJ_DETAIL_MODIFIER; ?>"></a>&nbsp;&nbsp;&nbsp;<?php echo $rs->proj_titre_abr; ?></th>
		</tr>
		<tr>
			<td class="cellrightbold" valign="top"><?php echo TXT_PROJ_DETAIL_RESULTAT; ?></td>
			<td class="cellleft"><?php echo $rs->proj_resultat; ?></td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_JOURS_PRESTES; ?></td>
<?php
$tot_hrs = 0;
$req2 = Requete ("SELECT * FROM prestations WHERE pre_fk_projet = $proj_id;",$conn);
while ($rs2 = ObjetSuivant($req2))
{
	$tot_hrs += $rs2->pre_heures;
}
$tot_jrs = number_format(($tot_hrs/8),1)
?>
			<td class="cellleft"><?php echo $tot_jrs; ?></td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_JOURS_VENDUS; ?></td>
			<td class="cellleft"><?php echo $rs->proj_jours_vendus; ?></td>
		</tr>
		<tr>
			<td class="cellrightbold"><?php echo TXT_PROJ_DETAIL_HONORAIRES; ?></td>
			<td class="cellleft"><?php echo $rs->proj_honoraires; ?></td>
		</tr>
	</table>
			
<?php
				break;
			case 'his':
?>

<?php
$sql = "SELECT * FROM prestations, taches, lieux, users WHERE prestations.pre_fk_tache = taches.tache_id AND lieux.lieu_id = prestations.pre_fk_lieu AND users.user_id = prestations.pre_fk_user AND prestations.pre_fk_projet = $proj_id ORDER BY pre_date DESC;";
$req = Requete ($sql,$conn);

if (NombreLignes($req) > 0)
{
?>

	<form name="export2" action="process_export.php" method="post">
		<p>
			<strong><?php echo TXT_PROJ_DETAIL_EXPORTER_PRESTA_POUR_PROJET; ?><?php echo $proj_titre_abr; ?></strong>
			<input type="hidden" name="proj_id" value="<?php echo $proj_id; ?>">
			<input type="hidden" name="exptype" value="2">
			<input class="bouton" type="submit" value="<?php echo TXT_PROJ_DETAIL_OK; ?>">
		</p>
	</form>

	<table border="0" width="100%" align="center" cellpadding="3" cellspacing="0">
		<tr>
			<th><?php echo TXT_PROJ_DETAIL_DATE; ?></th>
			<th><?php echo TXT_PROJ_DETAIL_NOM; ?></th>
			<th><?php echo TXT_TACHE_TACHE; ?></th>
			<th><?php echo TXT_PROJ_DETAIL_HEURES; ?></th>
			<th><?php echo TXT_PROJ_DETAIL_A_FAIT_QUOI; ?></th>
			<th>&nbsp;</th>
		</tr>
		
<?php
	$texte = "";
	$tot_hrs = 0;
	$count = 0;
	while ($rs = ObjetSuivant($req))
	{
		$count += 1;
		if ($count % 2 > 0)
		{
			$class = "data1";
		}
		else
		{
			$class = "data2";
		}
		$texte .= "<tr class=\"".$class."\">\n";
		$texte .= "<td>".day_month_year($rs->pre_date)."</td>\n";
		$texte .= "<td>".$rs->user_prenom." ".$rs->user_nom."</td>\n";
		$texte .= "<td>".$rs->tache_nom."</td>\n";
		$texte .= "<td>".heures($rs->pre_heures)."</td>\n";
		if (is_null($rs->pre_desc))
		{
			$texte .= "<td>&nbsp;</td>\n";
		}
		else
		{
			$texte .= "<td>".$rs->pre_desc."</td>\n";
		}
		$texte .= "<td class=\"cellright\" valign=\"middle\">\n";
		$texte .= "<a href=\"prest_detail.php?prev=proj&p_id=$proj_id&id=".$rs->pre_id."\"><img src=\"images/b_search.png\" border=\"0\" alt=\"".TXT_PROJ_DETAIL_DETAILS."\" title=\"".TXT_PROJ_DETAIL_DETAILS."\"></a>&nbsp;";
		$texte .= "</td>";
		$texte .= "</tr>\n";
		$tot_hrs += $rs->pre_heures;
	}
	echo "<tr><td colspan=\"6\" class=\"celltitle\">".heures($tot_hrs).TXT_PROJ_DETAIL_PRESTEES_TOTAL."</td></tr>\n";
	echo $texte;
	echo "</table>\n";
}
else
{
	echo "<p>".TXT_PROJ_DETAIL_AUCUNE_PRESTA_POUR_MOMENT."</p>\n";
}
?>

<?php
				break;
		}
?>
		
	</table>

<br />

</div>

<?php
	}
}
else
{
	echo "<h3>".TXT_PROJET_AUCUN_PROJET_POUR_CET_IDENTIFIANT."</h3>\n";
}
require_once ('include/footer.php');
?>