<?
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Author : Jean-Christophe Cardot
   Copyright (c) 2000-2002 Jean-Christophe Cardot <taz98@altern.org>
 */

/* ---------------- dfinition des fonctions ---------------- */

// renvoie une chane reprsentant la taille et la date d'un fichier
function sizeanddate ($file) {
  $sizeanddate = sprintf("% 8d ", filesize("$file")) . date("M d H:i", filemtime("$file"));
  $sizeanddate = preg_replace("/  /", "&nbsp;&nbsp;", $sizeanddate);
  return($sizeanddate);
}

// renvoie le nombre d'entres d'un rpertoire
function nbfiles ($rep) {
  $nb=0;
  opendir($rep);
  $dentry=readdir();
  while ($dentry):
    if (($dentry != ".") && ($dentry != "..")):
      $nb++;
    endif;
    $dentry=readdir();
  endwhile;
  closedir();
  return($nb);
}

// teste si un rpertoire est vide
function is_empty($dir) {
  if (!($dp = @opendir("$dir"))): return 1; endif;
  @readdir($dp); @readdir($dp); // (. et ..)
  if(@readdir($dp)): return 0; else: return 1; endif;
}

// suppression unitaire d'un fichier ou d'un rpertoire (vide)
function supprime ($fileordir) {
  if (is_file($fileordir) || is_link($fileordir)):
    $supprime = unlink($fileordir);
  elseif (is_dir($fileordir)):
    $supprime = rmdir($fileordir);
  endif;
  return($supprime);
}

// suppression rcursive d'un rpertoire
function recursive_supprime ($dir) {
  if (is_dir($dir)):
    if (nbfiles($dir)==0): // repertoire vide
      supprime($dir);
    else: // repertoire non vide
      $d=opendir($dir);
      $dentry=readdir($d);
      while ($dentry):
        if (is_file("$dir/$dentry")):
          echo "<br>$dir/$dentry\n";
          supprime("$dir/$dentry");
        elseif (is_dir("$dir/$dentry") && ($dentry <> ".") && ($dentry <> "..")):
          echo "<br>$dir/$dentry\n";
          recursive_supprime("$dir/$dentry");
          //supprime("$dir/$dentry");
        endif;
        $dentry=@readdir($d);
      endwhile;
      @closedir();
      supprime($dir);
    endif;
  else: // fichier
    supprime($dir);
  endif;
}

// retourne la chane compose de r w x et - correspondant aux droits passs en paramtre
function rwxrwxrwx ($fileperms) {
  $retval = "";
  $octnum = "000".decoct($fileperms);
  $octnum = substr("$octnum", strlen("$octnum")-3, 3);
  for ($i=0 ; $i<3 ; $i++):
    if ($octnum[$i] & 4): $retval .= "r"; else: $retval .= "-"; endif;
    if ($octnum[$i] & 2): $retval .= "w"; else: $retval .= "-"; endif;
    if ($octnum[$i] & 1): $retval .= "x"; else: $retval .= "-"; endif;
  endfor;
  return($retval);
}

// teste si un fichier est slectionn (i.e. case coche)
function is_selected($filedesc) {
  global $selected;
  for ($i=0;$i<count($selected);$i++):
    if ($selected[$i] == $filedesc):
      return true;
    endif;
  endfor;
  return false;
}

// affiche le contenu d'un rpertoire
function printDir($dir, $prefix, $showdot, $show2dot) {
  // $dir : nom du rpertoire (qualifi)
  // $prefix : chane  ajouter devant chaque ligne
  // $showdot & $show2dot : afficher le . et le .. de ce rpertoire
  global $PHP_SELF, $expand, $explore_dir, $allowCVS, $connexion, $db;
  global $keepselected, $selected; // si keepselected==1, on coche les cases

  // lecture des entres, et classement des fichiers dans $files[]
  // et des sous-rpertoires dans $dirs[]
  $dp = opendir("$dir");
  while ($dentry=readdir($dp)):
    if (is_dir("$dir/$dentry")): $dirs[] = $dentry;
    else: $files[] = $dentry;
    endif;
  endwhile;
  closedir($dp);

  // traitement des dossiers
  $totalsize=0; $nbdossiers=0; $n=0;
  $nbfiles = count($files);
  if ($dirs):
    asort($dirs);
    $nbdossiers = count($dirs);
    for(reset($dirs); $dentry = $dirs[key($dirs)]; next($dirs)):
      $n++;
      if (  ($showdot  || ($dentry != "." ))
          &&($show2dot || ($dentry != "..")) ):
        //if ($expand["$dir/$dentry"] && is_empty("$dir/$dentry")):
        //  unset($expand["$dir/$dentry"]);
        //endif;
        $totalsize += filesize("$dir/$dentry");
        echo " <tr>\n";
        echo "  $prefix<td width='0'>";
        if (($dentry==".")||($dentry=="..")||is_empty("$dir/$dentry")):
          echo "<img src='$explore_dir/pics/";
        else:
          echo "<input src='$explore_dir/pics/";
        endif;
        if (($nbfiles==0)&&($n==$nbdossiers)): echo "L"; else: echo "T"; endif;
        if ($dentry=="."):
          $iko = "ici";
        elseif ($dentry==".."):
          $iko = "up";
        else:
          if (!is_empty("$dir/$dentry")):
            if ($expand["$dir/$dentry"]): echo "m"; $action="collapse"; else: echo "p"; $action="expand"; endif;
          endif;
          $iko="dir";
        endif;
        if (($dentry==".")||($dentry=="..")||is_empty("$dir/$dentry")):
          echo ".png'></td>";
        else:
          echo ".png' type='image' border='0' name='".$action."[$dir/$dentry]'></td>";
        endif;
        echo "<td width='0'><img src='$explore_dir/pics/$iko.png'></td>\n";
        echo "  <td colspan='99'><nobr><input type='checkbox' NAME='selected[]' VALUE='$dir/$dentry'";
        if ($keepselected && is_selected("$dir/$dentry")):
          echo " checked";
        endif;
        echo "><tt><font size='-1'>";
        if (is_link("$dir/$dentry")): echo "l"; else: echo "d"; endif;
        echo rwxrwxrwx(fileperms("$dir/$dentry"))." ";
        echo sizeanddate("$dir/$dentry");
        echo " <a href='$PHP_SELF?rep2browse=".rawurlencode("$dir/$dentry")."'>$dentry/</a>";
        if (is_link("$dir/$dentry")):
          echo " -&gt; ";
          echo readlink("$dir/$dentry");
        endif;
        echo "</tt></font></nobr></td>\n";
        echo " </tr>\n";
        if ($expand["$dir/$dentry"]):
          if (($nbfiles==0)&&($n==$nbdossiers)): $suffix="blanc"; else: $suffix="I"; endif;
          list ($ts, $nd, $nf) = printDir("$dir/$dentry", "$prefix<td width='0'><img src='$explore_dir/pics/".$suffix.".png'></td>", 0, 0);
          $rtotalsize += $ts; $rnbdossiers += $nd-2; $rnbfiles += $nf;
        endif;
      endif; /* showdot & show2dot */
    endfor;
  endif;

  // traitement des fichiers
  $nbfiles = 0;
  if ($files):
    asort($files);
    $nbfiles = count($files);
    $n = 0;
    for(reset($files); $dentry = $files[key($files)]; next($files)):
      $n++;
      $totalsize += filesize("$dir/$dentry");
      echo " <tr>\n";
      if ($n==$nbfiles): $elem="L"; else: $elem="T"; endif;
      echo "  $prefix<td width='0'><img src='$explore_dir/pics/$elem.png'></td>";
      echo "<td width='0'><img src='$explore_dir/pics/".iconeFromFile($dentry)."'></td>\n";
      echo "  <td colspan='99'><nobr><input type='checkbox' NAME='selected[]' VALUE='$dir/$dentry'";
      if ($keepselected && is_selected("$dir/$dentry")):
        echo " checked";
      endif;
      echo "><font size='-1'><tt>";
      if (is_link("$dir/$dentry")): echo "l"; else: echo "-"; endif;
      echo rwxrwxrwx(fileperms("$dir/$dentry"))." ";
      echo sizeanddate("$dir/$dentry");
      $ckoutdeb=""; $ckoutfin="";
      if ($allowCVS):
        // le fichier est-il en checkout ?
        if ($connexion && $db):
          list($ckoutuser, $ckoutdate) = is_checkedout("$dir/$dentry");
          if ($ckoutuser != ""):
            $ckoutdeb = "<font color='#ff0000'>";
            $ckoutfin = "</font> (<b>$ckoutuser</b>, $ckoutdate)";
          endif;
        endif;
      endif;
      echo " $ckoutdeb$dentry$ckoutfin";
      if (is_link("$dir/$dentry")):
        echo " -&gt; ";
        echo readlink("$dir/$dentry");
      endif;
      echo "</tt> (<a href='$PHP_SELF?edit=1&file2edit=";
      if ($dir != "."): echo rawurlencode($dir)."/"; endif;
      echo rawurlencode($dentry)."' target='_blank'>edit</a>|<a href='";
      if ($dir != "."): echo preg_replace("/\ /", "%20", $dir)."/"; endif;
      echo rawurlencode($dentry)."' target='_blank'>view</a>|<a href='$PHP_SELF?download=1&filename=";
      if ($dir != "."): echo preg_replace("/\ /", "%20", $dir)."/"; endif;
      echo rawurlencode($dentry)."'>dnld</a>)</font></nobr></td>\n";
      echo " </tr>\n";
    endfor;
  endif;

  return array($totalsize+$rtotalsize, $nbdossiers+$rnbdossiers, $nbfiles+$rnbfiles);
}

?>