<?php


	function anchor($url, $caption, $target='' ,$class='')
	{
		$classOption='';
		$tmptarget='';
		if(!empty($target)){
			$tmptarget=" target=\"".$target."\"";
		}
		if($class !='') $classOption = " class=\"$class\"";
		return "<a href=\"$url\" $tmptarget $classOption>". $caption. "</a>\n";
	}

	function image($url, $width=-1, $height=-1, $alt='image')
	{
		$widthAttr='';
		$heightAttr='';
		
		if($width != -1) $widthAttr=" width=\"$width\"";
		if($height != -1) $heightAttr=" height=\"$height\"";
		
		return "<img src=\"$url\" alt=\"".$alt."\"" . $widthAttr . $heightAttr ."/>\n";
	}
	
	function meta($name, $content)
	{
		return "<meta name=\"".$name."\" content=\"".$content."\" />\n";
	}
	
	function centre($text){
		return '<div class="centre">' . $text . '</div>';
	}
	
	function red($text){
		return '<div class="red">' . $text . '</div>';
	}
	
	function green($text){
		return '<div class="green">' . $text . '</div>';
	}
  
	function bold($text){
		return '<div class="bold">' . $text . '</div>';
	}
	
	function h1($text, $class='', $id=''){
		return balise('h1', $text, $class, $id);
	}
	
	function h2($text, $class='', $id=''){
		return balise('h2', $text, $class, $id);
	}
	
	function h3($text, $class='', $id=''){
		return balise('h3', $text, $class, $id);
	}
	
	function paragraph($text, $class='', $id=''){
		return balise('p', $text, $class, $id);
	}
	
	function balise($balise_name, $text, $class='', $id=''){
		$class_field='';
		$id_field='';
		
		if($class) $class_field=' class="' . $class . '"';
		if($id) $id_field=' id="' . $id . '"';
		
		return '<' . $balise_name . $class_field . $id_field . '>' . $text . '</' . $balise_name .">\n";
	}
  
  ////////// FORM //////////
	function startForm($action, $name="", $options="", $method="POST")
	{
        $tmpName="";
        if($name != "") $tmpName="id=\"$name\" name=\"$name\""; 
		return "<form $tmpName action=\"$action\" method=\"$method\" $options enctype='multipart/form-data'>\n";
	}
	
	function input($type, $name="", $value="", $size="")
	{
	$tmpValue="";
	if($value!="")
	{	
		$value=stripslashes($value);
		$tmpValue="value=\"$value\"";
	}
	
	$tmpName="";
	if($name!="") $tmpName="id=\"$name\" name=\"$name\"";
	
	$tmpSize="";
	if($size!="") $tmpSize="size=\"$size\"";
	
		return "<input type=\"$type\" $tmpName $tmpValue $tmpSize/>\n";
	}
	
	function newTextField($name="", $value="", $size='')
	{
		return input('text',$name,$value,$size);
	}
	
    function newPasswordField($name="", $value="", $size='')
	{
		return input("password",$name,$value,$size);
	}
    
	function submitField($name='', $value='valider',$class='',$width='')
	{
		$tmpClass=null;
		if($class!='');
			$tmpClass="class=\"$class\"";
		return "<input type=\"submit\" id=\"$name\" name=\"$name\" $tmpClass value=\"$value\" width=\"$width\"/>\n";
	}
	
	function hiddenField($name, $value)
	{
		return input("hidden",$name,$value);
	}
	
	function newImageField($src, $name="default")
	{
		return "<input type=\"image\" src=\"$src\" id=\"$name\" name=\"$name\"/>\n";
	}
	
	function newFileField($name, $value)
	{
		return "<input type=\"file\" id=\"$name\" name=\"$name\" value=\"$value\"/>\n";
	}
	
	function checkbox($name,$value,$checked="")
	{
		return "<input type=\"checkbox\" id=\"$name\" name=\"$name\" value=\"$value\" $checked/>\n";
	}
	
	function radioButton($name,$value,$checked="")
	{
		return "<input type=\"radio\" id=\"$name\" name=\"$name\" value=\"$value\" $checked/>\n";
	}
	
	function select($name, $option='')
	{
		return "<select id=\"$name\" name=\"$name\" $option\>\n";
	}
	
	function option($value, $checked="")
	{
		return "<option />";
	}
	
	function endForm()
	{
	return "</form>\n";
	}
?>
