#########################################################################
# Name : 	WebQCM.sql						#
# DATE : 	2nd August 2005						#
# Author :	Fabrice DUFOUR						#
#									#
# Create an empty database for phpMCQ.					#
#									#
# to create database use :						#
#									#
# mysql -u root --password="" --execute "source WebQCM.sql"		#
#									#
# If required, remplace login and password by your own.			#
#########################################################################

DROP DATABASE IF EXISTS phpmcq;
CREATE DATABASE phpmcq;
USE phpmcq;

DROP TABLE IF EXISTS questions;
DROP TABLE IF EXISTS suggestions;
DROP TABLE IF EXISTS answers;
DROP TABLE IF EXISTS subjects;
DROP TABLE IF EXISTS chapters;
DROP TABLE IF EXISTS questionnaires;
DROP TABLE IF EXISTS questionnaires_content;
DROP TABLE IF EXISTS people;
DROP TABLE IF EXISTS results;
DROP TABLE IF EXISTS history;


CREATE TABLE questions (id_question BIGINT AUTO_INCREMENT UNIQUE NOT NULL,
			question BLOB NOT NULL,
			open BOOL NOT NULL DEFAULT 0, 
			link VARCHAR(255),
			teacherComment BLOB,
			id_subject BIGINT NOT NULL,
			id_person BIGINT NOT NULL,
			PRIMARY KEY (id_question),
			FOREIGN KEY (id_subject) REFERENCES subjects,
			FOREIGN KEY (id_person) REFERENCES people);

CREATE TABLE suggestions (	id_suggestion BIGINT AUTO_INCREMENT NOT NULL,
				suggestion BLOB NOT NULL,
				link VARCHAR(255),
				id_question BIGINT NOT NULL,
				PRIMARY KEY (id_suggestion),
				FOREIGN KEY (id_question) REFERENCES questions);

CREATE TABLE answers ( 	id_question BIGINT NOT NULL,
			id_suggestion BIGINT NOT NULL,
			PRIMARY KEY (id_question, id_suggestion));

CREATE TABLE subjects (	id_subject BIGINT AUTO_INCREMENT NOT NULL,
			subject VARCHAR(255) NOT NULL,
			PRIMARY KEY (id_subject));

CREATE TABLE chapters ( id_chapter BIGINT AUTO_INCREMENT NOT NULL,
	   		id_subject BIGINT NOT NULL,
			chapter VARCHAR(255),
			PRIMARY KEY (id_chapter),
			FOREIGN KEY (id_subject) REFERENCES subjects);	

CREATE TABLE questionnaires (	id_questionnaire BIGINT AUTO_INCREMENT NOT NULL,
				title VARCHAR(255) NOT NULL,
				type INTEGER NOT NULL, # QCM or SONDAGE
				id_subject BIGINT NOT NULL,
				id_person BIGINT NOT NULL,
				addOnSuccess INTEGER DEFAULT 1,
				removeOnFail INTEGER DEFAULT 0,
				timeToGo BIGINT DEFAULT -1,
				correction BOOL DEFAULT 1,
				PRIMARY KEY (id_questionnaire),
				FOREIGN KEY (id_subject) REFERENCES subjects,
				FOREIGN KEY (id_person) REFERENCES people);

CREATE TABLE questionnaires_content (	id_questionnaire BIGINT NOT NULL,
					id_question BIGINT NOT NULL,
					PRIMARY KEY (id_questionnaire, id_question));

CREATE TABLE people (	id_person BIGINT AUTO_INCREMENT NOT NULL,
 			login VARCHAR(100) NOT NULL,		  
 			password VARCHAR(200) NOT NULL,
			surname VARCHAR(200) NOT NULL,
			firstname VARCHAR(200) NOT NULL,
			access INTEGER NOT NULL DEFAULT -1,
			email VARCHAR(200),
			job VARCHAR(200),
			PRIMARY KEY (id_person));

CREATE TABLE results ( 	id_result BIGINT AUTO_INCREMENT NOT NULL,
			id_person BIGINT NOT NULL,
			id_questionnaire BIGINT NOT NULL,
			id_question BIGINT NOT NULL,
			date TIMESTAMP NOT NULL,
			PRIMARY KEY (id_result),
			FOREIGN KEY (id_person) REFERENCES people,
			FOREIGN KEY (id_questionnaire) REFERENCES questionnaires,
			FOREIGN KEY (id_question) REFERENCES questions);

CREATE TABLE history ( 	id_history BIGINT AUTO_INCREMENT NOT NULL,
			id_result BIGINT NOT NULL,
			id_suggestion BIGINT NOT NULL,
			answer BLOB,
			PRIMARY KEY (id_history),
			FOREIGN KEY (id_result) REFERENCES results,
			FOREIGN KEY (id_suggestion) REFERENCES suggestions);


#LOCK TABLES people WRITE;
INSERT INTO people VALUES
(1, 'admin', 'aa36dc6e81e2ac7ad03e12fedcb6a2c0', 'administrateur', '', 1,'','');
#UNLOCK TABLES;

#LOCK TABLES subjects WRITE;
INSERT INTO subjects VALUES (1,'aucun');
#UNLOCK TABLES;
