<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

// This file provides utilities to check if a user can access a page.
// To use it, include it in the webpage you want to protect and call
// the function "check_access()" at the beginning of the page. The
// function parameter is the wanted security level. The security level
// has 4 levels:

// Nobody can access the page. Not very useful, but it is the default 
// security level.
define ('NOBODY', 0);
// Only administrators of webqcm can access the page
define ('ADMINS_ONLY', 1);
// Only users can access the page 
// Note: administrators cannot access the page
define ('USERS_ONLY', 2); 
// Both users and administrators can access the page
define ('BOTH_USERS_AND_ADMINS', 3); 

// Database type for access field
define ('ADMIN', 1);
define ('USER', 2);

function check_access($allowed=NOBODY){
	// Starting session to retreive cookies
	session_start();
	// First check whether the user is registered
	// No matter whether it is an admin or a simple user
	if (!session_is_registered("webqcm")){
		Notes::getInstance()->addNote('Login failed', FAILURE_NOTE);
		header('Location:index.php');
		return;
	}
	
	// At this stage, the user is logged
	if(isset($_SERVER['HTTP_REFERER'])){
		$referer = $_SERVER['HTTP_REFERER'];
	}
	else{
		// If we don't have any referer then we go back to webqcm home
		$referer='chooseQuestionnaire.php';
	}
	
	switch($allowed){
		case BOTH_USERS_AND_ADMINS:
			// No more check. Simply go on...
		break;
		case USERS_ONLY:
			// If not user then redirect to start page
			if($_SESSION['access'] != USER){
				Notes::getInstance()->addNote('Vous n\'êtes pas autorisé à afficher cette page', FAILURE_NOTE);
				header('Location:' . $referer );
			}
		break;
		case ADMINS_ONLY:
			// If not admin then redirect to start page
			if($_SESSION['access'] != ADMIN){
				Notes::getInstance()->addNote('Vous n\'êtes pas autorisé à afficher cette page', FAILURE_NOTE);
				header('Location:' . $referer );
			}
		break;
		case NOBODY: 
			// Same as default
		default: 
			// Redirect to start page index.php
			header('Location:index.php');
		break;
	}
}
?>
