<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

require_once('parameters.inc.php');
require_once(PHPMCQ_HOME . 'PageLayout.class.php');
require_once(PHPMCQ_HOME . 'xhtml.php');
require_once(PHPMCQ_HOME . 'DataBase.class.php');
require_once(PHPMCQ_HOME . 'Table.class.php');
require_once(PHPMCQ_HOME . 'utils.php');
  
require_once(ACCESS_MODULE);

define('WRONG_PASSWORD', 0);
define('NEW_PASSWORDS_MISMATCH', 1);
define('NEW_PASSWORD_APPLIED', 2);

check_access(BOTH_USERS_AND_ADMINS);

$old_password=getVariable('old_password');
$new_password1=getVariable('new_password1');
$new_password2=getVariable('new_password2');
  
$page=new PageLayout('WebQCM');
$page->setStyleSheet(CSS_FILES_PATH . 'webQCM.css');
$page->setTitleBar('<h1>Changement de mot de passe</h1>');
  
$content='';

if(!isset($_REQUEST['btn-ok'])){
	$content = $content . info_note("Vous tes connect en tant que " . italic($_SESSION['login']) );
	$content = $content .  startForm($_SERVER['PHP_SELF']);
	/*
	$myTable = new Table('lightgrey');

	$myTable->line();
	$myTable->cell(h1('Mot de passe actuel :'));
	$myTable->cell(newPasswordField('old_password'));

	$myTable->line();
	$myTable->cell(h1('Nouveau mot de passe : '));
	$myTable->cell(newPasswordField('new_password1'));
  
	$myTable->line();
	$myTable->cell(h1('Confirmer le nouveau mot de passe : '));
	$myTable->cell(newPasswordField('new_password2'));

	$myTable->line();
	$myTable->cell(submitField('btn-ok','Valider'),'lightgrey','center',1,2);
	$content = $content . box($myTable->endTable());
	$content=$content . endForm();
	*/
// Display password form:

$box = '';
$box = $box . paragraph(h1('Mot de passe actuel :') . newPasswordField('old_password'));
$box = $box . paragraph(h1('Nouveau mot de passe :') . newPasswordField('new_password1'));
$box = $box . paragraph(h1('Confirmer le nouveau mot de passe :') . newPasswordField('new_password2'));
$box = $box . paragraph(submitField('btn-ok','Valider'));

$content=$content . box($box) . endForm();

}
else{
	$action= WRONG_PASSWORD;
	$myDB = new dataBase();
	$request = "select * from people where login='".$_SESSION['login']."'";
	$person=$myDB->objetSuivant($myDB->execRequete($request));
 	
 	
	if($person->password==md5($old_password)){
		// old password accepted. Are passwords the same ?
		if(strlen($new_password1)>0 && strcmp($new_password1,$new_password2) == 0){
			$action= NEW_PASSWORD_APPLIED;
		}
		else{ // Passwords are not the same
			$action= NEW_PASSWORDS_MISMATCH;
		}
	}
	else{ // Old pssword not accepted
		$action= WRONG_PASSWORD;
	}

	switch($action){
		case NEW_PASSWORD_APPLIED:
			$request = "update people set password='". md5($new_password1) ."' where login='".$_SESSION['login']."'";
			$myDB->execRequete($request);
			if($myDB->enErreur()>=1){
				$content = $content . failure_note('Internal error. Please contact an administrator');
			}
			else{
				$content = $content . success_note('Nouveau mot de passe appliqu');
			}
		break;
		case NEW_PASSWORDS_MISMATCH:
			$content = $content . failure_note('Les nouveaux mots de passes ne correspondent pas');
		break;
		case WRONG_PASSWORD:
			$content = $content . failure_note('Ancien mot de passe incorrect');
		break;
		default:
			$content = $content . failure_note('Internal error. Please contact an administrator');
	}
	
	$myDB->quitter();
}

$page->setContent($content);
echo $page->getPage($_SESSION['access']);
?>
