<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

/*******************************************************************************
Name : 	    newQuestion.php
Version : 	1.0
Date : 	   	15th May 2004
Author : 	Fabrice DUFOUR <Fabrice.Dufour@clubinfo.org>

Save new question in the database
*******************************************************************************/

require_once('parameters.inc.php');
require_once(PHPMCQ_HOME . 'PageLayout.class.php');
require_once(PHPMCQ_HOME . 'xhtml.php');
require_once(PHPMCQ_HOME . 'DataBase.class.php');
require_once(PHPMCQ_HOME . 'Table.class.php');
require_once(PHPMCQ_HOME . 'utils.php');
require_once(ACCESS_MODULE);

$content=null;

//	include(INCLUDE_FILES_PATH . 'accessCheck.inc.php');
// Only logged admins can access this page
check_access(ADMINS_ONLY);

	$page=new PageLayout('WebQCM');
	$page->setStyleSheet(CSS_FILES_PATH . 'webQCM.css');
  $page->setTitleBar('<h1>Nouveau questionnaire</h1>');
  
	$id_person=1;
	$id_subject=getVariable('id_subject',1);
	$cur_person=getVariable('cur_person',1);
	$cur_subject=getVariable('cur_subject',1);
	$correction=getVariable('correction',1);
	$title=getVariable('title');
	$possibleChoice=getVariable('possibleChoice');
	$questionChoiced=getVariable('questionChoiced');
	$questContent=getVariable('questContent');
  $type=getVariable('type',QCM);
	$addOnSuccess=getVariable('addOnSuccess',1);
	$removeOnFail=getVariable('removeOnFail',0);
	
	$myDB = new dataBase();

	if(!isset($_REQUEST['storeQuestionnaire']))
	{
		$content = $content . startForm($_SERVER['PHP_SELF']);
		
		// Premier cadre contenant
		// - Le sujet du questionnaire
		// - Le titre du questionnaire
		// - autoriser ou non la correction
		// - politique de notation
		
		$content = $content . "<div class=\"caption\">";
		$questTable = new Table("lightgrey");
		
		// Selection du sujet :
		$request = 'SELECT * FROM subjects';
		$subjects=$myDB->execRequete($request);
		$subjectTxt="<select name=\"id_subject\">\n";
		while($sub=$myDB->objetSuivant($subjects))
		{
		   $subjectTxt=$subjectTxt."<option value=\"$sub->id_subject\"";
		   if($sub->id_subject==$id_subject) $subjectTxt=$subjectTxt." selected=\"true\"";
		   $subjectTxt=$subjectTxt.">$sub->subject</option>\n";
		}	
		$subjectTxt=$subjectTxt."</select>\n";
		$questTable->line();
		$questTable->cell("Sujet du questionnaire : ");
		$questTable->cell($subjectTxt);
		
		// Titre du questionnaire
		$questTable->line();
		$questTable->cell("Titre du questionnaire : ");
		$questTable->cell(newTextField("title",$title,50));
		
		// Correction du questionnaire
		$questTable->line();
		$questTable->cell("Faire la correction : ");
		$correctionTxt="";
		if($correction==1)
		{
			$correctionTxt=$correctionTxt . 'oui ' . radioButton("correction",1,"checked=\"true\"");
			$correctionTxt=$correctionTxt . 'non ' . radioButton("correction",0);
		}
		else
		{
			$correctionTxt=$correctionTxt . 'oui ' . radioButton('correction',1);
			$correctionTxt=$correctionTxt . 'non ' . radioButton('correction',0,"checked=\"true\"");
		}

		$questTable->cell($correctionTxt);
		
    // Type du questionnaire
    
    $typeTxt="<select name=\"type\" onchange=\"submit()\">\n";
		
		if($type==QCM)
    {
    	$typeTxt=$typeTxt."<option value=\"".QCM."\" selected=\"selected\">QCM</option>\n";
    	$typeTxt=$typeTxt."<option value=\"".SONDAGE."\">sondage</option>\n";
    }
    else
    { 
    	$typeTxt=$typeTxt."<option value=\"".QCM."\">QCM</option>\n";
    	$typeTxt=$typeTxt."<option value=\"".SONDAGE."\" selected=\"selected\">sondage</option>\n";
    }
    
    $typeTxt=$typeTxt."</select>\n";
    
    $questTable->line();
    $questTable->cell('Type de questionnaire : ');
    $questTable->cell($typeTxt);
    
		// Politique de notation
    if($type==QCM)
    {
			$questTable->line();
			$questTable->cell('Politique de notation : ');
			$questTable->cell('Points  ajouter : ' . newTextField('addOnSuccess',$addOnSuccess,3));
			$questTable->cell('Points  enlever : ' .newTextField('removeOnFail',$removeOnFail,3));
		}
		$content = $content . $questTable->endTable();
		$content = $content . "</div>\n";
		
		// deuxime cadre permettant
		// - l'ajout de questions dans le questionnaire

		$content = $content . "<div class=\"caption\">";
		$contentTable = new Table("lightgrey");
		
		// Trier par sujet :
		$subjectTxt=null;
		$request = "SELECT * FROM subjects";
		$subjects=$myDB->execRequete($request);
		$subjectTxt="<select name=\"cur_subject\" onchange=\"submit()\">\n";
		while($sub=$myDB->objetSuivant($subjects))
		{
		   $subjectTxt=$subjectTxt."<option value=\"$sub->id_subject\"";
		   if($sub->id_subject==$cur_subject) $subjectTxt=$subjectTxt." selected=\"selected\"";
		   $subjectTxt=$subjectTxt.">$sub->subject</option>\n";
		}	
		$subjectTxt=$subjectTxt."</select>\n";
        $contentTable->line();
		$contentTable->cell('Contrainte sur le sujet : ');
		$contentTable->cell($subjectTxt);
		$contentTable->cell('');
		
		// Trier par auteur :
		$peopleTxt=null;
		$request = 'SELECT * FROM people';
		$people=$myDB->execRequete($request);	
		$peopleTxt="<select name=\"cur_person\" onchange=\"submit()\">\n";
		while($person=$myDB->objetSuivant($people))
		{
		   $peopleTxt=$peopleTxt."<option value=\"$person->id_person\"";
		   if($person->id_person==$cur_person) $peopleTxt=$peopleTxt." selected=\"selected\"";
		   $peopleTxt=$peopleTxt.">$person->surname</option>\n";
		}	
		$peopleTxt=$peopleTxt."</select>\n";
		
        $contentTable->line();
		$contentTable->cell("Contrainte sur l'auteur : ");
		$contentTable->cell($peopleTxt);
		$contentTable->cell('');
		
		// les boutons :
		$btnTxt=null;
		$btnTxt=$btnTxt . submitField('addQuestion','ajouter','button').'<br/><br/>';
		$btnTxt=$btnTxt . submitField('delQuestion','supprimer','button');
		//if(isset($questContent))
		(array)$questContent = unserialize(urldecode($questContent));
		//if(isset($_REQUEST['addQuestion']) && !isin($possibleChoice,$questContent))
		if(isset($_REQUEST['addQuestion']) && !in_array($possibleChoice,(array)$questContent))
			$questContent[]=$possibleChoice;
		if(isset($_REQUEST['delQuestion']))
			$questContent=array_diff($questContent,array($questionChoiced));
			
		// Liste de gauche (questions non dans le questionnaire)
		if($cur_person==1 && $cur_subject==1)
			$request = 'SELECT * FROM questions';
		elseif($cur_person==1 && $cur_subject!=1)
			$request = "SELECT * FROM questions WHERE id_subject=$cur_subject";
		elseif($cur_person!=1 && $cur_subject==1)
			$request = "SELECT * FROM questions WHERE id_person=$cur_person";
		else
			$request = "SELECT * FROM questions WHERE id_person=$cur_person AND id_subject=$cur_subject";
			
		$listeChoix=$myDB->execRequete($request);	
		$choixTxt="<select class=\"list\" name=\"possibleChoice\" size=\"10\">\n";
		while($choices=$myDB->objetSuivant($listeChoix))
		{
			if(!in_array($choices->id_question,(array)$questContent))
				$choixTxt=$choixTxt."<option value=\"$choices->id_question\">$choices->question</option>";
		}
		$choixTxt=$choixTxt."</select>\n";
		
		
		// Liste de droite (questions dans le questionnaire)
		$request="SELECT * FROM questions";
		$listeChoisis=$myDB->execRequete($request);	
		$choisisTxt="<select class=\"list\" name=\"questionChoiced\" size=\"10\">\n";
		while($choiced=$myDB->objetSuivant($listeChoisis))
		{
			if(in_array($choiced->id_question,(array)$questContent))
				$choisisTxt=$choisisTxt."<option value=\"$choiced->id_question\">$choiced->question</option>";
		}
		$choisisTxt=$choisisTxt."</select>\n";
		
		$contentTable->line();
		$contentTable->cell($choixTxt);
		$contentTable->cell($btnTxt,'lightgrey','center');
		$contentTable->cell($choisisTxt);
		$content = $content . $contentTable->endTable();
		
		$questContent=urlencode(serialize($questContent));
		$content = $content . hiddenField("questContent",$questContent);
		
		$content = $content . "</div>\n";
		$content = $content . centre(submitField('storeQuestionnaire','valider','validation'));
	$content = $content . "</form>";	
	}
	/******************************************/
	/* ENREGISTREMENT DANS LA BASE DE DONNEES */
	/******************************************/
	else
	{
		$canStore=true;
		$msgErr=null;
		$myTable=new Table('#eeeeee');
		/*
		On vrifie que le sujet a bien t slctionn 
		*/
		$content = $content . "<div class=\"status\">\n";
		$myTable->line();
		if($id_subject == 1)
		{
			$canStore=false;
			$myTable->cell('Enregistrement du sujet');
			$myTable->cell('[ '. bold(red('FAILED')) . ']');
			$msgErr = $msgErr . red("Il n'y a pas de sujet !") . "<br/>\n";
		}
		else
		{
			$myTable->cell('Enregistrement du sujet');
			$myTable->cell('[ '. bold(green('OK')) . ']');
		}
		
		/*
		On vrifie l'intitul de la question
		*/
		$myTable->line();
		if(empty($title))
		{
		/* 
		TODO regarder si le questionnaire n'existe pas dj
		*/
			$canStore=false;
			$myTable->cell('Enregistrement du questionnaire');
			$myTable->cell('[ '. bold(red('FAILED')) . ']');
			$msgErr = $msgErr . red("l'intitul du questionnaire est vide !") . "<br/>\n";
		}
		else
		{
			$myTable->cell('Enregistrement du questionnaire');
			$myTable->cell('[ '. bold(green('OK')) . ']');
		}
		
		/*
		On vrifie si le nombre de points  ajouter est bien un entier
		*/
		$myTable->line();
    if($type==QCM)
    {
			$addOnSuccess=ereg_replace("[^0-9]",'',$addOnSuccess);
			if(strlen($addOnSuccess)==0)
			{
				$canStore=false;
				$myTable->cell("Nombre de point  ajouter en cas de succs");
				$myTable->cell('[ '. bold(red('FAILED')) . ']');
				$msgErr = $msgErr . red("la valeur entre n'est pas un entier") . "<br/>\n";
			}
			else
			{
				$myTable->cell("Nombre de point  ajouter en cas de succs est $addOnSuccess");
				$myTable->cell('[ '. bold(green('OK')) . ']');
			}
		
			
			// On vrifie si le nombre de points  retirer est bien un entier
		
			$myTable->line();
		
			$removeOnFail=ereg_replace("[^0-9]",'',$removeOnFail);
			if(strlen($removeOnFail)==0)
			{
				$canStore=false;
				$myTable->cell("Nombre de point  retirer en cas d'chec");
				$myTable->cell('[ '. bold(red('FAILED')) . ']');
				$msgErr = $msgErr . red("la valeur entre n'est pas un entier") . "<br/>\n";
			}
			else
			{
				$myTable->cell("Nombre de point  retirer en cas d'chec est $removeOnFail");
				$myTable->cell('[ '. bold(green('OK')) . ']');
			}
		}
    
		//On vrifie que le questionnaire contient bien des questions
		
		$questContent = unserialize(urldecode($questContent));
		$myTable->line();
		if(count($questContent)==0)
		{
			$canStore=false;
			$myTable->cell('Questions');
			$myTable->cell('[ '. bold(red('FAILED')) . ']');
			$msgErr = $msgErr . red("Le questionnaire ne contient pas de questions !") . "<br/>\n";
		}
		else
		{
			$myTable->cell('Questions');
			$myTable->cell('[ '. bold(green('OK')) . ']');
		}
		
		
		if($canStore)
		{
			// Enregistrement des donnes dans la table questionnaires :
			$request = "INSERT INTO questionnaires (title,id_subject,id_person,type,correction, addOnSuccess, removeOnFail) ".
						"VALUES('$title','$id_subject','$id_person',$type,'$correction',$addOnSuccess,$removeOnFail)";

			$myTable->line();
			if($myDB->execRequete($request)!=1)
			{
				$myTable->cell("Table 'questionnaire'");
				$myTable->cell('[ '. bold(red('FAILED')) . ']');
				$msgErr = $msgErr . red("Erreur d'enregistrement dans la base de donnes !") . "<br/>\n";
			}
			else
			{
				$myTable->cell("Table 'questionnaire'");
				$myTable->cell('[ '. bold(green('OK')) . ']');
				$id_question = mysql_insert_id();
			}

			$id_questionnaire = mysql_insert_id();
		
			// Enregistrement des donnes dans la table questionnaires_content :
			for($i=0;$i<count($questContent);$i++)
			{
				$request="INSERT INTO questionnaires_content (id_questionnaire, id_question)".
							" VALUES($id_questionnaire,'$questContent[$i]')";
				$myTable->line();
				if($myDB->execRequete($request)!=1)
				{
					$myTable->cell("Table 'questionnaires_content' question numro " . $questContent[$i]);
					$myTable->cell('[ '. bold(red('FAILED')) . ']');
					$msgErr = $msgErr . red("Erreur d'enregistrement dans la base de donnes !") . "<br/>\n";
				}
				else
				{
					$myTable->cell("Table 'questionnaires_content' question numro " . $questContent[$i]);
					$myTable->cell('[ '. bold(green('OK')) . ']');
				}
			}
	}//fin du if($canStore)
	$content = $content . $myTable->endTable();
		if(!$canStore)
		{
			$content = $content . '<br/><u>Messages de debuggage :</u><br/>';
			$msgErr = $msgErr . startForm($_SERVER['PHP_SELF']);
			$msgErr = $msgErr . hiddenField('id_subject', $id_subject);
			$msgErr = $msgErr . hiddenField('cur_person', $cur_person);
			$msgErr = $msgErr . hiddenField('cur_subject', $cur_subject);
			$msgErr = $msgErr . hiddenField('correction', $correction);
			$msgErr = $msgErr . hiddenField('title', $title);
			$msgErr = $msgErr . hiddenField('possibleChoice', $possibleChoice);
			$msgErr = $msgErr . hiddenField('questionChoiced', $questionChoiced);
			$msgErr = $msgErr . hiddenField('questContent', urlencode(serialize($questContent)));
			$msgErr = $msgErr . hiddenField('addOnSuccess', $addOnSuccess);
			$msgErr = $msgErr . hiddenField('removeOnFail', $removeOnFail);
			$msgErr = $msgErr . centre(submitField('btnReturn','modifier les valeurs','validation'));
			$msgErr = $msgErr . "</form>\n";
		}
		$content = $content . $msgErr . "</div>\n";
	} // Fin de l'enregistrement
	
  $myDB->quitter();
	$page->setContent($content);
	echo $page->getPage($_SESSION['access']);
?>
