<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

require_once('parameters.inc.php');
require_once('Note.class.php');
require_once(ERROR_LOG_MODULE);

define('NOTES_FILE','notes.tmp');

class Notes{
	private static $__instance;
	private $note_msgs = array();
	private $note_types = array();
	var $numOfNotes=0;

	//-- Constructor is private
	// This class is a singleton; the way to access it is:
	// Notes::getInstance();
	private function __construct(){
		$this->clearNotes();
	}
	
	//-- Static method
	public static function getInstance(){
		if (!self::$__instance) {
			log_error('Creating new Notes instance', DEBUG);
			self::$__instance = new Notes;  
		}
		return self::$__instance;
	}
	
	//-- Public methods
	function addNote($note_text, $note_type){
		$this->note_msgs[$this->numOfNotes]=$note_text;
		$this->note_types[$this->numOfNotes]=$note_type;
		$this->numOfNotes++;
		log_error("Note added: numOfNotes = " . $this->numOfNotes, DEBUG);
	}

	function getHTMLFormatedNotes(){
		$tmp='';
		log_error($this->numOfNotes . ' note(s) to print', DEBUG);
		for($i=0;$i<$this->numOfNotes;$i++){		
			if($this->note_types[$i] == SUCCESS_NOTE){
				$tmp = $tmp . '<div class="success-note">';
				log_error('success note printed', DEBUG);
			}
			else {
				$tmp = $tmp . '<div class="failure-note">';
				log_error('failure note printed', DEBUG);
			}
		
		$tmp=$tmp . $this->note_msgs[$i] . "</div>\n";
		}
		//$this->clearNotes();
		return $tmp;
	}

	//-- Private methods
	private function clearNotes(){
		log_error('Notes cleared', DEBUG);
		reset($this->note_msgs);
		reset($this->note_types);
		$this->numOfNotes=0;
	}
}
?>
