<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

/*******************************************************************************
Name : 	    newQuestion.php
Version : 	1.0
Date : 	    15th May 2004 
Author : 	Fabrice DUFOUR <Fabrice.Dufour@clubinfo.org>

Save new question in the database
*******************************************************************************/
	require_once('parameters.inc.php');
  require_once(PHPMCQ_HOME . 'PageLayout.class.php');
	require_once(PHPMCQ_HOME . 'xhtml.php');
	require_once(PHPMCQ_HOME . 'DataBase.class.php');
	require_once(PHPMCQ_HOME . 'Table.class.php');
	require_once(PHPMCQ_HOME . 'utils.php');
	
require_once(ACCESS_MODULE);
check_access(ADMINS_ONLY);
  
	$page=new PageLayout('WebQCM');
	$page->setStyleSheet(CSS_FILES_PATH . 'webQCM.css');
  $page->setTitleBar('<h1>Ajouter une question</h1>');
  
  $content=null;
  
	$id_person=getVariable('id_person',1);
	$id_subject=getVariable('id_subject',1);
	$nbProp=getVariable('nbProp',2);
	$question=addslashes(utf8_decode(getVariable('question')));
	$link=getVariable('link');
	$teacherComment=getVariable('teacherComment');
	
	//rcupration des propositions
	for($i=1;$i<=$nbProp;$i++)
	$propositions[$i]=addslashes(getVariable('prop'.$i));

	//rcupration des images
	//for($i=1;$i<=$nbProp;$i++)
	//	$images[$i]=addslashes(getVariable('image'.$i));

	//rcupration des propositions justes
	for($i=1;$i<=$nbProp;$i++)
		$propJustes[$i]=getVariable('check'.$i);

	
	// Dans tous les cas on ouvre une connection  la base de donnes
	
	$myDB = new dataBase();

	if(!isset($_REQUEST['btnValider']))
	{
		
		// On slctionne tous les sujets dans la base de donnes afin de les
		// proposer  l'utilisateur
		
		$request = "SELECT * FROM subjects";
		$subjects=$myDB->execRequete($request);
		$subjectTxt="<select name=\"id_subject\">\n";
		while($sub=$myDB->objetSuivant($subjects))
		{
			$subjectTxt=$subjectTxt."<option value=\"$sub->id_subject\"";
			if($sub->id_subject==$id_subject) $subjectTxt=$subjectTxt." selected=\"true\"";
				$subjectTxt=$subjectTxt.">$sub->subject</option>\n";
		}	
		$subjectTxt=$subjectTxt."</select>\n";

		/*
		On fait une table affichant un champ pour :
		- Le sujet
		- L'intitul de la question
		- Une image optionelle
		- le nombre de propositions 
		*/
		$content = $content . startForm($_SERVER['PHP_SELF']);
		$content = $content . "<div class=\"caption\">";
		$questTable = new Table('lightgrey');

		$questTable->line();
		$questTable->cell('Sujet : ');
		$questTable->cell($subjectTxt);

		$questTable->line();
		$questTable->cell('Intitul de la question : ');
		$questTable->cell(newTextField('question',$question,65));

		$questTable->line();
		$questTable->cell('Lien vers une image (optionnel) : ');

		$questTable->cell(hiddenField('MAX_FILE_SIZE',1024*1024).newFileField('link',$link));

		$questTable->line();
		$questTable->cell('Nombre de propositions : ');

		// Affichage d'un menu droulant qui permet de slctionner le nombre de propositions
		$tmp="<select name=\"nbProp\" onchange=\"submit()\">\n";
    
    // Question ouverte
    $tmp=$tmp."<option value=\"0\"";
			if(0==$nbProp) $tmp=$tmp." selected=\"true\"";
				$tmp=$tmp.">ouvert</option>\n";
        
		for($i=1;$i<=9; $i++)
		{
			$tmp=$tmp."<option value=\"$i\"";
			if($i==$nbProp) $tmp=$tmp." selected=\"true\"";
				$tmp=$tmp.">$i</option>\n";
		}	
		$tmp=$tmp."</select>\n";
		$questTable->cell($tmp);
		$content = $content . $questTable->endTable();
		$content = $content . "</div>\n";

		
		//On fait une table pour que l'utilisateur entre le libell de chaque 
		//rponse et s'il le dsire une image associe  la rponse.
		
		$content = $content . "<div class=\"caption\">";
		$propTable = new Table('lightgrey');
		$propTable->line();
		$propTable->cell('');
		$propTable->cell('');
		if($nbProp==0)
    {
    	$propTable->cell('question ouverte','','center');
		}
    else
    {
    	$propTable->cell("cochez les <br/>rponses correctes","","center");
    }
    
		for($i=1;$i<=$nbProp; $i++)
		{
			$propTable->line();
			$propTable->cell("Proposition $i : ");
			$propTable->cell(newTextField("prop$i",$propositions[$i],50));
			$propTable->line();
			$propTable->cell("image (optionnelle) : ");
			$propTable->cell(newFileField("image$i","images[$i]"));
			if($propJustes[$i]==$i)
				$propTable->cell(checkbox("check$i",$i,"checked=\"true\""),'','center',2,1);
			else
				$propTable->cell(checkbox("check$i",$i),'','center',2,1);
		}
		$content = $content . $propTable->endTable();
		$content = $content . '</div>';
		/*
		On rserve ici une partie pour les commentaires du professeur !
		*/
		$content = $content . "<div class=\"caption\">";
		$content = $content . "Commentaires (affichs lors de la rponse) :<br/>\n";
		$content = $content . "<textarea cols=\"75\" rows=\"7\" name=\"teacherComment\" id=\"teacherComment\">$teacherComment</textarea>";
		$content = $content . '</div>';
		$content = $content . submitField('btnValider','Valider','validation');
		$content = $content . endForm();
	}
	/******************************************/
	/* ENREGISTREMENT DANS LA BASE DE DONNEES */
	/******************************************/
	else
	{
		$canStore=true;
		$msgErr=null;
		$myTable=new Table('#eeeeee');
		/*
		On vrifie que le sujet a bien t slctionn 
		*/
		$content = $content . "<div class=\"status\">\n";
		$myTable->line();
		if($id_subject == 1)
		{
			$canStore=false;
			$myTable->cell('Enregistrement du sujet');
			$myTable->cell('[ '. bold(red('FAILED')) . ']');
			$msgErr = $msgErr . red("Il n'y a pas de sujet !") . "<br/>\n";
		}
		else
		{
			$myTable->cell('Enregistrement du sujet');
			$myTable->cell('[ '. bold(green('OK')) . ']');
		}
		
		/*
		On vrifie que la question n'est pas vide
		TODO : vrifier que la question n'existe pas dj
		*/
		$myTable->line();
		if(empty($question))
		{
			$canStore=false;
			$myTable->cell('Enregistrement de la question');
			$myTable->cell('[ '. bold(red('FAILED')) . ']');
			$msgErr = $msgErr . red("l'intitul de la question est vide !") . "<br/>\n";
		}
		else
		{
			$myTable->cell('Enregistrement de la question');
			$myTable->cell('[ '. bold(green('OK')) . ']');
		}
		
		for($i=1;$i<=$nbProp;$i++)
		{
			$myTable->line();
			if($propositions[$i] == '')
			{
				$canStore=false;
				$myTable->cell("Enregistrement de la proposition $i");
				$myTable->cell('[ '. bold(red("FAILED")) . ']') . "<br/>\n";
				$msgErr = $msgErr . red("l'intitul de la proposition $i est vide !") . "<br/>\n";
			}
			else
			{
				$myTable->cell("Enregistrement de la proposition $i");
				$myTable->cell('[ '. bold(green("OK")) . ']') . "<br/>\n";
			}
		}

		if($canStore)
		{
    	$open=0;
      if(0==$nbProp) $open=1;
      
			// Enregistrement des donnes dans la table questions :
			$request = "INSERT INTO questions (question,link,id_subject,id_person, teacherComment, open) ".
						"VALUES('" . addslashes($question) . "','','$id_subject','$id_person','".addslashes($teacherComment)."', $open)";
			
			$myTable->line(); 
			if($myDB->execRequete($request)!=1)
			{
			
				$myTable->cell("Enregistrement des donnes dans la table 'questions'");
				$myTable->cell('[ '. bold(red("FAILED")) . ']') . "<br/>\n";
			}
			else
			{
				$myTable->cell("Enregistrement des donnes dans la table 'questions'");
				$myTable->cell('[ '. bold(green('OK')) . ']') . "<br/>\n";
				$id_question = mysql_insert_id();
			}
			
			
			//Tlchargement de l'image s'il y a lieu 
			
			$myTable->line();  
			if (move_uploaded_file($_FILES['link']['tmp_name'], UPLOAD_FILES_PATH . $id_question . '_' . $_FILES['link']['name'])) 
			{
				$myTable->cell("Enregistrement de l'image");
				$myTable->cell('[ '. green(bold('OK')) . ']') . "<br/>\n";
				$link=$id_question . '_' . $_FILES['link']['name'];
			} 
			else 
			{
				$link='';
				$myTable->cell("Enregistrement de l'image");
				$myTable->cell('[ '. bold('NONE') . ']') . "<br/>\n";
			}
			$request="UPDATE questions SET link='$link' WHERE id_question=" . $id_question;
			$myDB->execRequete($request);
			// Enregistrement des donnes dans la table suggestions :
			for($i=1;$i<=$nbProp;$i++)
			{
				$request="INSERT INTO suggestions (suggestion, id_question)".
							" VALUES('$propositions[$i]', $id_question)";
				
				$myTable->line(); 
				if($myDB->execRequete($request)!=1)
				{
					$myTable->cell("Enregistrement des donnes de la proposition $i dans la table 'suggestions'");
					$myTable->cell('[ '. bold(red("FAILED")) . ']');
				}
				else
				{
					$id_suggestion=mysql_insert_id();
					$myTable->cell("Enregistrement des donnes de la proposition $i dans la table 'suggestions'");
					$myTable->cell('[ '. bold(green('OK')) . ']');
					// Enregistrement des donnes dans la table answers :
					if($propJustes[$i]==$i)
					{
						$myTable->line(); 
						$request="INSERT INTO answers (id_question,id_suggestion) VALUES($id_question,$id_suggestion)";
						if($myDB->execRequete($request)!=1)
						{
							$myTable->cell("Enregistrement des donnes de la proposition $i dans la table 'answers'");
							$myTable->cell('[ '. bold(red("FAILED")) . ']');
						}
						else
						{
							$myTable->cell("Enregistrement des donnes de la proposition $i dans la table 'answers'");
							$myTable->cell('[ '. bold(green('OK')) . ']');
						}
					}
				
				
				//Tlchargement des images
			  
				$myTable->line();  
					$suggestionLink='';
				if (move_uploaded_file($_FILES['image'.$i]['tmp_name'], UPLOAD_FILES_PATH .$id_question.'_'.$id_suggestion.'_'.$_FILES['image'.$i]['name'])) 
				{
					$myTable->cell("Enregistrement de l'image : " . $_FILES['image'.$i]['name']);
					$myTable->cell('[ '. green(bold('OK')) . ']');
					//$link=$_FILES['link']['name'];
					$suggestionLink=$id_question.'_'.$id_suggestion.'_'.$_FILES['image'.$i]['name'];
				} 
				else 
				{
				
					$myTable->cell("Enregistrement de l'image : " . $_FILES['image'.$i]['name']);
					$myTable->cell('[ '. bold('NONE') . ']');
				}
				$request="UPDATE suggestions SET link='$suggestionLink' WHERE id_suggestion=".$id_suggestion;
				$myDB->execRequete($request);
			}//fin du for pour toutes les suggestions
		}
		
			
		}//fin du if(canStore)
		$content = $content . $myTable->endTable();
		if(!$canStore)
		{
			$content = $content . '<br/><u>Messages de debuggage :</u><br/>';
			$msgErr = $msgErr . startForm($_SERVER['PHP_SELF']);
			$msgErr = $msgErr . hiddenField('id_subject', $id_subject);
			$msgErr = $msgErr . hiddenField('nbProp', $nbProp);
			$msgErr = $msgErr . hiddenField('teacherComment', $teacherComment);
			$msgErr = $msgErr . hiddenField('question', $question);
			// envoie des propositions
			for($i=1;$i<=$nbProp;$i++)
				$msgErr = $msgErr . hiddenField('prop'.$i, $propositions[$i]);
			// envoie des propositions justes
			for($i=1;$i<=$nbProp;$i++)
				$msgErr = $msgErr . hiddenField('check'.$i, $propJustes[$i]);
			$msgErr = $msgErr . centre(submitField('btnReturn','modifier les valeurs','validation'));
			$msgErr = $msgErr . "</form>\n";
		}
		$content = $content . $msgErr . "</div>\n";
	}
	$myDB->quitter();
  $page->setContent($content);
	echo $page->getPage($_SESSION['access']);
?>
