<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

/*******************************************************************************
Name : 	    newSubject.php
Version : 	1.0
Date : 	    21st August 2005 
Author : 	Fabrice DUFOUR <Fabrice.Dufour@clubinfo.org>

Save new subject in database
*******************************************************************************/

require_once("parameters.inc.php");
require_once(PHPMCQ_HOME . 'PageLayout.class.php');
require_once(PHPMCQ_HOME . 'xhtml.php');
require_once(PHPMCQ_HOME . 'DataBase.class.php');
require_once(PHPMCQ_HOME . 'Table.class.php');
require_once(PHPMCQ_HOME . 'utils.php');

require_once(ACCESS_MODULE);
check_access(ADMINS_ONLY);

$page=new PageLayout('WebQCM');
$page->setStyleSheet(CSS_FILES_PATH . 'webQCM.css');
$page->setTitleBar('<h1>Ajouter un sujet</h1>');
  
$content=null;
  
$subject=getVariable('subject');
	
if(!isset($_REQUEST['btn-ok'])){
	$content = $content . startForm($_SERVER['PHP_SELF']);
	/*$myTable = new Table("lightgrey");
	$myTable->line();
	$myTable->cell("Sujet :");
	$myTable->cell(newTextField("subject",$subject));
	$myTable->line();
	$myTable->cell(submitField('btnValider','valider'),'lightgrey','center',1,2);
	$content = $content . centre($myTable->endTable());
	*/
	//--
	$box = '';
	$box = $box . paragraph(h1('Sujet :') . newTextField('subject', $subject));
	$box = $box . paragraph(submitField('btn-ok','Valider'));
	
	$content = $content . box($box) . endForm();
}	
else{

	$myDB = new dataBase();
		
	//-- Manage Subject field	
	$request = "SELECT subject FROM subjects WHERE subject='$subject'";
	$subjectsList=$myDB->execRequete($request);

	if(strlen($subject) <= 0){
		$content = $content . failure_note('Le champs Sujet est vide');
		$content = $content . startForm($_SERVER['PHP_SELF']);
		$content = $content . hiddenField('subject', $subject);
		$content = $content . submitField('btnReturn','Retour au formulaire','validation');
		$content = $content . endForm();
	}
	elseif($myDB->objetSuivant($subjectsList)){
		$content = $content . failure_note('le sujet '. italic($subject) . ' existe dj');
		$content = $content . startForm($_SERVER['PHP_SELF']);
		$content = $content . hiddenField('subject', $subject);
		$content = $content . submitField('btnReturn','Retour au formulaire','validation');
		$content = $content . endForm();
	}
	else{
		$request = "INSERT INTO subjects (subject) VALUES('$subject')";
		$myDB->execRequete($request);
		
		if($myDB->enErreur()>=1){
			$content = $content . failure_note('Internal error. Please contact an administrator');
		}
		else{
			$content = $content . success_note('Sujet '. italic($subject) .' enregistr');
		}
	}
	$myDB->quitter();
}

$page->setContent($content);
echo $page->getPage($_SESSION['access']);
?>
