<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

/*******************************************************************************
Name : 	    newUser.php
Version : 	1.0
Date : 	    21st August 2005
Author : 	Fabrice DUFOUR <Fabrice.Dufour@clubinfo.org>

Save new people in database
*******************************************************************************/
require_once('parameters.inc.php');
require_once(PHPMCQ_HOME . 'PageLayout.class.php');
require_once(PHPMCQ_HOME . 'xhtml.php');
require_once(PHPMCQ_HOME . 'DataBase.class.php');
require_once(PHPMCQ_HOME . 'Table.class.php');
require_once(PHPMCQ_HOME . 'utils.php');
	
require_once(ACCESS_MODULE);
check_access(ADMINS_ONLY);
 
$page=new PageLayout('WebQCM');
$page->setStyleSheet(CSS_FILES_PATH . 'webQCM.css');
$page->setTitleBar('<h1>Nouvel Utilisateur</h1>');

$content='';
/* get variables */
$surname=getVariable('surname');
$firstname=getVariable('firstname');
$email=getVariable('email');
$job=getVariable('job');
$login=getVariable('login');
$password1=getVariable('password1');
$password2=getVariable('password2');
$access=getVariable('access', USER);

if(!isset($_REQUEST['btn-ok'])){
	$content = $content .  startForm($_SERVER['PHP_SELF']);
	/*
	$myTable = new Table('lightgrey');
	$myTable->line();
	$myTable->cell('Login : ');
	$myTable->cell(newTextField('login',$login));

	$myTable->line();
	$myTable->cell('Mot de passe : ');
	$myTable->cell(newPasswordField('password1'));

	$myTable->line();
	$myTable->cell('Confirmer le mot de passe : ');
	$myTable->cell(newPasswordField('password2'));

	$myTable->line();
	$myTable->cell('Nom :');
	$myTable->cell(newTextField('surname',$surname));

	$myTable->line();
	$myTable->cell('Prnom :');
	$myTable->cell(newTextField('firstname',$firstname));

	$myTable->line();
	$myTable->cell('Droits :');
	*/
	$accessSelect="<select name=\"access\" id=\"access\">\n";
	if($access== ADMIN) $select_option="selected=\"true\"";
	else $select_option="selected=\"false\"";
	$accessSelect=$accessSelect."<option value=\"" . ADMIN ."\" $select_option>Administrateur</option>\n";
	if($access== USER) $select_option="selected=\"true\"";
	else $select_option="selected=\"false\"";
	$accessSelect=$accessSelect."<option value=\"" . USER ."\" $select_option>Utilisateur</option>\n";
	$accessSelect=$accessSelect.'</select>';
	
	//$myTable->cell($accessSelect);

	/*$myTable->line();
	$myTable->cell(submitField('btn-ok','Valider'). submitField('btn-canceled',"Annuler"),'lightgrey','center',1,2);
	$content = $content . $myTable->endTable();
	*/
	//--
	$box = '';
	$box = $box . paragraph(h1('Login :') . newTextField('login', $login));
	$box = $box . paragraph(h1('Mot de passe :') . newPasswordField('password1'));
	$box = $box . paragraph(h1('Confirmer le nouveau mot de passe :') . newPasswordField('password2'));
	$box = $box . paragraph(h1('Nom :') . newTextField('surname', $surname));
	$box = $box . paragraph(h1('Prnom :') . newTextField('firstname', $firstname));
	$box = $box . paragraph(h1('Droits :') . $accessSelect);
	$box = $box . paragraph(submitField('btn-ok','Valider'));

	$content=$content . box($box) . endForm();
}	
else{ // here we check for errors
	$canStore=true;
	//-- Manage login field
	// login not already exist ? and is not empty ?
	$myDB = new dataBase();
	$request = "select * from people where login='$login'";
	$userExists=$myDB->execRequete($request);
	
	if(strlen($login)<=0){
		$content = $content . failure_note('Login vide non permis');
		$canStore=false;
	}
	
	if($myDB->objetSuivant($userExists)){
		$content = $content . failure_note('le login '. italic($login) . ' existe dj');
		$canStore=false;
	}
    
	//-- Manage password field
	$password='';
	if(strlen($password1)<=0 or strlen($password2)<=0){
		$content = $content . failure_note('Un mot de passe est vide');
		$canStore=false;
	}

	// password is the same ?
	if(strcmp($password1,$password2) != 0){
		$content = $content . failure_note('Les mots de passes ne correspondent pas');
		$canStore=false; 
	}
	else{
		$password = md5 ($password1);
	}

	//-- Manage surname field
	if(strlen($surname) <= 0){
		$content = $content . failure_note('Le champs Nom est vide');
		$canStore=false;
	}
    
	//-- Manage surname field
	if(strlen($firstname) <= 0){
		$content = $content . failure_note('Le champs Prnom est vide');
		$canStore=false;
	}

    // store in database
	if($canStore){
		$request = 	"INSERT INTO people (login, surname, firstname, password, access)" . 
						"VALUES('$login', '$surname', '$firstname', '$password', $access)";
		$myDB->execRequete($request);
		
		if($myDB->enErreur()>=1){
			$content = $content . failure_note('Internal error. Please contact an administrator');
		}
		else{
			$content = $content . success_note('Utilisateur '. italic($login) .' enregistr');
		}
	}
	else{
		$content = $content . startForm($_SERVER['PHP_SELF']);
		$content = $content . hiddenField('login', $login);
		$content = $content . hiddenField('surname', $surname);
		$content = $content . hiddenField('firstname', $firstname);
		$content = $content . submitField('btnReturn','Retour au formulaire','validation');
		$content = $content . endForm();
	}
    
	$myDB->quitter();
}
  
	$page->setContent($content);
	echo $page->getPage($_SESSION['access']);

?>
