--
--  Copyright (C) 2005, 2006  Stephan A. Rickauer
--
--  This file is part of phpMyMembers.

--  phpMyMembers is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  phpMyMembers is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with phpMyMembers; if not, write to the Free Software
--  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

-- 
-- Database: `phpMyMembers`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `Adresse1`
-- 

CREATE TABLE IF NOT EXISTS `Adresse1` (
  `Adressfeld1` varchar(50) default NULL,
  `Adressfeld2` varchar(50) default NULL,
  `Kanton` varchar(50) default NULL,
  `Postleitzahl` varchar(7) default NULL,
  `Stadt` varchar(50) default NULL,
  `Land` varchar(50) default NULL,
  `Telephon` varchar(50) default NULL,
  `Telefax` varchar(50) default NULL,
  `Mobil` varchar(50) default NULL,
  `EMail` varchar(50) default NULL,
  `Mitglied_ID` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`Mitglied_ID`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Table structure for table `Adresse2`
-- 

CREATE TABLE IF NOT EXISTS `Adresse2` (
  `Adressfeld1` varchar(50) default NULL,
  `Adressfeld2` varchar(50) default NULL,
  `Kanton` varchar(50) default NULL,
  `Postleitzahl` varchar(7) default NULL,
  `Stadt` varchar(50) default NULL,
  `Land` varchar(50) default NULL,
  `Telephon` varchar(50) default NULL,
  `Telefax` varchar(50) default NULL,
  `Mobil` varchar(50) default NULL,
  `EMail` varchar(50) default NULL,
  `Mitglied_ID` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`Mitglied_ID`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Table structure for table `Adresse3`
-- 

CREATE TABLE IF NOT EXISTS `Adresse3` (
  `Adressfeld1` varchar(50) default NULL,
  `Adressfeld2` varchar(50) default NULL,
  `Kanton` varchar(50) default NULL,
  `Postleitzahl` varchar(7) default NULL,
  `Stadt` varchar(50) default NULL,
  `Land` varchar(50) default NULL,
  `Telephon` varchar(50) default NULL,
  `Telefax` varchar(50) default NULL,
  `Mobil` varchar(50) default NULL,
  `EMail` varchar(50) default NULL,
  `Mitglied_ID` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`Mitglied_ID`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Table structure for table `Geschlecht`
-- 

CREATE TABLE IF NOT EXISTS `Geschlecht` (
  `Geschlecht_ID` tinyint(3) NOT NULL default '0',
  `Geschlecht` varchar(50) default NULL,
  PRIMARY KEY  (`Geschlecht_ID`)
) TYPE=MyISAM;

-- 
-- Daten für Tabelle `Geschlecht`
-- 

INSERT INTO `Geschlecht` VALUES (1, 'LANG_MALE');
INSERT INTO `Geschlecht` VALUES (2, 'LANG_FEMALE');

-- --------------------------------------------------------

-- 
-- Table structure for table `Mitglied`
-- 

CREATE TABLE IF NOT EXISTS `Mitglied` (
  `Mitglied_ID` mediumint(7) NOT NULL auto_increment,
  `Mitgliednummer` mediumint(7) NOT NULL default '0',
  `Nachname` varchar(50) NOT NULL default '',
  `Vorname` varchar(50) NOT NULL default '',
  `Geburtsdatum` date NOT NULL default '0000-00-00',
  `Geschlecht_ID` tinyint(3) default NULL,
  `Zivilstand_ID` tinyint(3) default NULL,
  `Eintritt` date NOT NULL default '0000-00-00',
  `Austritt` date default NULL,
  `Photo` mediumblob,
  `Mitgliedschaft_ID` tinyint(3) default NULL,
  `Update` date default NULL,
  `Update_ID` mediumint(7) NOT NULL default '0',
  `Beruf` varchar(50) default NULL,
  `Titel` varchar(10) default NULL,
  `GL` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`Mitglied_ID`)
) TYPE=MyISAM AUTO_INCREMENT=11;

-- --------------------------------------------------------

-- 
-- Table structure for table `Mitgliedschaft`
-- 

CREATE TABLE IF NOT EXISTS `Mitgliedschaft` (
  `Mitgliedschaft_ID` tinyint(3) NOT NULL default '0',
  `Mitgliedschaft` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`Mitgliedschaft_ID`)
) TYPE=MyISAM;

-- 
-- Daten für Tabelle `Mitgliedschaft`
-- 

INSERT INTO `Mitgliedschaft` VALUES (1, 'MEMBERSHIP1');
INSERT INTO `Mitgliedschaft` VALUES (2, 'MEMBERSHIP2');
INSERT INTO `Mitgliedschaft` VALUES (3, 'MEMBERSHIP3');
INSERT INTO `Mitgliedschaft` VALUES (4, 'MEMBERSHIP4');
INSERT INTO `Mitgliedschaft` VALUES (5, 'MEMBERSHIP_ALUMNI');

-- --------------------------------------------------------

-- 
-- Table structure for table `Zivilstand`
-- 

CREATE TABLE IF NOT EXISTS `Zivilstand` (
  `Zivilstand_ID` tinyint(3) NOT NULL default '0',
  `Zivilstand` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`Zivilstand_ID`)
) TYPE=MyISAM;

-- 
-- Daten für Tabelle `Zivilstand`
-- 

INSERT INTO `Zivilstand` VALUES (1, 'LANG_UNMARRIED');
INSERT INTO `Zivilstand` VALUES (2, 'LANG_MARRIED');
INSERT INTO `Zivilstand` VALUES (3, 'LANG_DIVORCED');
INSERT INTO `Zivilstand` VALUES (4, 'LANG_WIDOWED');

-- --------------------------------------------------------

-- 
-- Tabellenstruktur für Tabelle `phpauthent_groups`
-- 

CREATE TABLE `phpauthent_groups` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(32) NOT NULL default '',
  `description` varchar(80) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur für Tabelle `phpauthent_relation`
-- 

CREATE TABLE `phpauthent_relation` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `group_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur für Tabelle `phpauthent_users`
-- 

CREATE TABLE `phpauthent_users` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(32) NOT NULL default '',
  `password` varchar(64) default NULL,
  `realname` varchar(80) default NULL,
  `email` varchar(120) default NULL,
  `lastlogin` datetime default NULL,
  `creation` date default NULL,
  `numlogins` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `username` (`username`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;


-- Initialisation
-- An administrator (name 'administrator', password 'phpauthent') is created at engine initialization
-- A user who belongs to the 'admin' group, and is necessary to access the administration interface.
INSERT INTO `phpauthent_groups` ( `id` , `name` ) VALUES ('1', 'admin');
INSERT INTO `phpauthent_groups` ( `id` , `name` ) VALUES ('2', 'edit');
INSERT INTO `phpauthent_relation` ( `id` , `user_id` , `group_id` ) VALUES ('1', '1', '1');
INSERT INTO `phpauthent_users` ( `id` , `username` , `password` ) VALUES ('1', 'administrator', 'b5e0a6d8b8e3becfd6ac' );
