<?
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

///////////////////////////////////////////////////////////////////////
// Database settings                                                ///
///////////////////////////////////////////////////////////////////////

$dbname     = "phpMyMembers";
$dbserver   = "localhost";
$dbuser     = "phpMyMembers";
$dbpass     = "php4you";

///////////////////////////////////////////////////////////////////////
// General settings                                                 ///
///////////////////////////////////////////////////////////////////////

// Will be shown in every page header
define('TITLE', 'Your title here');

// Path settings
define('STYLE', 'default.css');
define('PHPMYMEMBERS_DIR','/srv/www/htdocs/phpMyMembers');

// Language of the frontend, currently only 'german' supported
define('LANG','german');

// Whether to display the status infos at the bottom of every page
$show_status = true;

// Date format, required for conversions between mysql and human
// Currently, DD.MM.YYYY and YYYY-MM-DD are supported
define('HUMAN_DATE_FORMAT','DD.MM.YYYY');

// The main site lists some members stats. Give a time period here
define('REPORT_PERIOD','30');

// Should we confirm database inserts/updates with a javascript popup?
define('CONFIRM_DB_WRITES_WITH_POPUP','true');

///////////////////////////////////////////////////////////////////////
// PDF label printing options, mostly directly for fpdf            ////
///////////////////////////////////////////////////////////////////////

// PDF page format (currently only 'SmartLabel' supported)
define('LABEL_FORMAT','SmartLabel');

// Dimensions of single label. Be aware that those entries are
// relative to the orientation defined below.
define('LABEL_WIDTH', '38.1');
define('LABEL_HEIGHT','99.1');

// 'L'andscape or 'P'ortrait
define('LABEL_ORIENTATION','L');

// The following group may get printed with special options when
// generating PDF's. Leave empty if you don't need that.
define('SPECIAL_PDF_PRINT','MEMBERSHIP2');

///////////////////////////////////////////////////////////////////////
// Datepicker configuration, for more details have a look at        ///
// http://dali.mty.itesm.mx/~hugo/js/datepickercontrol/             ///
///////////////////////////////////////////////////////////////////////

define('DPC_BUTTON_POSITION','out');
define('DPC_BUTTON_OFFSET_X','5');
define('DPC_FIRST_WEEK_DAY','1');

///////////////////////////////////////////////////////////////////////
// !Don't modify things below unless you know what you're doing!    ///
///////////////////////////////////////////////////////////////////////

// Change this if you use a different version of fpdf (1.53 = 153)
define('FPDF_VERSION', '153');

define('PHPMYMEMBERS_VERSION','0.01a');
define('INCLUDE_DIR', PHPMYMEMBERS_DIR . '/include/');
define('LANGUAGE_DIR', INCLUDE_DIR . 'language/');
define('FPDF_INSTALLDIR', INCLUDE_DIR . 'fpdf' . FPDF_VERSION . '/');
define('FPDF_FONTPATH', FPDF_INSTALLDIR . 'font/');
define('CSS_FILE', 'include/css/' . STYLE);

require(LANGUAGE_DIR . LANG . ".php");
?>
