<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

include("include/dbconnect.php");

// Only people of the phpAuthent group 'edit' may submit the form
// We can get the user with 'getUserId()'
require_once(PHPMYMEMBERS_DIR . "/include/phpauthent/phpauthent_core.php");
$userlist = array("");
$grouplist = array("edit");

// We can't send headers when showing the status page (= success page)
// since we'd like to redirect automatically afterwards.
if ( ($_REQUEST['action'] != 'update') and ($_REQUEST['action'] != 'insert') ) {
	include("include/header.inc");
	?>
<TABLE class='main'>
 <TR>
  <TD>
	<?
} else {
	require("include/functions.php");
}

/*
BE CAREFUL:
This file deals with four (4) POST variables, two come
from detail.php and another two are self-generated (in here):

  - update (self-generated)
  - insert (self-generated)

  - edit (from detail.php)
  - new (from detail.php)

where 'edit' <=> 'update' and 'new' <=> 'insert' belong togther.
The ones from detail.php are to tell this script whether we need
to update or insert, but the other self-generated ones are there
to actually trigger the corresponding sql commands.
*/

//print_r($_REQUEST['action']);

$date 	= date('Y-m-d');
$action	= $_REQUEST['action'];
$me	= $_SERVER['PHP_SELF'];

$Mitglied_ID            = $_POST['Mitglied_ID'];
$Nachname               = $_POST['Nachname'];
$Vorname                = $_POST['Vorname'];
$Titel                  = $_POST['Titel'];
$Mitgliednummer         = $_POST['Mitgliednummer'];
$Geburtsdatum           = $_POST['Geburtsdatum'];
$Beruf                  = $_POST['Beruf'];
$Eintritt               = $_POST['Eintritt'];
$Austritt               = $_POST['Austritt'];
$Mitgliedschaft_ID      = $_POST['Mitgliedschaft_ID'];
$Zivilstand_ID          = $_POST['Zivilstand_ID'];
$Geschlecht_ID          = $_POST['Geschlecht_ID'];
$GL                     = $_POST['GL'];

$Adress_ID              = $_POST['Adress_ID'];
$Adressfeld1            = $_POST['Adressfeld1'];
$Adressfeld2            = $_POST['Adressfeld2'];
$Kanton                 = $_POST['Kanton'];
$Postleitzahl           = $_POST['Postleitzahl'];
$Stadt                  = $_POST['Stadt'];
$Land                   = $_POST['Land'];
$Telephon               = $_POST['Telephon'];
$Telefax                = $_POST['Telefax'];
$Mobil                  = $_POST['Mobil'];
$EMail                  = $_POST['EMail'];

switch($action) {
case "update":

	$Mitglied_upd_sql 	= sprintf("
				UPDATE `Mitglied` SET
					`Nachname`		=%s,
					`Vorname`		=%s,
					`Titel`			=%s,
					`Mitgliednummer`	=%s,
					`Geburtsdatum`		=%s,
					`Beruf`			=%s,
					`Eintritt`		=%s,
					`Austritt`		=%s,
					`GL`			=%s,
					`Mitgliedschaft_ID`	=%s,
					`Zivilstand_ID`		=%s,
					`Geschlecht_ID`		=%s,
					`Update`		=%s,
					`Update_ID`		=%s
				WHERE `Mitglied_ID`=%s",
				quote_smart($Nachname),
				quote_smart($Vorname),
				quote_smart($Titel),
				quote_smart($Mitgliednummer),
				quote_smart($Geburtsdatum),
				quote_smart($Beruf),
				quote_smart($Eintritt),
				quote_smart($Austritt),
				quote_smart($GL),
				quote_smart($Mitgliedschaft_ID),
				quote_smart($Zivilstand_ID),
				quote_smart($Geschlecht_ID),
				quote_smart($date),
				quote_smart(getUserID()),
				quote_smart($Mitglied_ID)
				);

	$Adress_table  		= "Adresse" . "$Adress_ID";

	// Check whether the address to be updated already exists,
	// if not, we need to 'insert' instead of 'update'. If no
	// field of the address POSTs is set, we delete the address
	// if not the main one.
	// insert: 0 // update: 1 // delete: 2

	$check_for_address_sql 	= sprintf("
					SELECT COUNT(`Mitglied_ID`) FROM `$Adress_table`
					WHERE `Mitglied_ID`=%s", quote_smart($Mitglied_ID)
				);

	$result = mysql_query($check_for_address_sql)
		or die('Could not check adress table: ' . mysql_error());

        while ($row = mysql_fetch_row($result)) {
                $value = $row[0];
        }

	// Address already existent, 'update' or 'delete' should be ok
	switch($value) {
	case '1':
		if (
		   !empty($Adressfeld1) or
		   !empty($Adressfeld2) or
		   !empty($Kanton) or
		   !empty($Postleitzahl) or
		   !empty($Stadt) or
		   !empty($Land) or
		   !empty($Telephon) or
		   !empty($Telefax) or
		   !empty($Mobil) or
		   !empty($EMail)
		   ) {
			$Adress_upd_sql	= sprintf("
				UPDATE `$Adress_table` SET
					`Adressfeld1`	=%s,
					`Adressfeld2`	=%s,
					`Kanton`	=%s,
					`Postleitzahl`	=%s,
					`Stadt`		=%s,
					`Land`		=%s,
					`Telephon`	=%s,
					`Telefax`	=%s,
					`Mobil`		=%s,
					`EMail`		=%s
				WHERE `Mitglied_ID`	=%s",
					quote_smart($Adressfeld1),
					quote_smart($Adressfeld2),
					quote_smart($Kanton),
					quote_smart($Postleitzahl),
					quote_smart($Stadt),
					quote_smart($Land),
					quote_smart($Telephon),
					quote_smart($Telefax),
					quote_smart($Mobil),
					quote_smart($EMail),
					quote_smart($Mitglied_ID)
				);

		// If all address fields are empty, we delete the entire record
		// instead of updating with empty fields  - if not main address.
		} else {
		   	if ("$Adress_ID" != '1') {
				$Adress_upd_sql = sprintf("
					DELETE FROM `$Adress_table`
					WHERE `Mitglied_ID`=%s
					LIMIT 1",
					quote_smart($Mitglied_ID));
			}
		}
		break;

	// Address NOT existent yet, 'insert' required
	case '0':
        	$Adress_upd_sql		= sprintf("
				INSERT INTO `$Adress_table` (
					`Mitglied_ID`,
                                        `Adressfeld1`,
                                        `Adressfeld2`,
                                        `Kanton`,
                                        `Postleitzahl`,
                                        `Stadt`,
                                        `Land`,
                                        `Telephon`,
                                        `Telefax`,
                                        `Mobil`,
                                        `EMail`)
				VALUES ( %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
                                        quote_smart($Mitglied_ID),
                                        quote_smart($Adressfeld1),
                                        quote_smart($Adressfeld2),
                                        quote_smart($Kanton),
                                        quote_smart($Postleitzahl),
                                        quote_smart($Stadt),
                                        quote_smart($Land),
                                        quote_smart($Telephon),
                                        quote_smart($Telefax),
                                        quote_smart($Mobil),
                                        quote_smart($EMail)
                               	);
				break;
	}

	//print_r($Mitglied_upd_sql)";
	//print_r($Adress_upd_sql);
	
	mysql_query($Mitglied_upd_sql,$db)
		or die('Could not update database, member table: ' . mysql_error());
	mysql_query($Adress_upd_sql,$db) 
		or die('Could not update database, adress table: ' . mysql_error());
	mysql_close();

	// Redirect to some page and exit
	header("Location: http://" . $_SERVER['HTTP_HOST'] . "/phpMyMembers/detail.php?Mitglied_ID=" .
				     $Mitglied_ID . "&address=" . $Adress_ID . "&status=ok");
	exit;
	break;

case "insert":

	$Mitglied_insert_sql 	= sprintf("INSERT INTO `Mitglied` (
							`Mitglied_ID`,
							`Mitgliednummer`,
							`Nachname`,
							`Vorname`,
							`Geburtsdatum`,
							`Geschlecht_ID`,
							`Zivilstand_ID`,
							`Eintritt`,
							`Austritt`,
							`Mitgliedschaft_ID`,
							`Update`,
							`Update_ID`,
							`Beruf`,
							`Titel`,
							`GL`)
			 		VALUES ( '', %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
					quote_smart($Mitgliednummer),
					quote_smart($Nachname),
					quote_smart($Vorname),
					quote_smart($Geburtsdatum),
					quote_smart($Geschlecht_ID),
					quote_smart($Zivilstand_ID),
					quote_smart($Eintritt),
					quote_smart($Austritt),
					quote_smart($Mitgliedschaft_ID),
					quote_smart($date),
					quote_smart(getUserId()),
					quote_smart($Beruf),
					quote_smart($Titel),
					quote_smart($GL)
					);

	mysql_query($Mitglied_insert_sql,$db)
		or die('Could not insert database, member table: ' . mysql_error());

	// mysql_insert_id() gives us the previously assigned auto-increment
	// value which we need for the insert of the address.

	$Mitglied_ID		= mysql_insert_id();;

	$Adress_table          	= "Adresse" . "$Adress_ID";
	$Adress_insert_sql	= sprintf("INSERT INTO `$Adress_table` (
							`Mitglied_ID`,
							`Adressfeld1`,
							`Adressfeld2`,
							`Kanton`,
							`Postleitzahl`,
							`Stadt`,
							`Land`,
							`Telephon`,
							`Telefax`,
							`Mobil`,
							`EMail`)
					VALUES ( %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
					quote_smart($Mitglied_ID),
					quote_smart($Adressfeld1),
					quote_smart($Adressfeld2),
					quote_smart($Kanton),
					quote_smart($Postleitzahl),
					quote_smart($Stadt),
					quote_smart($Land),
					quote_smart($Telephon),
					quote_smart($Telefax),
					quote_smart($Mobil),
					quote_smart($EMail)
					);

///////////////////////////////////////////////////////////////////////////////////////////////////	
	// We also need to 'insert' into the unused Adresstables,
	// otherwise the update will fail later
///////////////////////////////////////////////////////////////////////////////////////////////////	

	mysql_query($Adress_insert_sql,$db)
		or die('Could not insert database, address table: ' . mysql_error());
        mysql_close();

	// Redirect to some page and exit
	header("Location: http://" . $_SERVER['HTTP_HOST'] . "/phpMyMembers/detail.php?Mitglied_ID=" .
				     $Mitglied_ID . "&address=" . $Adress_ID . "&status=ok");
	exit;
        break;
}

?>
   <TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='5'>
    <TR><TH class='titel_hinweis'><? echo LANG_CHECK_CHANGES ?></TH></TR>
    <TR>
     <TD VALIGN='top'>

        <!-- Output of the member data table -->
        <TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='3' CELLSPACING='5'>
          <TR><TD colspan='2'>
                <TABLE WIDTH='100%' HEIGHT='50' BORDER='0'>
<?
		// let's see how we are called and generate the self-referencing form accordingly.
		switch($action) {	
		case "edit":
			echo "\t\t<FORM method='POST' action='$me?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=update'>\n";
			break;
		case "new":
		   	echo "\t\t<FORM method='POST' action='$me?action=insert'>\n";
			break;
		}
                echo "\t\t<TR VALIGN='bottom'><TD>$Nachname $Vorname</TD></TR>\n";
?>
                   <TR VALIGN='top'><TD><HR></TD></TR>
                </TABLE>
          </TD></TR>
<?

// Lets see how ID's refer to human readable descriptions (db -> variable -> constant)
$Mitgliedschaft = constant(get_field_descr_by_id("$Mitgliedschaft_ID", 'Mitgliedschaft'));
$Zivilstand     = constant(get_field_descr_by_id("$Zivilstand_ID", 'Zivilstand'));
$Geschlecht     = constant(get_field_descr_by_id("$Geschlecht_ID", 'Geschlecht'));
?>

	<TR>
	    <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_NUMBER ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Mitgliednummer" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_MEMBER_TITLE ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Titel" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_DATE_OF_BIRTH ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Geburtsdatum" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_OCCUPATION ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Beruf" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_START ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Eintritt" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_END ?>:</TD>
            <TD class='detail_chck_conts'><? echo (make_mysql_date("$Austritt") != '0000-00-00') ? "$Austritt" : '' ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Mitgliedschaft" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_CIVIL_STATUS ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Zivilstand" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_SEX ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Geschlecht" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_SPECIFIC_YESNO ?>:</TD>
            <TD class='detail_chck_conts'><? echo ( $GL == 1 ) ? LANG_YES : LANG_NO ?></TD>
	</TR>
        </TABLE>

        <TABLE WIDTH='99%' BORDER='0'>
	   <TR>
             <TD COLSPAN='2'><HR></TD>
	   </TR>
	</TABLE>

     </TD>


     <!-- Output of the address table -->
     <TD VALIGN='top'>

      <TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='3' CELLSPACING='5'>
        <TR><TD colspan='2'>

               <TABLE WIDTH='100%' HEIGHT='50' BORDER='0'>
		<?
                // Do not show header hyperlink if already selected.
		?>
                 <TR ALIGN='left' VALIGN='bottom'>
                   <TD BGCOLOR='gainsboro'><? echo "$Adress_ID" . '. Adresse'; ?></TD>
                 </TR>
                 <TR VALIGN='top'><TD><HR></TD></TR>
               </TABLE>

        </TD></TR>

        <TR>
	    <TD class='detail_view_entry'><? echo LANG_ADRESS ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Adressfeld1" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_ADRESSFIELD ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Adressfeld2" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_STATE ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Kanton" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_POSTAL_CODE ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Postleitzahl" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_CITY ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Stadt" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_COUNTRY ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Land" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_PHONE ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Telephon" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_FAX ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Telefax" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_CELLPHONE ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$Mobil" ?></TD>
	</TR>
        <TR>
	    <TD class='detail_view_entry'><? echo LANG_EMAIL ?>:</TD>
            <TD class='detail_chck_conts'><? echo "$EMail" ?></TD>
	</TR>
      </TABLE>

      <TABLE WIDTH='99%' BORDER='0'>
         <TR><TD COLSPAN='2'><HR></TD></TR>
         <TR><TD COLSPAN='2' align='right'>
<?

	// let's store the data again, so we have it later for updating the db
	// and we have to transform the dates back to mysql format.
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Mitglied_ID' VALUE='" . $Mitglied_ID . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Nachname' VALUE='" . $Nachname . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Vorname' VALUE='" . $Vorname . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Mitgliednummer' VALUE='" . $Mitgliednummer . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Titel' VALUE='" . $Titel . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Geburtsdatum' VALUE='" . make_mysql_date("$Geburtsdatum") . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Beruf' VALUE='" . $Beruf . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Eintritt' VALUE='" . make_mysql_date("$Eintritt") . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Austritt' VALUE='" . make_mysql_date("$Austritt") . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Mitgliedschaft_ID' VALUE='" . $Mitgliedschaft_ID . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Zivilstand_ID' VALUE='" . $Zivilstand_ID . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Geschlecht_ID' VALUE='" . $Geschlecht_ID . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='GL' VALUE='" . $GL . "'></INPUT>\n";

	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Adress_ID' VALUE='" . $Adress_ID . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Adressfeld1' VALUE='" . $Adressfeld1 . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Adressfeld2' VALUE='" . $Adressfeld2 . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Kanton' VALUE='" . $Kanton . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Postleitzahl' VALUE='" . $Postleitzahl . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Stadt' VALUE='" . $Stadt . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Land' VALUE='" . $Land . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Telephon' VALUE='" . $Telephon . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Telefax' VALUE='" . $Telefax . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='Mobil' VALUE='" . $Mobil . "'></INPUT>\n";
	echo "\t\t\t\t<INPUT TYPE='hidden' NAME='EMail' VALUE='" . $EMail . "'></INPUT>\n";
?>
               <INPUT TYPE='button' value='<? echo LANG_BACK ?>' onclick=history.go(-1)>
            <? if (isEnabled($userlist,$grouplist)) {?>
               <INPUT TYPE='submit' value='<? echo LANG_SAVE . ' & ' . LANG_VIEW_DETAILS ?>'>
            <? } ?>
            </TD>
          </TR>
          </FORM>
        </TABLE>

     </TD>
   </TR>
  </TABLE>

  </TD>
 </TR>
</TABLE>

<?
include("include/footer.inc");
?>
