<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

require("include/header.inc");
require("include/dbconnect.php");

// Only people of the phpAuthent group 'edit' may submit the form
require_once(PHPMYMEMBERS_DIR . "/include/phpauthent/phpauthent_core.php");
$userlist = array("");
$grouplist = array("edit");


// We show a Javascript box when insert/update was
// successfully done on db within 'submit.php'.
if ( CONFIRM_DB_WRITES_WITH_POPUP == 'true' ) {
	if ($_REQUEST['status'] == 'ok') {
		echo "<script>alert(\"" . LANG_DATABASE_SUCCESS . "\")</script>";
	}
}

?>

<TABLE class='main'>
 <TR>
   <TD>

<?

// Find out which address we should display
$Adress_ID     	= (isset($_REQUEST['address']))  ?  $_REQUEST['address']  :  "1";
$address_table 	= "Adresse" . "$Adress_ID";
$action	       	= $_REQUEST['action'];
$date		= date("Y-m-d");

// Only query database if Mitglied_ID is selected, otherwise we are in 'new'
// mode and thus can't query anything yet which would produce mysql errors
if ( !empty($_REQUEST['Mitglied_ID']) ) {

	// Make life easier
	$Mitglied_ID = $_REQUEST['Mitglied_ID'];

	// Query main db table and set php variables; we do list all fields deliberatly
    // (instead of *) because we do NOT want to query the photo with lot's of kilobytes here
	$main_query     = sprintf("
			SELECT  m.membership_number,
                    m.lastname,
                    m.firstname, 
                    m.date_of_birth, 
                    m.membership_start, 
                    m.membership_end, 
                    m.comment, 
                    m.Mitgliedschaft_ID, 
                    s.Mitgliedschaft, 
                    m.Zivilstand_ID, 
                    z.Zivilstand, 
                    m.Geschlecht_ID, 
                    g.Geschlecht, 
                    m.last_update, 
                    m.occupation, 
                    m.title, 
                    m.specific_yesno 
            FROM `Mitglied` m, `Geschlecht` g, `Zivilstand` z, `Mitgliedschaft` s
			WHERE m.Mitglied_ID=%s
			and   m.Geschlecht_ID=g.Geschlecht_ID
			and   m.Mitgliedschaft_ID=s.Mitgliedschaft_ID
			and   m.Zivilstand_ID=z.Zivilstand_ID",
			quote_smart($Mitglied_ID));

		$result = mysql_query($main_query,$db);
		$row    = mysql_fetch_array($result);

		$membership_number     = $row['membership_number'];
		$lastname 	        = $row['lastname'];
		$firstname 	        = $row['firstname'];
		$date_of_birth 	    = $row['date_of_birth'];
		$membership_start 	        = $row['membership_start'];
		$membership_end 	        = $row['membership_end'];
		$comment 	        = $row['comment'];
		$Mitgliedschaft_ID  = $row['Mitgliedschaft_ID'];
		$Mitgliedschaft     = $row['Mitgliedschaft'];
		$Zivilstand_ID	    = $row['Zivilstand_ID'];
		$Zivilstand	        = $row['Zivilstand'];
		$Geschlecht_ID	    = $row['Geschlecht_ID'];
		$Geschlecht	        = $row['Geschlecht'];
		$last_update 	    = $row['last_update'];
		$occupation 		        = $row['occupation'];
		$title 		        = $row['title'];
		$specific_yesno 		        = $row['specific_yesno'];

	// Query address db tables and set php variables
	// Not fetching anything again should be quicker
	$address_query	= sprintf("
			SELECT  m.Mitglied_ID,
                    a.addressfield1, 
                    a.addressfield2, 
                    a.state, 
                    a.postcode,
			        a.city, 
                    a.country, 
                    a.phone, 
                    a.fax, 
                    a.cellphone, 
                    a.email, 
                    a.Mitglied_ID
		    FROM `Mitglied` m, `$address_table` a
			WHERE m.Mitglied_ID=%s
			and   m.Mitglied_ID=a.Mitglied_ID",
			quote_smart($Mitglied_ID));

		$result = mysql_query($address_query,$db);
		$row    = mysql_fetch_array($result);

		$addressfield1    = $row['addressfield1'];
		$addressfield2    = $row['addressfield2'];
		$state    	    = $row['state'];
		$postcode   = $row['postcode'];
		$city   	    = $row['city'];
		$country		    = $row['country'];
		$phone    	= $row['phone'];
		$fax	    = $row['fax'];
		$cellphone		    = $row['cellphone'];
		$email		    = $row['email'];
} ?>

<NOSCRIPT><? echo LANG_NOJS ?></NOSCRIPT>
<SCRIPT TYPE="text/javascript">

<?
if ("$action" == 'new' or "$action" == 'edit') { ?>
    // Only script specific to this form goes here.
    // General-purpose routines are in a separate file.
      function validateOnSubmit() {
        var elem;
        var errs=0;
        var dderrs=0;

        // execute all element validations in reverse order,
        // so focus gets set to the first one in error.

        <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_START == 'true') { ?>
                if (!validatePresent(document.forms.membercard.membership_start, 'inf_membership_start')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_OCCUPATION == 'true') { ?>
                if (!validatePresent(document.forms.membercard.occupation, 'inf_occupation')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_DATE_OF_BIRTH == 'true') { ?>
                if (!validatePresent(document.forms.membercard.date_of_birth, 'inf_date_of_birth')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_NUMBER == 'true') { ?>
                if (!validatePresent(document.forms.membercard.membership_number, 'inf_membership_number')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_FIRSTNAME == 'true') { ?>
                if (!validatePresent(document.forms.membercard.firstname, 'inf_firstname')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_LASTNAME == 'true') { ?>
                if (!validatePresent(document.forms.membercard.lastname, 'inf_lastname')) errs += 1;
        <? } ?>

        <? // Only validate fields of first and main address ?>
        <? if ($Adress_ID == '1') { ?>
            <? if (MEMBER_FORM_MANDATORY_COUNTRY == 'true') { ?>
                if (!validatePresent(document.forms.membercard.country, 'inf_country')) errs += 1;
            <? } ?>
            <? if (MEMBER_FORM_MANDATORY_CITY == 'true') { ?>
                if (!validatePresent(document.forms.membercard.city, 'inf_city')) errs += 1;
            <? } ?>
            <? if (MEMBER_FORM_MANDATORY_POSTAL_CODE == 'true') { ?>
                if (!validatePresent(document.forms.membercard.postcode, 'inf_postcode')) errs += 1;
            <? } ?>
            <? if (MEMBER_FORM_MANDATORY_ADDRESS1 == 'true') { ?>
                if (!validatePresent(document.forms.membercard.addressfield1, 'inf_addressfield1')) errs += 1;
            <? } ?>
            <? if (MEMBER_FORM_MANDATORY_ADDRESS2 == 'true') { ?>
                if (!validatePresent(document.forms.membercard.addressfield2, 'inf_addressfield2')) errs += 1;
            <? } ?>
        <? } ?>

        <? // validate drop downs too - FIXIT: don't know to generate the red stars here...
           // That's why we workaround by displaying a separate alert message ?>

        <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP == 'true') { ?>
                if ( document.forms.membercard.Mitgliedschaft.selectedIndex == 0 ) dderrs +=1;
        <? } ?>

        <? if (MEMBER_FORM_MANDATORY_CIVILSTATE == 'true') { ?>
                if ( document.forms.membercard.Zivilstand.selectedIndex == 0 ) dderrs +=1;
        <? } ?>

        <? if (MEMBER_FORM_MANDATORY_SEX == 'true') { ?>
                if ( document.forms.membercard.Geschlecht.selectedIndex == 0 ) dderrs +=1;
        <? } ?>

        if (errs>1) alert('<? echo LANG_MULTI_INPUT_ERR ?>');
        if (errs==1) alert('<? echo LANG_SINspecific_yesnoE_INPUT_ERR ?>');

        if (dderrs>1) { alert('<? echo LANG_MULTI_DROPDOWN_ERR ?>'); errs=1; }
        if (dderrs==1) { alert('<? echo LANG_SINspecific_yesnoE_DROPDOWN_ERR ?>'); errs=1; }

        return (errs==0);
      };

<? } else { ?>

    <!--
    // www.web-toolbox.net , W. Jansen
    // Als Übergabeparameter wird die bildquelle,breite und höhe übergeben
    // hand over parameters for source,width and height

    function FotoWindow(bildurl,b,h)
    {
    var eigenschaften,sbreite,shoehe,fenster,b,h;

    // stellt die Bildschirmabmessungen fest
    // find window size
    var ns6 = (!document.all && document.getElementById);
    var ie4 = (document.all);
    var ns4 = (document.layers);

    if(ns6||ns4) {
    sbreite = innerWidth;
    shoehe = innerHeight;
    }
    else if(ie4) {
    sbreite = document.body.clientWidth;
    shoehe = document.body.clientHeight;
    }

    x = (sbreite-b)/2;
    y = (shoehe-h)/2;

    eigenschaften="left="+x+",top="+y+",screenX="+x+",screenY="+y+",width="+b+",height="+h+",menubar=no,toolbar=no,statusbar=0";

    fenster=window.open("","",eigenschaften);
    fenster.focus();
    fenster.document.open();
    with (fenster) {
      document.write("<html><head>");
      // geändert 2004 für Mozilla
      document.write('<scr' + 'ipt type="text/javascr' + 'ipt" language="JavaScr' + 'ipt">');
      // bei click  schliessen , on click close
      document.write("function click() { window.close(); } ");
      document.write("document.onmousedown=click ");
      // geändert 2004 für Mozilla
      document.write('</scr' + 'ipt>');
      document.write("<title>klick to close</title></head>");
      // bei Focusverlust schliessen, close if window looses focus
      // Zeile geändert Aug 2003 (Dreamweaver machte Probleme)
      document.write("<" + "body onblur='window.close()';");
      document.write("marginwidth='0' marginheight='0' leftmargin='0' topmargin='0'>");
      document.write("<center>");
      document.write("<img src='"+ bildurl +"' border='0'>");
      document.write("<center>");
      document.write("</body></html>");
      fenster.document.close();
    }
    }
    //-->

<? } ?>
</SCRIPT>


<TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='5' CELLSPACING='10' width="800">
    <TR>
        <TH>
          <TABLE BORDER='0' WIDTH='100%' CELLPADDING='0' CELLSPACING='0'>
           <TR>
            <TD class='titel_hinweis'>
            <?
            switch($action) {
            case "edit":
                    echo LANG_EDIT_EXISTING_RECORD;
                    break;
            case "new":
                    echo LANG_CREATE_NEW_RECORD;
                    break;
            default:
                    echo LANG_VIEW_DETAILS;
                    break;
            }
            ?>
            </TD>
            <TD align='right'>
            <? // Only make an IMG link if not in edit or new mode
            if ("$action" != 'new' and "$action" != 'edit') { ?>
                <A HREF="javascript:FotoWindow('include/showimage.php?Mitglied_ID=<? echo "$Mitglied_ID" ?>','550','450')">
                    <img class='showimage' title='<? echo LANG_FULLSIZE ?>' src=include/showimage.php?Mitglied_ID=<? echo "$Mitglied_ID" ?>>
                </A>
            <? } elseif ("$action" == 'edit') { ?>
                    <img class='showimage' src=include/showimage.php?Mitglied_ID=<? echo "$Mitglied_ID" ?>>
            <? } ?>
            </TD>
           </TR>
          </TABLE>
        </TH>

        <? if ("$action" != 'new' and "$action" != 'edit') { 
        ?><TD align='right' valign='top'><?
                    $prev = getNeighbourMemberID($lastname,$firstname,$membership_start,$Mitglied_ID,prev);
                    $next = getNeighbourMemberID($lastname,$firstname,$membership_start,$Mitglied_ID,next);
                if (!empty($prev)) { ?>
                    <A HREF='<? echo "$_SERVER[PHP_SELF]?Mitglied_ID=$prev&address=$Adress_ID" ?>'>
                        <IMG TITLE='<? echo LANG_BACK ?>' BORDER='0' SRC='img/leftarrow.png'>
                    </A>
                <? }
                if (!empty($next)) { ?>
                    <A HREF='<? echo "$_SERVER[PHP_SELF]?Mitglied_ID=$next&address=$Adress_ID" ?>'>
                        <IMG TITLE='<? echo LANG_NEXT ?>' BORDER='0' SRC='img/rightarrow.png'>
                    </A>
                <? }
            } else {

        ?><TD align='left' valign='top'>
                    <FORM enctype=multipart/form-data NAME='membercard' method='POST' onsubmit="return validateOnSubmit()" action='submit.php'>
                    <input type=hidden name=MAX_FILE_SIZE value=<? echo MAX_UPLOAD_SIZE ?>>
                    <input type=hidden name=completed value=1>&nbsp;
                    <input type=file name=imagefile>
            <? } ?>
        </TD>
    </TR>
    <TR>
        <TD VALIGN='top'>
        <? // Output of the member data table (left side) ?>
        <TABLE BORDER='0' bgcolor='#EEEEEE' CELLPADDING='3' CELLSPACING='5' HEIGHT='400'>
        <TR>
            <TD colspan='3'>
        	<TABLE WIDTH='100%' BORDER='0'>
	            <TR VALIGN='bottom'>
                    <TD>
<?
			switch($action) {
			case "new":
 			case "edit":
                    ?>
                     <TABLE border='0'>
                      <TR><TD>&nbsp;</TD><TD><? echo LANG_LASTNAME ?></TD><TD>&nbsp;</TD><TD><? echo LANG_FIRSTNAME ?></TD></TR>
                      <TR>
                        <TD ID="inf_lastname">&nbsp;</TD>
                       <TD>
                        <INPUT
                            TYPE='text'
                            NAME='lastname'
                            ID='lastname'
                            <? if (MEMBER_FORM_MANDATORY_LASTNAME == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_lastname');"
                            <? } ?>
                            maxlength='49'
                            VALUE='<? if (!empty($lastname)) echo $lastname ?>'>
                        </INPUT>
                       </TD>
                        <TD ID="inf_firstname">&nbsp;</TD>
                       <TD>
                        <INPUT
                            TYPE='text'
                            NAME='firstname'
                            ID='firstname'
                            <? if (MEMBER_FORM_MANDATORY_FIRSTNAME == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_firstname');"
                            <? } ?>
                            maxlength='49'
                            VALUE='<? if (!empty($firstname)) echo $firstname ?>'>
                        </INPUT>
                       </TD>
                      </TR>
                     </TABLE>
                    <?
			        break;
			default:
			        echo "$lastname $firstname";
                    break;
			}
            ?>
		    </TD>
        </TR>
	    <TR VALIGN='top'><TD><HR></TD></TR>
    </TABLE>
    </TD></TR>

        <? // Let's output the membership number field ?>
        <TR>    
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_NUMBER ?>:</TD>
            <TD ID="inf_membership_number">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='membership_number'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='membership_number'
                                ID='membership_number'
                                <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_NUMBER == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_membership_number');"
                                <? } ?>
                                MAXLENGTH='6'
                                VALUE='<? if (isset($membership_number)) echo $membership_number ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$membership_number";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the title field
        if (constant('MEMBER_FORM_SHOW_TITLE') == 'true') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBER_TITLE ?>:</TD>
            <TD ID="inf_title">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='title'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='title'
                                ID='title'
                                <? if (MEMBER_FORM_MANDATORY_TITLE == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_title');"
                                <? } ?>
                                MAXLENGTH='6'
                                VALUE='<? if (!empty($title)) echo $title ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$title";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the birth date field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_DATE_OF_BIRTH ?>:</TD>
            <TD ID="inf_date_of_birth">&nbsp;</TD>
		    <TD class='detail_view_conts'><?
			    switch($action) {
                case 'edit':
                    require_once("include/datepicker.php"); ?>
                    <INPUT
                        NAME='date_of_birth'
                        id='DPC_date_of_birth'
                        <? if (MEMBER_FORM_MANDATORY_DATE_OF_BIRTH == 'true') { ?>
                        ONCHANGE="validatePresent(this, 'inf_date_of_birth');"
                        <? } ?>
                        VALUE='<? echo ( $date_of_birth != '0000-00-00' ) ? make_nice_date("$date_of_birth") : '' ?>'>
                    </INPUT><?
                    break;
                case 'new':
                    require_once("include/datepicker.php"); ?>
                    <INPUT
                        NAME='date_of_birth'
                        id='DPC_date_of_birth'
                        <? if (MEMBER_FORM_MANDATORY_DATE_OF_BIRTH == 'true') { ?>
                        ONCHANGE="validatePresent(this, 'inf_date_of_birth');"
                        <? } ?>
                        VALUE=''>
                    </INPUT><?
                    break;
                default:
                    echo ( $date_of_birth != '0000-00-00' ) ? make_nice_date("$date_of_birth") : LANG_UNKNOWN;
                } ?>
            </TD>
        </TR>

        <? // Let's output the title field
        if (constant('MEMBER_FORM_SHOW_OCCUPATION') == 'true') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_OCCUPATION ?>:</TD>
            <TD ID="inf_occupation">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='occupation'><?
                    switch($action) {
                    case "new":
                    case "edit": ?>
                        <INPUT
                            NAME='occupation'
                            ID='occupation'
                            <? if (MEMBER_FORM_MANDATORY_OCCUPATION == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_occupation');"
                            <? } ?>
                            MAXLENGTH='49'
                            VALUE='<? if (!empty($occupation)) echo $occupation ?>'>
                        </INPUT><?
                        break;
                    default:
                        echo "$occupation";
                        break;
                    } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the membership start field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_START ?>:</TD>
            <TD ID="inf_membership_start">&nbsp;</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='membership_start'
                            id='DPC_membership_start'
                            <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_START == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_membership_start');"
                            <? } ?>
                            VALUE='<? echo make_nice_date("$membership_start") ?>'>
                        </INPUT><?
				        break;
                    case 'new':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='membership_start'
                            id='DPC_membership_start'
                            <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_START == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_membership_start');"
                            <? } ?>
                            VALUE='<? echo make_nice_date("$date") ?>'>
                        </INPUT><?
				        break;
                    default:
                        echo make_nice_date("$membership_start");
                        break;
                    } ?>
            </TD>
        </TR>

        <? // Let's output the membership end field
        if ("$action" != 'new') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_END ?>:</TD>
            <TD></TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='membership_end'
                            id='DPC_membership_end'
                            VALUE='<? echo ( $membership_end != '0000-00-00' ) ? make_nice_date("$membership_end") : '' ?>'>
                        </INPUT> <?
                        break;
                    default:
                        echo ( $membership_end != '0000-00-00' ) ? make_nice_date("$membership_end") : '';
                        break;
                    } ?>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the membership type field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP ?>:</TD>
            <TD ID="inf_Mitgliedschaft_ID">&nbsp;</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        $result = get_dropdown('Mitgliedschaft'); ?>
                        <SELECT NAME='Mitgliedschaft_ID' ID='Mitgliedschaft'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) { ?>
                                    <OPTION<?
                                        if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]");
                                    ?></OPTION><?
                                }
                        break;
                    case 'new':
                        $result = get_dropdown('Mitgliedschaft'); ?>
                        <SELECT NAME='Mitgliedschaft_ID' ID='Mitgliedschaft'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                		        while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    // Don't show alumni group on 'new'
                                    if ( $row['Mitgliedschaft'] == 'MEMBERSHIP_ALUMNI' ) { continue; }
                                    ?><OPTION<?
                                        if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Mitgliedschaft");
                        break;
			        } ?>
                </SELECT>
            </TD>
        </TR>

        <? // Let's output the civil status field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_CIVIL_STATUS ?>:</TD>
            <TD ID="inf_Zivilstand_ID">&nbsp;</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case "edit":
                    case "new":
                        $result = get_dropdown('Zivilstand'); ?>
                        <SELECT NAME='Zivilstand_ID' ID='Zivilstand'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    ?><OPTION<?
                                        if ( $row['Zivilstand_ID'] == "$Zivilstand_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Zivilstand_ID]'>" . constant("$row[Zivilstand]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Zivilstand");
                        break;
                    } ?>
                    </SELECT>
            </TD>
        </TR>

        <? // Let's have sex ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_SEX ?>:</TD>
            <TD></TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
			        case "edit":
			        case "new":
                        $result = get_dropdown('Geschlecht'); ?>
                        <SELECT NAME='Geschlecht_ID' ID='Geschlecht'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    ?><OPTION<?
                                        if ( $row['Geschlecht_ID'] == "$Geschlecht_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Geschlecht_ID]'>" . constant("$row[Geschlecht]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Geschlecht");
                        break;
                    } ?>
                    </SELECT>
            </TD>
        </TR>

        <? // Let's output the specific yes/no question ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_SPECIFIC_YESNO ?>:</TD>
            <TD></TD>
            <TD class='detail_view_conts'><?
                switch($action) {
                case 'edit': ?>
			    	<SELECT NAME='specific_yesno'><?
			    	    foreach (range('0','1') as $line) {
                            ?><OPTION<?
				                if ( "$line" == "$specific_yesno" ) { echo ' SELECTED '; }
				                echo " VALUE='$line'>";
				                echo ("$line" == 1) ? strtolower(LANG_YES) : strtolower(LANG_NO);
				            ?></OPTION><?
			     	    } ?>
                    </SELECT><?
                    break;
                case "new": ?>
                    <SELECT NAME='specific_yesno'><?
                        foreach (range('0','1') as $line) {
                            ?><OPTION<?
                                if ( "$line" == 1 ) { echo ' SELECTED '; }
                                echo " VALUE='$line'>";
                                echo ("$line" == 1) ? strtolower(LANG_YES) : strtolower(LANG_NO);
                            ?></OPTION><?
                        } ?>
                    </SELECT><?
                    break;
                default:
                    echo ("$specific_yesno" == 1) ? strtolower(LANG_YES) : strtolower(LANG_NO);
                    break;
                } ?>
            </TD>
        </TR>

    <? // Let's output the last_update field ?><?
    switch($action) {
    case "edit":
    case "new":
        break;
    default: ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_LAST_UPDATE ?>:</TD>
            <TD></TD>
            <TD class='detail_view_conts'><? echo make_nice_date("$last_update") .' / '. getUpdatedBy("$Mitglied_ID"); ?></TD>
        </TR><?
	  } ?>


	</TABLE>
    </TD>

    <? // Output of the address table ?>
    <TD VALIGN='top'>
    <TABLE BORDER='0' bgcolor='#EEEEEE' CELLPADDING='3' CELLSPACING='5' HEIGHT='400'>
        <TR><TD colspan='3'>
            <TABLE WIDTH='100%' HEIGHT='50' BORDER='0'>
	            <TR ALIGN='right' VALIGN='bottom'>
                <?		
                // Do not show header hyperlink if already selected.
                // uses a function to count number of address tables
                // People may just add another table 'Adresse..' to use it
                // If in 'edit' or 'new' mode the links disappear for usability
                // and protection
                $number_address_tables = get_table_number('Adresse');
                foreach (range('1', "$number_address_tables") as $num) {
                    if ($Adress_ID != $num ) {
                         echo "<TD BGCOLOR='lightgrey'>";
                         switch($action) {
                         case "edit":
                         case "new":
                           echo "$num. " . LANG_ADRESS;
                           break;
                         default:
                           echo "<A HREF='$_SERVER[PHP_SELF]?Mitglied_ID=$Mitglied_ID&address=$num'>$num. " . LANG_ADRESS . "</A>";
                         }
                         echo "</TD>\n";	
                    } else {
                         echo "<TD BGCOLOR='#EEEEEE'><FONT COLOR='green'>$num. " . LANG_ADRESS . "</FONT></TD>\n";	
                    }
                }
                ?>
	            </TR>
		        <TR VALIGN='top'>
                    <TD COLSPAN='<? echo $number_address_tables ?>'><HR></TD>
                </TR>
            </TABLE>
	    </TD></TR>

        <? // Let's output the address field number one ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_ADRESSFIELD ?> 1:</TD>
            <TD ID="inf_addressfield1">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='addressfield1'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='addressfield1'
                                ID='addressfield1'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_ADDRESS1 == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_addressfield1');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($addressfield1)) echo $addressfield1 ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$addressfield1";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the address field number two ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_ADRESSFIELD ?> 2:</TD>
            <TD ID="inf_addressfield2">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='addressfield2'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='addressfield2'
                                ID='addressfield2'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_ADDRESS2 == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_addressfield2');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($addressfield2)) echo $addressfield2 ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$addressfield2";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the state field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_STATE ?>:</TD>
            <TD ID="inf_state">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='state'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='state'
                                ID='state'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_STATE == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_state');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($state)) echo $state ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$state";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the postal code field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_POSTAL_CODE ?>:</TD>
            <TD ID="inf_postcode">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='postcode'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='postcode'
                                ID='postcode'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_POSTAL_CODE == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_postcode');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($postcode)) echo $postcode ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$postcode";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the city field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_CITY ?>:</TD>
            <TD ID="inf_city">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='city'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='city'
                                ID='city'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_CITY == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_city');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($city)) echo $city ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$city";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the country field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_COUNTRY ?>:</TD>
            <TD ID="inf_country">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='country'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='country'
                                ID='country'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_COUNTRY == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_country');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($country)) echo $country ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$country";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the phone number field
        if (constant('MEMBER_FORM_SHOW_PHONE') == 'true') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_PHONE ?>:</TD>
            <TD ID="inf_phone">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='phone'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='phone'
                                ID='phone'
                                ONCHANGE="validateTelnr(this, 'inf_phone', false);"
                                MAXLENGTH='50'
                                VALUE='<? if (!empty($phone)) echo $phone ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$phone";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the fax number field
        if (constant('MEMBER_FORM_SHOW_FAX') == 'true') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_FAX ?>:</TD>
            <TD ID="inf_fax">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='fax'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='fax'
                                ID='fax'
                                ONCHANGE="validateTelnr(this, 'inf_fax', false);"
                                MAXLENGTH='50'
                                VALUE='<? if (!empty($fax)) echo $fax ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$fax";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the mobile number field
        if (constant('MEMBER_FORM_SHOW_CELLPHONE') == 'true') { ?>
	    <TR>
            <TD class='detail_view_entry'><? echo LANG_CELLPHONE ?>:</TD>
            <TD ID="inf_cellphone">&nbsp;</TD>
		    <TD class='detail_view_conts'>
                <LABEL FOR='cellphone'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                        	<INPUT
                                NAME='cellphone'
                                ID='cellphone'
                                ONCHANGE="validateTelnr(this, 'inf_cellphone', false);"
                                MAXLENGTH='50'
                                VALUE='<? if (!empty($cellphone)) echo $cellphone ?>'>
                            </INPUT> <?
		    		        break;
			            default:
                            echo "$cellphone";
                            break;
			            } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the email field
        if (constant('MEMBER_FORM_SHOW_EMAIL') == 'true') { ?>
	    <TR>
            <TD CLASS='detail_view_entry'><? echo LANG_EMAIL ?>:</TD>
            <TD ID="inf_email">&nbsp;</TD>
		    <TD CLASS='detail_view_conts'>
                <LABEL FOR='email'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='email' 
                                ID='email'
                                ONCHANGE="validateEmail(this, 'inf_email', false);"
                                MAXLENGTH='50'
                                VALUE='<? if (!empty($email)) echo $email ?>'>
                            </INPUT> <?
				            break;
                        default: ?>
                            <A CLASS='nolink' HREF='mailto:<? echo $email ?>'><? echo $email ?></A> <?
                            break;
			            } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>
      </TABLE>

            </TD>
        </TR>
    </TABLE>
    <?// end table of left address field output //?>


    <?// show table of the comment field //?>
    <TABLE BGCOLOR="gainsboro" CELLPADDING='5' CELLSPACING='5' WIDTH="800" BORDER="0">
      <TR><TD CLASS='detail_view_entry'><? echo LANG_COMMENT . ':' ?></TD></TR>
      <TR>
        <TD>
            <TABLE align="center" WIDTH="95%" BORDER='0' bgcolor='#EEEEEE' CELLPADDING='3' CELLSPACING='3'>
              <TR><TD CLASS='detail_view_conts'>
            <?  switch($action) {
                case "new":
                case "edit": ?>
                    <TEXTAREA name="comment" cols="100" rows="5"><? if (!empty($comment)) echo "$comment" ?></TEXTAREA> <?
                    break;
                default:
                    echo (!empty($comment)) ? nl2br(htmlspecialchars("$comment")) : constant('LANG_NONE');
                    break;
                } ?>
              </TD></TR>
            </TABLE>
        </TD>
      </TR>
    </TABLE>
    <?// end table of the comment field //?>


    <?// show tables of options / buttons //?>
    <TABLE WIDTH="800" BORDER="0" CELLPADDING="0" CELLSPACING="0">
        <TR><TD COLSPAN='3'><HR width="799"></TD></TR>
        <TR><TD COLSPAN='3' align='right'>
    <?    
    switch($action) {
    case "edit":
        if (isEnabled($userlist,$grouplist)) { ?>
            <INPUT TYPE='hidden' name='action' value='edit'>
            <INPUT TYPE='hidden' name='Mitglied_ID' value='<? echo $Mitglied_ID ?>'>
            <INPUT TYPE='hidden' name='Adress_ID' value='<? echo $Adress_ID ?>'>
            <INPUT TYPE='button' value='<? echo LANG_BACK ?>' onclick=history.go(-1)>
            <INPUT TYPE='submit' value='<? echo LANG_SAVE ?>'>
        <? } ?>
        </TD></TR></FORM><?
		break;

	case "new":
        if (isEnabled($userlist,$grouplist)) { ?>
		    <INPUT TYPE='hidden' name='action' value='new'>
		    <INPUT TYPE='hidden' name='Mitglied_ID' value='<? echo $Mitglied_ID ?>'>
		    <INPUT TYPE='hidden' name='Adress_ID' value='<? echo $Adress_ID ?>'>
		    <INPUT TYPE='button' value='<? echo LANG_BACK ?>' onclick=history.go(-1)>
		    <INPUT TYPE='submit' value='<? echo LANG_SAVE ?>'>
        <? } ?>
        </TD></TR></FORM><?
		break;

	default:	
	        echo "| <A class='normal' HREF='print.php?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=detail'>" . LANG_GENERATE_LABEL_PDF . "</A> ";
            if (isEnabled($userlist,$grouplist)) {
	            echo "| <A class='normal' HREF='$_SERVER[PHP_SELF]?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=edit'>" . LANG_UPDATE . "</A> ";
            } ?>
       |</TD></TR>
	<? } ?>
    </TABLE>
    <?// end tables of options / buttons //?>


  </TD>
 </TR>
</TABLE>

<?  include("include/footer.inc"); ?>
