<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

include('include/header.inc');
include('include/dbconnect.php');

// This page handles three output formats, AZ, search and dropdown list
$action = $_REQUEST['action'];
if (empty($action) ) { $action = 'dropdown'; }
?>

<TABLE class='main' border='0'>

<?
// az and dropdown sql queries start similary; we name it $base_query
// and concatenate the rest depending on the user selection later.
$alumni_id = get_field_id_by_descr('MEMBERSHIP_ALUMNI','Mitgliedschaft');
$base_query = "SELECT m.Mitglied_ID, m.lastname, m.firstname, m.membership_number, m.membership_start, m.membership_end, m.last_update, a.country
	       FROM Mitglied m, Adresse1 a
	       WHERE m.Mitglied_ID=a.Mitglied_ID";


// Find out which columns we have to show according to user's choice
while (list($key, $val) = each($_REQUEST)) {

    // If found at line start (^) and checked, remove 'col_' and write in new array
    if(ereg('^col_',"$key") && "$val" == 'on') {

        // we initialise a new assoc array, e.g.: lastname => 'on', firstname => 'on'
        $pos = strpos($key, '_');
        $my_new_key = substr($key, $pos+1);
        //echo "$my_new_key<BR>";
        $cols_to_show["$my_new_key"] = 'on';

    }
}



switch($action) {
case "search":
?>
  <TR><TH width='400'><? echo LANG_SEARCH ?></TH></TR>
  <TR>
<?
	if ( !empty($_REQUEST['term']) ) { 

		$term = $_REQUEST['term'];

        	$query  = "SELECT DISTINCT m.`Mitglied_ID`,
                                       m.`membership_number`,
                                       m.`lastname`,
                                       m.`firstname`,
                                       m.`membership_start`,
                                       m.`membership_end`,
                                       m.`last_update`,
                                       a.`country`
			   FROM `Mitglied` m, `Mitgliedschaft` z, `Adresse1` a
			   WHERE m.`Mitglied_ID`       = a.`Mitglied_ID`
			   AND   m.`Mitgliedschaft_ID` = z.`Mitgliedschaft_ID`
        	   	   AND (
				   m.`Mitglied_ID` LIKE '%$term%'
                 	   	OR m.`membership_number` LIKE '%$term%'
               	 	   	OR m.`lastname` LIKE '%$term%'
               		   	OR m.`firstname` LIKE '%$term%'
               		   	OR m.`comment` LIKE '%$term%'
               	   		OR m.`membership_end` LIKE '%" . make_mysql_date($term) . "%'
               	   		OR m.`membership_start` LIKE '%" . make_mysql_date($term) . "%'
         	       	   	OR m.`occupation` LIKE '%$term%'
				
				OR a.`addressfield1` LIKE '%$term%'
				OR a.`addressfield2` LIKE '%$term%'
				OR a.`state` LIKE '%$term%'
				OR a.`postcode` LIKE '%$term%'
				OR a.`city` LIKE '%$term%'
				OR a.`country` LIKE '%$term%'
				OR a.`phone` LIKE '%$term%'
				OR a.`fax` LIKE '%$term%'
				OR a.`cellphone` LIKE '%$term%'
				OR a.`email` LIKE '%$term%'
			)";

		if ( ($_REQUEST['include_alumni'] != 'on' ) ) {
			$query .= " AND z.`Mitgliedschaft` != 'MEMBERSHIP_ALUMNI'";
		}
	}
?>

        <form method="POST" action="<? $_SERVER['PHP_SELF'] ?>">
    	 <TD class='boxed'>
          <table border="0" cellspacing="2">
            <tr>
              <td><? echo LANG_SPECIFY_SEARCH_TERM . ':' ?></td>
            </tr>
	    <tr>
	    </tr>
            <tr>
              <td valign="top"><input type="text" name="term" value="<? $term ?>" size="20"></TD>
            </tr><tr>
              <td valign="top"><input type="checkbox" name="include_alumni"
		<? 
		echo ($_REQUEST['include_alumni'] == 'on') ? ' checked' : ' unchecked';
		echo '>' . LANG_INCLUDE_ALUMNI;
		?>
	     </td>
            </tr>
            <tr>
              <td align="right"><input type="submit" value="<? echo LANG_NEXT ?>"></td>
              <td></td>
            </tr>
          </table>

<?
	break;


case "dropdown":

	?>
	<TR><TH width="400"><? echo LANG_LIST ?></TH></TR>
	<TR>
   	<FORM method="POST" action="<? $_SERVER['PHP_SELF'] ?>">
    	 <TD class="boxed">
	<?

	$Mitgliedschaft_ID = $_REQUEST['Mitgliedschaft_ID'];
	if (empty($Mitgliedschaft_ID) ) { $Mitgliedschaft_ID = 'none'; }

	// Creating drop down list from database
	$result = get_dropdown('Mitgliedschaft'); ?>
	<SELECT NAME='Mitgliedschaft_ID'>
		<OPTION VALUE='none'><? echo LANG_PLEASE_CHOOSE ?></OPTION>
        <? while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) { ?>
		    <OPTION <?
                    if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo ' SELECTED'; }
		    echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]") . '</OPTION>\n';
		} ?>
	</SELECT>
        <INPUT TYPE="submit" value="<? echo LANG_NEXT ?>">
    <?
	switch($Mitgliedschaft_ID) {
	case 'none':
		break;
/*
	case "all":
		$query = $base_query . sprintf(" AND m.Mitgliedschaft_ID!=%s", quote_smart($alumni_id));
		break;
*/
	default:
		$query = "$base_query" . sprintf(" AND m.Mitgliedschaft_ID=%s", quote_smart($Mitgliedschaft_ID));
	}
	break;


case 'az':

    ?>
    <TR><TH width='400'><? echo LANG_AZ ?></TH></TR>
    <?
	$list = $_REQUEST['list'];

    	?><TD class="boxed" align="center"><?
        foreach (range('A', 'Z') as $letter) { ?>
                <A HREF='<? echo $_SERVER['PHP_SELF'] . '?action=az&list=' . "$letter" . "$default_columns" ?>'><? echo "$letter" ?></A>
        <? }
        ?><HR><?
	if (!empty($_REQUEST['list']) ) {
        	$query = $base_query . sprintf(" AND m.Mitgliedschaft_ID!=%s
						 AND LEFT(lastname,1)=%s",
						quote_smart($alumni_id),
						quote_smart($list));
	}
	break;
}

?>
   </TD>
   <TD class="boxed" align="center">

<? // Only show check boxes when we are able to submit POST data
if ($_REQUEST['action'] != 'az') { ?>

   <table border="0" cellspacing="2">
     <tr><td>
          <? echo LANG_PLEASE_CHOOSE_COLUMNS . ':' ?>
     </td></tr>
     <tr><td>
    <? /*

    // We have to find out how to parse 'columns' later on since $_POST['columns']
    // can only contain ONE value, but we need mulitple ...

        <select size="4" name="columns" multiple>
          <option selected value="lastname"><? echo LANG_LASTNAME ?></option>
          <option selected value="firstname"><? echo LANG_FIRSTNAME ?></option>
          <option value="country"><? echo LANG_COUNTRY ?></option>
          <option selected value="membership_number"><? echo LANG_MEMBERSHIP_NUMBER ?></option>
          <option value="membership_start"><? echo LANG_MEMBERSHIP_START ?></option>
          <option value="membership_end"><? echo LANG_MEMBERSHIP_END ?></option>
          <option value="occupation"><? echo LANG_OCCUPATION ?></option>
          <option value="update"><? echo LANG_LAST_UPDATE ?></option>
        </select>

    // Meanwhile, we have to use space wasting checkboxes instead

    // We start the names with 'col_' to make them very unique and we cannot confuse
    // them with other (possible) checkboxes within the current form

    */


    ?>
        <INPUT TYPE="CHECKBOX" name="col_lastname"
            <? if ($_REQUEST['col_lastname'] == 'on') echo ' checked' ?>
        >&nbsp;<? echo LANG_LASTNAME ?></INPUT><BR>

        <INPUT TYPE="CHECKBOX" name="col_firstname"
            <? if ($_REQUEST['col_firstname'] == 'on') echo ' checked' ?>
        >&nbsp;<? echo LANG_FIRSTNAME ?></INPUT><BR>

        <INPUT TYPE="CHECKBOX" name="col_country"
            <? if ($_REQUEST['col_country'] == 'on') echo ' checked' ?>
        >&nbsp;<? echo LANG_COUNTRY ?></INPUT><BR>

        <INPUT TYPE="CHECKBOX" name="col_membership_number"
            <? if ($_REQUEST['col_membership_number'] == 'on') echo ' checked' ?>
        >&nbsp;<? echo LANG_MEMBERSHIP_NUMBER ?></INPUT><BR>

        <INPUT TYPE="CHECKBOX" name="col_membership_start"
            <? if ($_REQUEST['col_membership_start'] == 'on') echo ' checked' ?>
        >&nbsp;<? echo LANG_MEMBERSHIP_START ?></INPUT><BR>

        <INPUT TYPE="CHECKBOX" name="col_membership_end"
            <? if ($_REQUEST['col_membership_end'] == 'on') echo ' checked' ?>
        >&nbsp;<? echo LANG_MEMBERSHIP_END ?></INPUT><BR>

        <INPUT TYPE="CHECKBOX" name="col_last_update"
            <? if ($_REQUEST['col_last_update'] == 'on') echo ' checked' ?>
        >&nbsp;<? echo LANG_LAST_UPDATE ?></INPUT>

     </td></tr>
   </table>
   </FORM>
   </TD>

<? } ?>

   <TD>
    <IMG SRC="img/<? echo $action ?>.png">
   </TD>
 </TR>
 <TR>
   <TD colspan="3">

<?
// Only execute query and display contents if there
// has been one generated further above AND
// if output columns has been selected for display

//echo count($cols_to_show);
if (!empty($query)) {

	// let's see how we should order the results
    $query .= (empty($_REQUEST['orderby']))
        ? ' ORDER BY `lastname`'
        : ' ORDER BY ' . $_REQUEST['orderby'];

    // ... ASCending or DESCending?
    $query .= ($_GET['order'] == 'asc') ? ' ASC;' : ' DESC;';

    // After having created the sql query, we remember the
    // generated URI, so we are able to reuse it later on
    $baselink = $_SERVER['PHP_SELF'];

    switch($action) {
    case 'search':
        $baselink .= '?action=search&include_alumni=' . $_REQUEST['include_alumni'] . '&term=' . $term;
        break;
    case 'dropdown':
        $baselink .= '?action=dropdown&Mitgliedschaft_ID=' . $Mitgliedschaft_ID;
        break;
    case 'az':
        $baselink .= '?action=az&list=' . $list;
        break;
    }

    // Remember also all previously checked boxes
    if (is_array($cols_to_show)) {
        while (list($key, $val) = each($cols_to_show)) {
            if("$val" == 'on') {
                $baselink .= '&col_' . "$key" . '=' . "$val";   
            }
        }
    }

    $baselink .= '&orderby=';
	$result    = mysql_query($query,$db);
	$num       = mysql_num_rows($result);

	if ($num > 0 ) {

        /* Let's find out if the last 'order' was asc or desc and create the links in the
           opposite way (e.g. asc=>desc). This allows the user to switch way of sorting */
        $future_order = ($_GET['order'] == 'asc' or empty($_GET['order'])) ? 'desc' : 'asc';

        /* Only change the order for the one currently listed
           $asc_desc['firstname'] => "&order=$future_order"; */
        $asc_desc[$_GET['orderby']] = "&order=$future_order";

        // Walk trough all subtitles and define a blank image
        if (is_array($cols_to_show)) {
            $img_link = $cols_to_show; 
            while (list($key, $val) = each($img_link)) {
                $img_link[$key] = "&nbsp;<IMG SRC='img/7x4.png'>";
            }
        }
        // ... which gets overridden by a 'real' image for the the one the user clicked on for sorting
        $img_link[$_GET['orderby']] = "&nbsp;<IMG SRC='img/" . "$future_order" . ".png' valign='middle'>";


        ?>
		<TABLE BORDER='0' CELLPADDING='2' WIDTH='99%'>
		  <TR>
            <?

        // Ouput the header dynamically
        if (is_array($cols_to_show)) {
            reset($cols_to_show);
            while (list($key, $val) = each($cols_to_show)) {
                if("$val" == 'on') {
                    // transfrom key back to constant to make the translations work
                    $constant_key = 'LANG_' . strtoupper($key); ?>
                    <TD class='subheader'>
                        <A HREF='<? echo "$baselink" . "$key" . "$asc_desc[$key]" ?>'><? echo constant("$constant_key") ?></A>
                            <? echo $img_link["$key"] ?>
                    </TD><?
                }
            }
        }


        if (is_array($cols_to_show)) { ?>

                <TD class='subheader'><? echo LANG_AVAILABLE_FUNCTIONS ?></TD>
              </TR>
            <?
            // Loop through all results and display by alternating colors
            $tr = '<tr class="boxed">';
            while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {

                $tr = ($tr == '<tr>') ? '<tr class="boxed">' : '<tr>';
                echo "$tr";

                if (is_array($cols_to_show)) {
                    reset($cols_to_show);
                    while (list($key, $val) = each($cols_to_show)) {
                        if("$val" == 'on') {
                            ?><TD class='result'><? echo htmlspecialchars($row[$key]) ?></TD><?
                        }
                    }
                }
            ?>

               <TD class='result'><A href='print.php?Mitglied_ID=<? echo $row['Mitglied_ID'] ?>'><? echo LANG_GENERATE_LABEL_PDF ?></A>
                 <A href='detail.php?Mitglied_ID=<? $row['Mitglied_ID'] ?>'><? echo LANG_VIEW_DETAILS ?></A></TD>
               </TR><?
            }
        }
		?></TABLE><?

	// If $query set but empty result => print 'sorry' 
	} else {
        ?>
        	<TABLE BORDER="0" CELLPADDING="2" WIDTH="100%">
        	  <TR><TD class="warn"><? echo LANG_NO_DATA_TO_DISPLAY ?></TD></TR>
        	</TABLE>
        <?
	}
}
//echo "$query";
?>

   </TD>
 </TR>
</TABLE>

<?
include('include/footer.inc');
?>
