<?
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

include("include/config.php");
include("include/functions.php");
include("include/dbconnect.php");
require(FPDF_INSTALLDIR . "fpdf.php");

// If fpdf class not found, die
if(! class_exists('FPDF')) { die("Class 'FPDF' not found, aborting"); }

// Find out which address we should display
$Adress_ID     = (isset($_REQUEST['address'])) ? $_REQUEST['address'] : '1';
$address_table = "Adresse" . "$Adress_ID";

// is this a single label job ...
if ( !empty($_REQUEST['Mitglied_ID']) ) {

    // Make life easier
    $Mitglied_ID = $_REQUEST['Mitglied_ID'];

    // Query address db tables and set php variables
    $query  = sprintf("SELECT m.lastname, m.firstname, m.Mitgliedschaft_ID, a.addressfield1, a.addressfield2, a.state, a.postcode, a.city, a.country
                        FROM Mitglied m, $address_table a
                        WHERE m.Mitglied_ID=%s
                        AND m.Mitglied_ID=a.Mitglied_ID", quote_smart($Mitglied_ID)
                     );

// ... or should we print a series of labels?
} elseif ( !empty($_REQUEST['Mitgliedschaft_ID']) and
                (($_REQUEST['Mitgliedschaft_ID']) != 'SPECIFIC_YESNO') and
                 ($_REQUEST['Mitgliedschaft_ID']) != 'GOG') {

    // Make life easier
    $Mitgliedschaft_ID = $_REQUEST['Mitgliedschaft_ID'];

    // Query address db tables
    $query  = sprintf("SELECT m.lastname, m.firstname, m.Mitgliedschaft_ID, a.addressfield1, a.addressfield2, a.state, a.postcode, a.city, a.country
                        FROM Mitglied m, $address_table a
                        WHERE m.Mitgliedschaft_ID=%s
                        AND m.Mitglied_ID=a.Mitglied_ID", quote_smart($Mitgliedschaft_ID)
                     );


// 'SPECIFIC_YESNO' refers to all members who have the y/n field set to 1
// you may use this feature for abonnements etc. Change the according
// translation in your language file (LANG_SPECIFIC_YESNO)
} elseif ($_REQUEST['Mitgliedschaft_ID'] == 'SPECIFIC_YESNO') {

    $query = "SELECT  m.lastname, m.firstname, a.addressfield1, a.addressfield2, a.state, a.postcode, a.city, a.country
                FROM Mitglied m, $address_table a
                WHERE m.Mitgliedschaft_ID='2'
                AND m.Mitglied_ID=a.Mitglied_ID
                AND specific_yesno='1'
             ";

// 'GOG' is used to offer one print button for a group of groups.
} elseif ($_REQUEST['Mitgliedschaft_ID'] == 'GOG') {
    $query = "SELECT m.Mitgliedschaft_ID, m.lastname, m.firstname, a.addressfield1, a.addressfield2, a.state, a.postcode, a.city, a.country
                FROM Mitglied m, $address_table a, Mitgliedschaft s
                WHERE m.`Mitglied_ID`=a.`Mitglied_ID`
                AND m.`Mitgliedschaft_ID`=s.`Mitgliedschaft_ID`
                    AND (
                        s.`Mitgliedschaft` = 'MEMBERSHIP2'
                     OR s.`Mitgliedschaft` = 'MEMBERSHIP3'
                     OR s.`Mitgliedschaft` = 'MEMBERSHIP4'
                    )";

} else {
	// in case something goes really wrong ...
	die;
}

$query .= " ORDER BY `lastname`";
$result = mysql_query($query);

// Let's see in which format we should generate the PDF('s)
if (LABEL_FORMAT == 'SmartLabel') {
    $pdf=new FPDF(LABEL_ORIENTATION,'mm',array(LABEL_WIDTH,LABEL_HEIGHT));
} else {
    die("LABEL_FORMAT '"  . LABEL_FORMAT . "' not implemented (yet), check your 'config.php'!");
}

$pdf->SetTitle(TITLE);
$pdf->SetAuthor('phpMyMembers');
$pdf->SetSubject('ID=' . "$Mitgliedschaft_ID");
$pdf->SetMargins(5, 3);
$pdf->SetAutoPageBreak(false);
$pdf->SetDisplayMode('real','continuous');

if (LABEL_FORMAT == 'SmartLabel') {

    // Loop over all db results and generate pdf('s)
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {

        // Substitute special characters according to char_table
        // but not if empty or integer to speed up a bit
        $formatted_item = array();
        while (list ($key, $value) = each ($row)) {
            $formatted_item[$key] = get_ascii_char($value);
        }

        $pdf->AddPage();
        $pdf->SetFont('Arial','',LABEL_TITLE_FONT_SIZE);
        $pdf->Cell(0,LABEL_SPACE_AFTER_TITLE,"$formatted_item[lastname] $formatted_item[firstname]",0,'2','L');
        $pdf->SetFont('Arial','',LABEL_TEXT_FONT_SIZE);

        if (!empty($row['addressfield1'])) { $pdf->Cell(0,5,"$formatted_item[addressfield1]",0,'2','L'); }
        if (!empty($row['addressfield2'])) { $pdf->Cell(0,5,"$formatted_item[addressfield2]",0,'2','L'); }
        if (!empty($row['state'])) { $pdf->Cell(0,5,"$formatted_item[state]",0,'2','L'); }

        // should ZIP and City be on one line or one each?
        if (POSTAL_CODE_AND_CITY == 'true') {
            if (!empty($row['postcode']) or (!empty($row['city'])) ) {
                $pdf->Cell(0,5,"$row[postcode] $formatted_item[city]",0,'2','L');
            }
        } else {
            if (!empty($row['postcode'])) { $pdf->Cell(0,5,"$row[postcode]",0,'2','L'); }
            if (!empty($row['city'])) { $pdf->Cell(0,5,"$formatted_item[city]",0,'2','L'); }
        }

        $pdf->Cell(0,5,"$formatted_item[country]",0,'2','L');

        if ( "MEMBERSHIP$row[Mitgliedschaft_ID]" == SPECIAL_PDF_PRINT) {
            $pdf->SetFont('Arial','',5);
            $pdf->Cell(0,5,'(P)',0,0,'R');
        }
    }
}

$pdf->Output();
?>
