<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

include('include/dbconnect.php');
require('include/functions.php');

// Only people of the phpAuthent group 'edit' may submit the form
// We can get the current user logged in with 'getUserId()'
require_once(PHPMYMEMBERS_DIR . '/include/phpauthent/phpauthent_core.php');
$userlist = array('');
$grouplist = array('edit');

$date 	= date('Y-m-d');
$action	= $_REQUEST['action'];
$me	    = $_SERVER['PHP_SELF'];

$Mitglied_ID            = $_POST['Mitglied_ID'];
$lastname               = $_POST['lastname'];
$firstname                = $_POST['firstname'];
$title                  = $_POST['title'];
$membership_number         = $_POST['membership_number'];
$date_of_birth           = make_mysql_date("$_POST[date_of_birth]");
$occupation                  = $_POST['occupation'];
$membership_start               = make_mysql_date("$_POST[membership_start]");
$membership_end               = make_mysql_date("$_POST[membership_end]");
$Mitgliedschaft_ID      = $_POST['Mitgliedschaft_ID'];
$comment                = $_POST['comment'];
$Zivilstand_ID          = $_POST['Zivilstand_ID'];
$Geschlecht_ID          = $_POST['Geschlecht_ID'];
$specific_yesno                     = $_POST['specific_yesno'];

$Adress_ID              = $_POST['Adress_ID'];
$addressfield1            = $_POST['addressfield1'];
$addressfield2            = $_POST['addressfield2'];
$state                 = $_POST['state'];
$postcode           = $_POST['postcode'];
$city                  = $_POST['city'];
$country                   = $_POST['country'];
$phone               = $_POST['phone'];
$fax                = $_POST['fax'];
$cellphone                  = $_POST['cellphone'];
$email                  = $_POST['email'];


// Routine for UPLOADING the picture. Code for displaying the
// picture can be found in include/showimage.php
if ($_POST['completed'] == 1) {

        if ($_FILES['imagefile']['size'] < MAX_UPLOAD_SIZE) {

            // Generate a secure temp file name
            srand ((double)microtime()*1000003);
            $tempfile = UPLOAD_TMP_DIR . '/' . rand() . '.phpmm';

            // If filesize is zero either there was no new image uploaded
            // or there is no picture in the database yet;
            if ($_FILES['imagefile']['size'] == '0') {

                // We will write a new tempfile, prepare:
                if (!$writehandle = fopen($tempfile, "wb")) {
                    print "Kann die Datei $tempfile nicht öffnen";
                    exit;
                }

                if (is_writable($tempfile)) {

                    // Check whether we have a picture already ... if $Mitglied_id
                    // is empty, we know that we are currently in 'new' mode
                    if (!empty($Mitglied_ID)) {
                        $sql = mysql_query("SELECT `photo` from `Mitglied` WHERE Mitglied_ID='$Mitglied_ID'");

                        if ($row = mysql_fetch_assoc($sql)) {
                            if (strlen($row['photo']) > '0') {

                                // Our existing image is also the new one
                                if (!fwrite($writehandle, $row['photo'])) { 
                                    print "Kann in die Datei $tempfile nicht schreiben";
                                    exit;
                                }
                                fclose($writehandle);
                            }
                        }

                    } else {
                        // no image yet ('new' mode), let's put the blank default one in
                        if (!copy(PHPMYMEMBERS_DIR . '/img/keinphoto.png', "$tempfile")) {
                            print "Kann in die Datei $tempfile nicht einkopieren";
                            exit;
                        }
                    }
                }

            } else {
                move_uploaded_file($_FILES['imagefile']['tmp_name'],"$tempfile");
            } 

            // tempfile is now always set and can never be emtpy (for update and inserts, ok)
            $handle = fopen("$tempfile",'rb');
            $image = addslashes(fread($handle,filesize("$tempfile")));
        }
}

switch($action) {
case 'edit':

	$Mitglied_upd_sql 	= sprintf("
				UPDATE `Mitglied` SET
					`lastname`          =%s,
					`firstname`           =%s,
					`title`             =%s,
					`membership_number`    =%s,
					`date_of_birth`      =%s,
					`occupation`             =%s,
					`membership_start`          =%s,
					`membership_end`          =%s,
					`specific_yesno`                =%s,
                    `photo`             =%s,
                    `comment`           =%s,
					`Mitgliedschaft_ID`	=%s,
					`Zivilstand_ID`		=%s,
					`Geschlecht_ID`		=%s,
					`last_update`       =%s,
					`Update_ID`         =%s
				WHERE `Mitglied_ID`=%s",
				quote_smart($lastname),
				quote_smart($firstname),
				quote_smart($title),
				quote_smart($membership_number),
				quote_smart($date_of_birth),
				quote_smart($occupation),
				quote_smart($membership_start),
				quote_smart($membership_end),
				quote_smart($specific_yesno),
				quote_smart($image),
				quote_smart($comment),
				quote_smart($Mitgliedschaft_ID),
				quote_smart($Zivilstand_ID),
				quote_smart($Geschlecht_ID),
				quote_smart($date),
				quote_smart(getUserID()),
				quote_smart($Mitglied_ID)
				);

	$Adress_table = "Adresse" . "$Adress_ID";

	// Check whether the address to be updated already exists,
	// if not, we need to 'insert' instead of 'update'. If no
	// field of the address POSTs is set, we delete the address
	// if not the main one.
	// insert: 0 // update: 1 // delete: 2

	$check_for_address_sql 	= sprintf("
					SELECT COUNT(`Mitglied_ID`) FROM `$Adress_table`
					WHERE `Mitglied_ID`=%s", quote_smart($Mitglied_ID)
				);

	$result = mysql_query($check_for_address_sql)
		or die('Could not check adress table: ' . mysql_error());

        while ($row = mysql_fetch_row($result)) {
                $value = $row[0];
        }

	// Address already existent, 'update' or 'delete' should be ok
	switch($value) {
	case '1':
		if (
		   !empty($addressfield1) or
		   !empty($addressfield2) or
		   !empty($state) or
		   !empty($postcode) or
		   !empty($city) or
		   !empty($country) or
		   !empty($phone) or
		   !empty($fax) or
		   !empty($cellphone) or
		   !empty($email)
		   ) {
			$Adress_upd_sql	= sprintf("
				UPDATE `$Adress_table` SET
					`addressfield1`	=%s,
					`addressfield2`	=%s,
					`state`	=%s,
					`postcode`	=%s,
					`city`		=%s,
					`country`		=%s,
					`phone`	=%s,
					`fax`	=%s,
					`cellphone`		=%s,
					`email`		=%s
				WHERE `Mitglied_ID`	=%s",
					quote_smart($addressfield1),
					quote_smart($addressfield2),
					quote_smart($state),
					quote_smart($postcode),
					quote_smart($city),
					quote_smart($country),
					quote_smart($phone),
					quote_smart($fax),
					quote_smart($cellphone),
					quote_smart($email),
					quote_smart($Mitglied_ID)
				);

		// If all address fields are empty, we delete the entire record
		// instead of updating with empty fields  - if not main address.
		} else {
		   	if ("$Adress_ID" != '1') {
				$Adress_upd_sql = sprintf("
					DELETE FROM `$Adress_table`
					WHERE `Mitglied_ID`=%s
					LIMIT 1",
					quote_smart($Mitglied_ID));
			}
		}
		break;

	// Address NOT existent yet, 'insert' required
	case '0':
        	$Adress_upd_sql		= sprintf("
				INSERT INTO `$Adress_table` (
					`Mitglied_ID`,
                                        `addressfield1`,
                                        `addressfield2`,
                                        `state`,
                                        `postcode`,
                                        `city`,
                                        `country`,
                                        `phone`,
                                        `fax`,
                                        `cellphone`,
                                        `email`)
				VALUES ( %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
                                        quote_smart($Mitglied_ID),
                                        quote_smart($addressfield1),
                                        quote_smart($addressfield2),
                                        quote_smart($state),
                                        quote_smart($postcode),
                                        quote_smart($city),
                                        quote_smart($country),
                                        quote_smart($phone),
                                        quote_smart($fax),
                                        quote_smart($cellphone),
                                        quote_smart($email)
                               	);
				break;
	}

	//print_r($Mitglied_upd_sql);
	//print_r($Adress_upd_sql);
	
	mysql_query($Mitglied_upd_sql,$db) or die('Could not update database, member table: ' . mysql_error());
	mysql_query($Adress_upd_sql,$db)   or die('Could not update database, adress table: ' . mysql_error());
	mysql_close();

    // Remove temp file of photo
    if (file_exists("$tempfile")) { unlink("$tempfile"); }

	// Redirect to some page and exit
	header('Location: http://' . $_SERVER['HTTP_HOST'] . '/phpMyMembers/detail.php?Mitglied_ID=' .
				     $Mitglied_ID . '&address=' . $Adress_ID . '&status=ok');
	exit;
	break;


case 'new':

	$Mitglied_insert_sql 	= sprintf("INSERT INTO `Mitglied` (
							`Mitglied_ID`,
							`membership_number`,
							`lastname`,
							`firstname`,
							`date_of_birth`,
							`Geschlecht_ID`,
							`Zivilstand_ID`,
							`membership_start`,
							`membership_end`,
							`comment`,
							`Mitgliedschaft_ID`,
							`last_update`,
							`Update_ID`,
							`occupation`,
							`photo`,
							`title`,
							`specific_yesno`)
			 		VALUES ( '', %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
					quote_smart($membership_number),
					quote_smart($lastname),
					quote_smart($firstname),
					quote_smart($date_of_birth),
					quote_smart($Geschlecht_ID),
					quote_smart($Zivilstand_ID),
					quote_smart($membership_start),
					quote_smart($membership_end),
					quote_smart($comment),
					quote_smart($Mitgliedschaft_ID),
					quote_smart($date),
					quote_smart(getUserId()),
					quote_smart($occupation),
					quote_smart($image),
					quote_smart($title),
					quote_smart($specific_yesno)
					);

	mysql_query($Mitglied_insert_sql,$db) or die('Could not insert database, member table: ' . mysql_error());

	// mysql_insert_id() gives us the previously assigned auto-increment
	// value which we need for the insert of the address.
	$Mitglied_ID		= mysql_insert_id();

	$Adress_table          	= 'Adresse' . "$Adress_ID";
	$Adress_insert_sql	= sprintf("INSERT INTO `$Adress_table` (
							`Mitglied_ID`,
							`addressfield1`,
							`addressfield2`,
							`state`,
							`postcode`,
							`city`,
							`country`,
							`phone`,
							`fax`,
							`cellphone`,
							`email`)
					VALUES ( %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
					quote_smart($Mitglied_ID),
					quote_smart($addressfield1),
					quote_smart($addressfield2),
					quote_smart($state),
					quote_smart($postcode),
					quote_smart($city),
					quote_smart($country),
					quote_smart($phone),
					quote_smart($fax),
					quote_smart($cellphone),
					quote_smart($email)
					);

	mysql_query($Adress_insert_sql,$db) or die('Could not insert database, address table: ' . mysql_error());
    mysql_close();

    // Remove temp file of photo
    if (file_exists("$tempfile")) { unlink("$tempfile"); }

	// Redirect and exit
	header('Location: http://' . $_SERVER['HTTP_HOST'] . '/phpMyMembers/detail.php?Mitglied_ID=' .
				     $Mitglied_ID . '&address=' . $Adress_ID . '&status=ok');
	exit;
    break;
}

?>
