<?php
/*
 *Example of use of PrintIPP
 *
 * Copyright(C) 2005-2006 Thomas Harding
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Thomas Harding nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 *
 *   mailto:thomas.harding@laposte.net
 *   Thomas Harding, 56 rue de la bourie rouge, 45 000 ORLEANS -- FRANCE
 *
 */

error_reporting(E_ALL);

function __autoload($class_name) {
   require_once $class_name . '.php';
}
   
//require_once("CupsPrintIPP.php"); // other files are loaded by it

echo "<h1>PHP PrintIPP example</h1>";

echo "Note that all options are not showed here<br />";

//$ipp = new PrintIPP(); // Basic PrintIPP
//$ipp = new ExtendedPrintIPP(); // extended IPP
$ipp = new CupsPrintIPP(); // extended IPP with CUPS specific stuff
//$ipp = new PrintIPP(); // Basic IPP (print job, print uri, get printer's attributes, cancel jobs)



//$ipp->debug_level = 3; // Debugging very verbose
$ipp->setLog('/tmp/printipp','file',2); // logging verbose
$ipp->setHost("localhost");//Put your printer IP or hostname/fqdn here

//$ipp->setHost("toto");// Resistance test
$ipp->setHost("geekette");// Resistance test


//$ipp->setPrinterURI("ipp://localhost:631/printers/epson"); // Set printer URI here
$ipp->setPrinterURI("/printers/epson"); // Set printer URI here
//$ipp->setPrinterURI("/printers/foo"); // => abort "client-error-not-found"

$ipp->setUserName("php IPP tester");
$ipp->setFidelity(); // printing abort if every attribute could not be set on printer. NOTE: CUPS do not abort :)


//$ipp->setMimeMediaType('text/html');
//$ipp->setMimeMediaType('foo/bar'); // => client-error-document-format-not-supported
//$ipp->setMimeMediaType('application/postscript');
$ipp->setCharset('utf-8');
$ipp->setLanguage('fr_fr');

$ipp->setAuthentification("test","test"); // username & password 

/* getting printer's attributes */
/*
$ipp->getPrinterAttributes();
echo "Printer's attributes :<pre>\n"; print_r($ipp->printer_attributes); echo "</pre>";

/* getting printers (CUPS extention) */
/*
echo "Available printers [CUPS EXTENTION]:<pre>" ; 
echo $ipp->getPrinters() . "\n";
print_r($ipp->available_printers);
echo "</pre>";
/*
for ($i = 0 ; $i < count($ipp->available_printers) ; $i ++) {
//$ipp->setPrinterURI($ipp->available_printers[$i]); // Set printer URI here
$ipp->getPrinterAttributes();
echo "Printer attributes for printer $i:<pre>\n"; print_r($ipp->printer_attributes); echo "</pre>";
if (isset($ipp->printer_attributes->printer_type->_value2)
        && ($ipp->printer_attributes->printer_type->_value2) == 'print-black')
    echo "The printer can print black<br />\n";
if (isset($ipp->printer_attributes->printer_type->_value3)
        && ($ipp->printer_attributes->printer_type->_value3) == 'print-color')
    echo "The printer can print color<br />\n";

    echo "Printer State: ".$ipp->printer_attributes->printer_state->_value0."<br />";
    echo "Printer State message: ".$ipp->printer_attributes->printer_state_message->_value0."<br />";
    echo "Document formats supported:<br /><pre>";

    $pointer = "_value0";
    for ($j = 0 ; isset($ipp->printer_attributes->document_format_supported->$pointer); $j++) {
        echo $ipp->printer_attributes->document_format_supported->$pointer . "\n";
        $pointer = "_value" . ($j + 1);
        }
    echo "</pre>";

echo "------- END FOR PRINTER $i -------------<br /n>";
}

/* printing a string */
/*
$ipp->setJobName("PHP Test: Text String",true); // default is false: number is automagically appended
$ipp->setRawText();
$ipp->setData("This is a RAW string");//string to print.
//echo "Print RAW String: ".$ipp->printJob()."<br />";
echo "Job Attributes:<pre>\n" ; print_r($ipp->job_attributes) ; echo "\n</pre>\n";
$ipp->unsetRawText();
$ipp->setData("This is a text string");
//echo "Print String: ".$ipp->printJob()."</br />";

/* printing a text file */
/*
        // HINT: you _must_ supply a charset or set output as raw text
        // note that mimeMediaType is resetted to octet-stream after each call of printJob (this is a feature).
//$ipp->setRawText();
$ipp->setCharset('us-ascii');
$ipp->setMimeMediaType('text/plain');

$ipp->setData("./testfiles/test.txt");//Path to file.
echo "Job status: ".$ipp->printJob("epson")."\n";


/* printing a document by URI */

echo "Job Print URI status: ".$ipp->printUri("http://localhost/")."<br />";

/* printing a text file in utf-8 */



$ipp->setUserName("foo bar");
$ipp->setAuthentification("test","test"); // username & password 
$ipp->setDocumentName("testfile with UTF-8 characters");
$ipp->setCharset('utf-8');
// attributes without dedicated function
$ipp->setMimeMediaType('text/plain'); // if autodetection do not work
$ipp->setAttribute('orientation-requested','landscape');
$ipp->setAttribute('number-up',2);
$ipp->setAttribute('compression','gzip');
//$ipp->setData("./testfiles/test-utf8-compressed.txt.gz");//Path to file.
$ipp->setData("./testfiles/test-utf8.txt");//Path to file
//$ipp->setData("test fin");
//echo "Purge jobs: ".$ipp->purgeJobs()."<br />";
//sleep (1);
//sleep(1);
//echo "Printing Job: ".$ipp->printJob()."<br />";
echo "Printing Job: ".$ipp->printJob()."<br />";
$ipp->debug_level = 3;

//$ipp->getJobs($my_jobs=true,$limit=0,"completed",$subset=true); // give only a usefull subset of jobs's attributes
echo "Getting Jobs: ".$ipp->getJobs(true,0,"",true)."<br />"; // defaults to $my_jobs=true,$limit=0 (no limit),$which_jobs=not-completed,$subset=false

echo "Job 0 state: ".$ipp->jobs_attributes->job_0->job_state->_value0."<br />";
echo "Job 0 state-reasons: ".$ipp->jobs_attributes->job_0->job_state_reasons->_value0."<br />";
echo "<pre>";print_r($ipp->jobs_attributes); echo "</pre>";

/*$ipp->getJobAttributes($ipp->last_job,false,'job-template');
                    
$job_state = $ipp->job_attributes->job_state->_value0;
echo "Job-State: $job_state<br />";

$job_state_reasons = $ipp->job_attributes->job_state_reasons->_value0;
echo "Job-State-Reasons: $job_state_reasons<br />";
 
echo "<pre>";print_r($ipp->job_attributes); echo "</pre>";

//$ipp->setData("This is a test");
/*
$ipp->setAttribute('media','A7');
$ipp->setData("./testfiles/documentation/COPYING");
$ipp->setPageRanges('1:2 5:6');
$success = $ipp->printJob();

$ipp->setPageRanges('');
$ipp->setData("This is a test for strings");

/*
$success = $ipp->printJob();
if (!$success) 
    echo "<br />PrintJob status: OPERATION FAILED<br />";
else
    echo "PrintJob status ".$success."<br />";


/* printing a postcript file */

//$ipp->setAuthentification("test","test"); // username & password 
//$ipp->setData("./testfiles/test.ps");
//echo "Job status: ".$ipp->printJob("epson")."<br />";


/* printing a png  file */
//$ipp->setData("./testfiles/test.png");
//echo "Job status: ".$ipp->printJob("epson")."<br />";

/* printing and cancelling job */
/*
echo "Printing and Cancelling a job<br />";
//$ipp->setData("./testfiles/test.ps");
//$ipp->setData("./testfiles/test-compressed.html.gz");
//$ipp->setData("./testfiles/test.html");
echo "Job status: ".$ipp->printJob()."<br />";
*/
/*
$job = $ipp->last_job;
$ipp->setAuthentification("test","test"); // username & password 
$ipp->setMessage(sprintf(_("job %s cancelled"),$job));
echo "Cancel status: ".$ipp->cancelJob($job)."<br />";

/* printing strings, no form feed */
/*
$ipp->setAuthentification("test","test"); // username & password 
$ipp->setRawText();
$ipp->unsetFormFeed();

$ipp->setData("This is a line\n");
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->setData("This is half a line ");
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->setData("This is a end of line\n");
echo "Job status: ".$ipp->printJob("epson")."<br />";

// set copies to 2 (same sheet of paper: form feed is unset)
$ipp->setData("This lines must appeared twice\r\n");
$ipp->setCopies(2);
echo "Job status: ".$ipp->printJob("epson")."<br />";
$ipp->setCopies(1);

// printing string, then form feed
$ipp->setFormFeed();
$ipp->setData("End of test");
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->unsetRawText();
$ipp->setData("./testfiles/test.ps");
//$ipp->setData("./testfiles/test-compressed.html.gz");
//$ipp->setData("./testfiles/test.html");
echo "Job status: ".$ipp->printJob()."<br />";

/* send a buggy request */
/*
$ipp->setData("This is an error : nothing printed\n");
$ipp->generateError ("request_body_malformed");
echo "Job status: ".$ipp->printJob("epson");

$ipp->resetError("request_body_malformed");
*/
/*
$ipp->debug_level = 3;
$ipp->setAuthentification("test","test"); // username & password 
$ipp->setUserName("test");
$ipp->setCopies(1);
echo "Create-Job: ".$ipp->createJob(). "<br />";
printf("Job is: %s<br />",$job = $ipp->last_job);

echo "<pre>";print_r($ipp->job_attributes);echo "</pre>\n";

$ipp->setDocumentName("test-utf8.txt");
$ipp->setData("./testfiles/test-utf8.txt");
echo "Sending document: " . $ipp->sendDocument($job) . "<br />\n";

$ipp->setDocumentName("text string");
$ipp->setData("This is the string of second document");
echo "Sending document: " . $ipp->sendDocument($job,$last=true) . "<br />\n";

// must be refused. Hem: CUPS is very smart, it accepts :)
echo "Sending document: " . $ipp->sendDocument($job,$last=true) . "<br />\n";



$ipp->setMimeMediaType("application/x-foobar");

echo "Validate-Job: ".$ipp->validateJob()."<br />";

foreach ($ipp->job_attributes as $name => $job_attribute) {
    if ($job_attribute->_range == 'unsupported-attributes')
        printf('%s "%s": unsupported attribute<br />',$name,$job_attribute->_value0);
}
reset($ipp->job_attributes);
echo "Details:<pre>"; print_r($ipp->job_attributes) ; echo "</pre>";
/* purging jobs for a printer */
/*
$ipp->setUserName("test");
$ipp->setAuthentification("test","test"); // username & password 
$ipp->setPrinterURI("ipp://localhost:631/printers/epson"); // Set printer URI here
//echo "Purge-Jobs: ". $ipp->purgeJobs() ."<br />";

/* purging jobs for all printers */
/*
$ipp->setPrinterURI("ipp://localhost:631/printers/"); // => all printers
echo "Purge-Jobs: ". $ipp->purgeJobs() ."<br />";



/* get informations about jobs and status */
echo "Available printers:<br />\n" ;
echo "<pre>\n";
print_r($ipp->available_printers);
echo "</pre>";

echo "Jobs:\n<br />" ; 
echo "<pre>\n";
print_r($ipp->jobs);
echo "</pre>";

echo "Jobs URIs:\n<br />\n";
echo "<pre>\n";
print_r($ipp->jobs_uri);
echo "</pre>";

echo "Printers URIs:\n" ; 
echo "<pre>\n";
print_r($ipp->printers_uri);
echo "</pre>";

echo "Operations status:\n" ; 
echo "<pre>\n";
print_r($ipp->status);
echo "</pre>";


/* get debugging informations */
echo "<h3>Debug</h3><pre>";
$ipp->printDebug();
echo "</pre>";
?>
