<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 foldmethod=marker: */
 /* @(#) $Header: /sources/phpprintipp/phpprintipp/http_class.php,v 1.1 2006/01/09 18:26:51 harding Exp $
 *
 *
 * Version: 0.1 -- E X P E R I M E N T A L
 *
 * Class http_class - Basic http client with Basic authorization mechanism.
 *
 *   Copyright (C) 2006  Thomas HARDING
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   mailto:thomas.harding@laposte.net
 *   Thomas Harding, 56 rue de la bourie rouge, 45 000 ORLEANS -- FRANCE
 *   
 */
    
/*

    This class is intended to implement a subset of Hyper Text Transfer Protocol (HTTP/1.1) on client side.
    (currently: POST operation)
    It is a replacement for http://www.phpclasses.org/browse/package/3.html
    in versions post-
    
    It can perform Basic authentication.
    It works only in clear mode
    
    References needed to debug / add functionnalities:
        - RFC 2616
*/
/*
    TODO: beta tests on servers other than loopback one
*/

/*************************
*
* class http_class
*
**************************/

class http_class {

    // {{{ variables declaration
    public $debug;
    public $html_debug;
    public $timeout;
    public $data_timeout;
    public $force_multipart_form_post;
    public $username;
    public $password;
    public $request_headers = array();
    public $request_body = "Not a useful information";
    public $status;
    
    private $default_port = 631;
    
    private $headers;
    private $reply_headers = array();
    private $reply_body = array();
    private $connection;
    private $arguments;
    private $bodystream = array();
    private $last_limit;
    private $connected;
    // }}}
            
    // {{{ constructor
    public function __construct() {
        true;
    }
    // }}}

/*********************
*
* Public functions
*
**********************/

    // {{{ GetRequestArguments ($url,&$arguments)
    public function GetRequestArguments ($url,&$arguments) {
        
        $this->arguments = array();
        
        $arguments["URL"] = $this->arguments["URL"] = $url;
        $arguments["RequestMethod"] = $this->arguments["RequestMethod"] = "POST";
        
        $this->headers["User-agent"] = "PrintIPP Tiny version 0.1";
        $this->headers["Content-Type"] = "application/octet-stream";
    
    }
    // }}}

    // {{{ Open ($arguments)
    public function Open ($arguments) {
        
        /*
        echo "<pre>";
        print_r(stream_get_transports());
        print_r(stream_get_wrappers());
        echo "</pre>";
        */

        if (!$this->timeout)
            $this->timeout = 30;
        $url = $arguments["URL"];
        $port = $this->default_port;
        
        $url = split (':',$url,2);
        $transport_type = $url[0];
        $url = $url[1];
        switch($transport_type) {
                case 'http':
                    $transport_type = 'tcp://';
                    break;
                case 'https':
                    $transport_type = 'tls://';
                    break;
            }
        
            $url = split("/",preg_replace("#^/{1,}#",'',$url),2);
            $url = $url[0];
            $url = split(":",$url);
            $port = array_key_exists(1,$url) ? $url[1] : $this->default_port;
            $url = $url[0];
        
            //echo "$transport_type#$url#$port";flush();
            $this->connection = fsockopen($transport_type.$url, $port, $errno, $errstr, $this->timeout);
        
            if (!$this->connection) 
                return sprintf ('%s (%s)', $errstr, $errno);

            $this->connected = 1;
    }
    // }}}

    // {{{ SendRequest($arguments)
    public function SendRequest($arguments) {
         
         if (!$this->data_timeout)
            $this->data_timeout = 300;
            
         if(!$result = self::StreamRequest($arguments))
            return("SendRequest: unknown error");
         
         self::ReadReply();

         if (!preg_match('#http/1.1 401 unauthorized#',$this->status))
            return;

         
         $headers = array_keys ($this->reply_headers);
         if (!in_array("www-authenticate",$headers))
            return("SendRequest: need authentication but no mechanism provided");

         $authtype = split(' ',$this->reply_headers["www-authenticate"]);
         
         switch ($authtype[0]) {
            case 'basic':
                $pass = base64_encode($this->user.":".$this->password);
                $arguments["Headers"]["Authorization"] = "Basic ".$pass;
                break;
            default:
                return sprintf(_("SendRequest: need '%s' authentication mechanism, but have not, sorry"),$authtype[0]);
         }
        
         self::Close();
         self::Open($arguments);
         
         if(!$result = self::StreamRequest($arguments))
            return("SendRequest: unknown error");

          self::ReadReply();
    
    }
    // }}}

    // {{{ ReadReplyHeaders (&$headers)
    public function ReadReplyHeaders (&$headers) {
        $headers = $this->reply_headers;
    }
    // }}}

    // {{{ ReadReplyBody (&$body,$chunk_size)
    public function ReadReplyBody (&$body,$chunk_size) {
        $body = substr($this->reply_body,$this->last_limit,$chunk_size);
        $this->last_limit += $chunk_size;
    }
    // }}}

    // {{{ Close ()
    public function Close () {
        fclose ($this->connection);
    }
    // }}}

/*********************
*
*  Private functions
*
**********************/

    // {{{ StreamRequest ($arguments)
    private function StreamRequest ($arguments) {
        
        $this->status = "";
        $this->reply_headers = array();
        $this->reply_body = "";
        
        $this->arguments = $arguments;
        $this->arguments["Headers"] = array_merge($this->headers,$this->arguments["Headers"]);
        
        $read = array($this->connection);
        if(stream_select($read, $write = NULL, $except = NULL, 0)) // server talks!
            trigger_error("server-talk",E_USER_WARNING);
            //return "server-talk";
         
        if ($this->arguments["RequestMethod"] == "GET") {
            trigger_error (_("GET: method not implemented"),E_USER_WARNING);
            return _("GET: method not implemented");
            }
    
        if ($this->arguments["RequestMethod"] != "POST") {
            trigger_error (sprintf(_("%s: method do not exists"),$arguments["RequestMethod"]),E_USER_WARNING);
            return sprintf(_("%s: method do not exists"),$arguments["RequestMethod"]);
            }
    
        $string = sprintf("POST %s HTTP/1.1\r\n",$this->arguments["RequestURI"]);
        $error = fwrite($this->connection,$string);
        $this->request_headers[$string] = '';
        if(stream_select($read, $write = NULL, $except = NULL, 0)) // server talks!
            return "server-talk";
        
        if (!$error) {
            trigger_error(_("Error while puts first header"),E_USER_WARNING);
            return _("Stream closed while puts first header");
            }
        
        $content_length = 0;
        foreach ($this->arguments["BodyStream"] as $argument) {
            
            list($type,$value) = each($argument);
            reset ($argument);
            
            if ($type == "Data")
                $length = strlen($value);
                
            elseif ($type == "File")
                if (is_readable($value))
                    $length = filesize($value);
                else {
                    $length = 0;
                    trigger_error(sprintf(_("%s: file is not readable"),$value),E_USER_WARNING);
                    }
            
            else {
                $length = 0;
                trigger_error(sprintf(_("%s: not a valid argument for content"),$type),E_USER_WARNING);
                }
                
            $content_length += $length;
            }
        
        $this->request_body = sprintf(_("%s Bytes"), $content_length);
        $this->arguments["Headers"]["Content-Length"] =  $content_length;
        foreach ($this->arguments["Headers"] as $header => $value) {
            
            $error = fwrite($this->connection,sprintf("%s: %s\r\n", $header, $value));
            $this->request_headers[$header] = $value;
            if(stream_select($read, $write = NULL, $except = NULL, 0))
                return "server-talk";
                
            if (!$error) {
                trigger_error(_("Error while puts HTTP headers"),E_USER_WARNING);
                return _("Stream closed while puts HTTP headers");
                }
            }
        
            $error = fwrite($this->connection,"\r\n");
            fflush($this->connection);

            if(stream_select($read, $write = NULL, $except = NULL, 0))
                return "server-talk";
                
            if (!$error) {
                trigger_error(_("Error while ends HTTP headers"),E_USER_WARNING);
                return _("Stream closed while ends HTTP headers");
                }
         
         foreach ($this->arguments["BodyStream"] as $argument) {
            
            list($type,$value) = each($argument);
            reset ($argument);
            
            if ($type == "Data") {
            
                if(stream_select($read, $write = NULL, $except = NULL, 0))
                    return "server-talk";
                
                // not very clean...
                $error = @fwrite($this->connection,$value);
                }

                if (!$error) 
                    return _("error-while-push-data");
             
            elseif ($type == "File") {
                if (is_readable($value)) {
                    $file = fopen($value,'rb');
                    while(!feof($file)) {
                    
                        if(gettype($block = @fread($file,8192)) != "string") {
                            trigger_error(_("cannot read file to upload"),E_USER_WARNING);
                            return _("cannot read file to upload");
                            }

                        if(stream_select($read, $write = NULL, $except = NULL, 0))
                            return "server-talks";
                
                        // not very clean...
                        $error = @fwrite($this->connection,$block);
                        if (!$error) 
                            return ("error-while-push-data");
                        }
                    }
                }
                
                if(stream_select($read, $write = NULL, $except = NULL, 0))
                    return "server-talks";
                
            }

    return true;
    }
    // }}}
    
    // {{{ ReadReply ()
    private function ReadReply () {
      
        $this->reply_headers = array();
        $this->reply_body = "";
        
        $read = array($this->connection);
        
        
        $line = "1\r\n";
        $headers = "";
        $body = "";
        while (!feof($this->connection)) {
            $line = fgets($this->connection,1024);
            if (strlen($line) <= 2)
                break;
            $headers .= $line;
            }
        $chunk = true;
        
        stream_set_blocking ($this->connection, 0 );
        while (true) {
            //usleep(20000);
            //if (stream_select($read, $write = NULL, $except = NULL, 0) === 0)
            //    break;
            $chunk = fread($this->connection,8192);    
            if (!$chunk)
                break;
            $this->reply_body .= $chunk;
            }
           
        $headers = preg_split('#\r\n#',$headers);

        $this->status = strtolower($headers[0]);
      
        foreach($headers as $header) {
            $header = preg_split("#: #",strtolower($header));
            $this->reply_headers["{$header[0]}"] = array_key_exists(1,$header) ? $header[1] : "";
            }
        
        /*
        echo "<pre>";
        print_r($this->reply_headers);
        echo "</pre>";
        flush();
 
        echo "<pre>";
        printf ("<pre>%s</pre>",htmlspecialchars($this->reply_body));
        echo "</pre>";
        flush();
        */
    }
    // }}}
    
};


/*
 * Local variables:
 * mode: php
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
?>
