
/*
 * php_sdl.h
 * This file is part of sdlextension for PHP
 *
 * Copyright (C) 2008 - Dimitri Giardina
 *
 * sdlextension for PHP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * sdlextension for PHP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with sdlextension for PHP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 * 
 * Linking sdlextension for PHP statically or dynamically with other modules is 
 * making a combined work based on sdlextension for PHP. Thus, the
 * terms and conditions of the GNU General Public License cover the
 * whole combination.
 *
 * In addition, as a special exception, the copyright holders of 
 * sdlextension for PHP give you permission to combine sdlextension for PHP with free
 * software programs or libraries that are released under the GNU 
 * LGPL and PHP License, and with code included in the standard 
 * release of libSDL under the LGPL 
 * (or modified versions of such code, with unchanged license), and
 * libraries and with code included in the standard release of PHP under
 * the PHP License.
 *
 * You may copy and distribute such a system following the terms 
 * of the GNU GPL for @extname and the licenses 
 * of the other code concerned {, provided that you include the source 
 * code of that other code when and as the GNU GPL requires distribution
 * of source code}.
 * 
 * Note that people who make modified versions of sdlextension for PHP are not 
 * obligated to grant this special exception for their modified 
 * versions; it is their choice whether to do so. The GNU General 
 * Public License gives permission to release a modified version 
 * without this exception; this exception also makes it possible to 
 * release a modified version which carries forward this exception.
 */
		
#ifndef PHP_SDL_H 
/* Prevent double inclusion */ 
#define PHP_SDL_H 

/* Define Extension Properties */ 
#define PHP_SDL_EXTNAME    "sdl" 
#define PHP_SDL_EXTVER    "1.0" 

/* Import configure options 
   when building outside of 
   the PHP source tree */ 

#ifdef HAVE_CONFIG_H 
#include "config.h" 
#endif 

/* Include PHP Standard Header */ 
#include "php.h" 

/* Define the entry point symbol 
 * Zend will use when loading this module 
 */ 

PHP_MINIT_FUNCTION(sdl);
PHP_MSHUTDOWN_FUNCTION(sdl);
PHP_RINIT_FUNCTION(sdl);
PHP_RSHUTDOWN_FUNCTION(sdl);
PHP_MINFO_FUNCTION(sdl);

/*******************************
 * Function Declarations
 *******************************/
PHP_FUNCTION(sdl_init);
PHP_FUNCTION(sdl_initsubsystem);
PHP_FUNCTION(sdl_quitsubsystem);
PHP_FUNCTION(sdl_wasinit);
PHP_FUNCTION(sdl_quit);
PHP_FUNCTION(sdl_geterror);
PHP_FUNCTION(sdl_mustlock);
PHP_FUNCTION(sdl_getvideosurface);
PHP_FUNCTION(sdl_getvideoinfo);
PHP_FUNCTION(sdl_videodrivername);
PHP_FUNCTION(sdl_listmodes);
PHP_FUNCTION(sdl_videmodeok);
PHP_FUNCTION(sdl_setvideomode);
PHP_FUNCTION(sdl_updaterect);
PHP_FUNCTION(sdl_updaterects);
PHP_FUNCTION(sdl_flip);
PHP_FUNCTION(sdl_setcolors);
PHP_FUNCTION(sdl_setpalette);
PHP_FUNCTION(sdl_setgamma);
PHP_FUNCTION(sdl_getgammaramp);
PHP_FUNCTION(sdl_setgammaramp);
PHP_FUNCTION(sdl_maprgb);
PHP_FUNCTION(sdl_maprgba);
PHP_FUNCTION(sdl_getrgb);
PHP_FUNCTION(sdl_getrgba);
PHP_FUNCTION(sdl_creatergbsurface);
PHP_FUNCTION(sdl_creatergbsurfacefrom);
PHP_FUNCTION(sdl_freesurface);
PHP_FUNCTION(sdl_locksurface);
PHP_FUNCTION(sdl_unlocksurface);
PHP_FUNCTION(sdl_loadbmp);
PHP_FUNCTION(sdl_savebmp);
PHP_FUNCTION(sdl_setcolorkey);
PHP_FUNCTION(sdl_setalpha);
PHP_FUNCTION(sdl_setcliprect);
PHP_FUNCTION(sdl_getcliprect);
PHP_FUNCTION(sdl_convertsurface);
PHP_FUNCTION(sdl_blitsurface);
PHP_FUNCTION(sdl_fillrect);
PHP_FUNCTION(sdl_displayformat);
PHP_FUNCTION(sdl_displayformatalpha);
PHP_FUNCTION(sdl_warpmouse);
PHP_FUNCTION(sdl_createcursor);
PHP_FUNCTION(sdl_freecursor);
PHP_FUNCTION(sdl_setcursor);
PHP_FUNCTION(sdl_getcursor);
PHP_FUNCTION(sdl_showcursor);
PHP_FUNCTION(sdl_gl_loadlibrary);
PHP_FUNCTION(sdl_gl_getprocaddress);
PHP_FUNCTION(sdl_gl_getattribute);
PHP_FUNCTION(sdl_gl_setattribute);
PHP_FUNCTION(sdl_gl_swapbuffers);
PHP_FUNCTION(sdl_createyuvoverlay);
PHP_FUNCTION(sdl_lockyuvoverlay);
PHP_FUNCTION(sdl_unlockyuvoverlay);
PHP_FUNCTION(sdl_displayyuvoverlay);
PHP_FUNCTION(sdl_freeyuvoverlay);
PHP_FUNCTION(sdl_getpixels);
PHP_FUNCTION(sdl_putpixels);
#ifdef HAVE_SDL_SMPEG
PHP_FUNCTION(XX);
#endif

/*******************************
 * End Function Declarations
 *******************************/


/*
 * php_sdl.h
 * This file is part of phpsdl
 *
 * Copyright (C) 2008 - Dimitri Giardina
 *
 * phpsdl is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * phpsdl is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with phpsdl; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
	
#include "config.h"

#include "SDL.h"

ZEND_BEGIN_MODULE_GLOBALS(sdl)
	long show_sdl_errors;
ZEND_END_MODULE_GLOBALS(sdl)

#define MYGLOBALS(v) (sdl_globals.v)
#define MYGLOBALS_SET(k,x) (sdl_globals.k=x)

ZEND_DECLARE_MODULE_GLOBALS(sdl)
	

extern zend_module_entry sdl_module_entry; 

#define phpext_sample_ptr &sdl_module_entry 


#endif /* PHP_SAMPLE_H */