
/*
 * sdl.c
 * This file is part of sdlextension for PHP
 *
 * Copyright (C) 2008 - Dimitri Giardina
 *
 * sdlextension for PHP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * sdlextension for PHP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with sdlextension for PHP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 * 
 * Linking sdlextension for PHP statically or dynamically with other modules is 
 * making a combined work based on sdlextension for PHP. Thus, the
 * terms and conditions of the GNU General Public License cover the
 * whole combination.
 *
 * In addition, as a special exception, the copyright holders of 
 * sdlextension for PHP give you permission to combine sdlextension for PHP with free
 * software programs or libraries that are released under the GNU 
 * LGPL and PHP License, and with code included in the standard 
 * release of libSDL under the LGPL 
 * (or modified versions of such code, with unchanged license), and
 * libraries and with code included in the standard release of PHP under
 * the PHP License.
 *
 * You may copy and distribute such a system following the terms 
 * of the GNU GPL for @extname and the licenses 
 * of the other code concerned {, provided that you include the source 
 * code of that other code when and as the GNU GPL requires distribution
 * of source code}.
 * 
 * Note that people who make modified versions of sdlextension for PHP are not 
 * obligated to grant this special exception for their modified 
 * versions; it is their choice whether to do so. The GNU General 
 * Public License gives permission to release a modified version 
 * without this exception; this exception also makes it possible to 
 * release a modified version which carries forward this exception.
 */
				
// Inclusions.
#include "php_sdl.h"

// Globals
ZEND_DECLARE_MODULE_GLOBALS(sdl)
// End Globals

/*******************************
 * Resources
 *******************************/
static int le_cdrom;
#define le_cdrom_name "SDL CD-Rom"
static int le_timer;
#define le_timer_name "SDL Timer"
static int le_surface;
#define le_surface_name "SDL Surface"
static int le_pixelformat;
#define le_pixelformat_name "SDL PixelFormat"
static int le_cursor;
#define le_cursor_name "SDL Cursor"
static int le_overlay;
#define le_overlay_name "SDL Overlay"
static int le_joystick;
#define le_joystick_name "SDL Joystick"
static int le_mutex;
#define le_mutex_name "SDL Mutex"
#ifdef HAVE_SDL_SMPEG
static int le_smpeg;
#define le_smpeg_name "SDL SMPEG"
#endif
#ifdef HAVE_SDL_TTF
static int le_font;
#define le_font_name "SDL Font"
#endif
static void _sdl_cdrom(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
static void _sdl_timer(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
static void _sdl_surface(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
static void _sdl_pixelformat(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
static void _sdl_cursor(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
static void _sdl_overlay(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
static void _sdl_joystick(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
static void _sdl_mutex(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
#ifdef HAVE_SDL_SMPEG
static void _sdl_smpeg(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
#endif
#ifdef HAVE_SDL_TTF
static void _sdl_font(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
}
#endif

/*******************************
 * End Resources
 *******************************/


/*******************************
 * Function Definitions
 *******************************/
static function_entry php_sdl_functions[] = {
	PHP_FE(sdl_init,	NULL)
	PHP_FE(sdl_initsubsystem,	NULL)
	PHP_FE(sdl_quitsubsystem,	NULL)
	PHP_FE(sdl_wasinit,	NULL)
	PHP_FE(sdl_quit,	NULL)
	PHP_FE(sdl_geterror,	NULL)
	PHP_FE(sdl_mustlock,	NULL)
	PHP_FE(sdl_getvideosurface,	NULL)
	PHP_FE(sdl_getvideoinfo,	NULL)
	PHP_FE(sdl_videodrivername,	NULL)
	PHP_FE(sdl_listmodes,	NULL)
	PHP_FE(sdl_videmodeok,	NULL)
	PHP_FE(sdl_setvideomode,	NULL)
	PHP_FE(sdl_updaterect,	NULL)
	PHP_FE(sdl_updaterects,	NULL)
	PHP_FE(sdl_flip,	NULL)
	PHP_FE(sdl_setcolors,	NULL)
	PHP_FE(sdl_setpalette,	NULL)
	PHP_FE(sdl_setgamma,	NULL)
	PHP_FE(sdl_getgammaramp,	NULL)
	PHP_FE(sdl_setgammaramp,	NULL)
	PHP_FE(sdl_maprgb,	NULL)
	PHP_FE(sdl_maprgba,	NULL)
	PHP_FE(sdl_getrgb,	NULL)
	PHP_FE(sdl_getrgba,	NULL)
	PHP_FE(sdl_creatergbsurface,	NULL)
	PHP_FE(sdl_creatergbsurfacefrom,	NULL)
	PHP_FE(sdl_freesurface,	NULL)
	PHP_FE(sdl_locksurface,	NULL)
	PHP_FE(sdl_unlocksurface,	NULL)
	PHP_FE(sdl_loadbmp,	NULL)
	PHP_FE(sdl_savebmp,	NULL)
	PHP_FE(sdl_setcolorkey,	NULL)
	PHP_FE(sdl_setalpha,	NULL)
	PHP_FE(sdl_setcliprect,	NULL)
	PHP_FE(sdl_getcliprect,	NULL)
	PHP_FE(sdl_convertsurface,	NULL)
	PHP_FE(sdl_blitsurface,	NULL)
	PHP_FE(sdl_fillrect,	NULL)
	PHP_FE(sdl_displayformat,	NULL)
	PHP_FE(sdl_displayformatalpha,	NULL)
	PHP_FE(sdl_warpmouse,	NULL)
	PHP_FE(sdl_createcursor,	NULL)
	PHP_FE(sdl_freecursor,	NULL)
	PHP_FE(sdl_setcursor,	NULL)
	PHP_FE(sdl_getcursor,	NULL)
	PHP_FE(sdl_showcursor,	NULL)
	PHP_FE(sdl_gl_loadlibrary,	NULL)
	PHP_FE(sdl_gl_getprocaddress,	NULL)
	PHP_FE(sdl_gl_getattribute,	NULL)
	PHP_FE(sdl_gl_setattribute,	NULL)
	PHP_FE(sdl_gl_swapbuffers,	NULL)
	PHP_FE(sdl_createyuvoverlay,	NULL)
	PHP_FE(sdl_lockyuvoverlay,	NULL)
	PHP_FE(sdl_unlockyuvoverlay,	NULL)
	PHP_FE(sdl_displayyuvoverlay,	NULL)
	PHP_FE(sdl_freeyuvoverlay,	NULL)
	PHP_FE(sdl_getpixels,	NULL)
	PHP_FE(sdl_putpixels,	NULL)
/* condition */
#ifdef HAVE_SDL_SMPEG
	PHP_FE(XX,	NULL)
#endif
/* end condition */
	{ NULL, NULL, NULL }
};

/*******************************
 * End Function Definitions
 *******************************/

/*******************************
 * Standard Module Entry
 *******************************/
zend_module_entry sdl_module_entry = { 
#if ZEND_MODULE_API_NO >= 20010901 
	STANDARD_MODULE_HEADER, 
#endif 
	PHP_SDL_EXTNAME, 
	php_sdl_functions, /* Functions */ 
	PHP_MINIT(sdl), /* MINIT */ 
	PHP_MSHUTDOWN(sdl), /* MSHUTDOWN */ 
	PHP_RINIT(sdl), /* RINIT */ 
	PHP_RSHUTDOWN(sdl), /* RSHUTDOWN */ 
	PHP_MINFO(sdl), /* MINFO */ 
#if ZEND_MODULE_API_NO >= 20010901 
	PHP_SDL_EXTVER, 
#endif 
	STANDARD_MODULE_PROPERTIES 
}; 

#ifdef COMPILE_DL_SDL 
ZEND_GET_MODULE(sdl) 
#endif
/*******************************
 * End Standard Module Entry
 *******************************/

/*******************************
 * Init Globals
 *******************************/
/* getting from sdl_globals.c */
static void php_sdl_init_globals(zend_sdl_globals *sdl_globals) {
	sdl_globals->show_sdl_errors=1;
}

/* end getting from sdl_globals.c*/

/*******************************
 * End Init Globals
 *******************************/

/*******************************
 * PHP *_FUNCTIONS
 *******************************/
PHP_MINIT_FUNCTION(sdl) {
	ZEND_INIT_MODULE_GLOBALS(sdl,php_sdl_init_globals,NULL);
	le_cdrom=zend_register_list_destructors_ex(_sdl_cdrom,NULL,le_cdrom_name, module_number);
	le_timer=zend_register_list_destructors_ex(_sdl_timer,NULL,le_timer_name, module_number);
	le_surface=zend_register_list_destructors_ex(_sdl_surface,NULL,le_surface_name, module_number);
	le_pixelformat=zend_register_list_destructors_ex(_sdl_pixelformat,NULL,le_pixelformat_name, module_number);
	le_cursor=zend_register_list_destructors_ex(_sdl_cursor,NULL,le_cursor_name, module_number);
	le_overlay=zend_register_list_destructors_ex(_sdl_overlay,NULL,le_overlay_name, module_number);
	le_joystick=zend_register_list_destructors_ex(_sdl_joystick,NULL,le_joystick_name, module_number);
	le_mutex=zend_register_list_destructors_ex(_sdl_mutex,NULL,le_mutex_name, module_number);
#ifdef HAVE_SDL_SMPEG
	le_smpeg=zend_register_list_destructors_ex(_sdl_smpeg,NULL,le_smpeg_name, module_number);
#endif
#ifdef HAVE_SDL_TTF
	le_font=zend_register_list_destructors_ex(_sdl_font,NULL,le_font_name, module_number);
#endif

	REGISTER_LONG_CONSTANT("SDL_INIT_TIMER",SDL_INIT_TIMER,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_INIT_AUDIO",SDL_INIT_AUDIO,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_INIT_VIDEO",SDL_INIT_VIDEO,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_INIT_CDROM",SDL_INIT_CDROM,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_INIT_JOYSTICK",SDL_INIT_JOYSTICK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_INIT_NOPARACHUTE",SDL_INIT_NOPARACHUTE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_INIT_EVENTTHREAD",SDL_INIT_EVENTTHREAD,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_INIT_EVERYTHING",SDL_INIT_EVERYTHING,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_CD_TRAYEMPTY", CD_TRAYEMPTY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_CD_STOPPED", CD_STOPPED,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_CD_PLAYING", CD_PLAYING,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_CD_PAUSED", CD_PAUSED,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_CD_ERROR", CD_ERROR,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_AUDIO_TRACK", SDL_AUDIO_TRACK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_DATA_TRACK", SDL_DATA_TRACK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_CD_FPS", CD_FPS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_MAX_TRACKS",SDL_MAX_TRACKS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_SWSURFACE",SDL_SWSURFACE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HWSURFACE",SDL_HWSURFACE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_ASYNCBLIT",SDL_ASYNCBLIT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_ANYFORMAT",SDL_ANYFORMAT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HWPALETTE",SDL_HWPALETTE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_DOUBLEBUF",SDL_DOUBLEBUF,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_FULLSCREEN",SDL_FULLSCREEN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_OPENGL",SDL_OPENGL,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_OPENGLBLIT",SDL_OPENGLBLIT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_RESIZABLE",SDL_RESIZABLE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_NOFRAME",SDL_NOFRAME,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_RED_SIZE",SDL_GL_RED_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_GREEN_SIZE",SDL_GL_GREEN_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_BLUE_SIZE",SDL_GL_BLUE_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_ALPHA_SIZE",SDL_GL_ALPHA_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_BUFFER_SIZE",SDL_GL_BUFFER_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_DOUBLEBUFFER",SDL_GL_DOUBLEBUFFER,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_DEPTH_SIZE",SDL_GL_DEPTH_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_STENCIL_SIZE",SDL_GL_STENCIL_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_ACCUM_RED_SIZE",SDL_GL_ACCUM_RED_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_ACCUM_GREEN_SIZE",SDL_GL_ACCUM_GREEN_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_ACCUM_BLUE_SIZE",SDL_GL_ACCUM_BLUE_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GL_ACCUM_ALPHA_SIZE",SDL_GL_ACCUM_ALPHA_SIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_YV12_OVERLAY",SDL_YV12_OVERLAY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_IYUV_OVERLAY",SDL_IYUV_OVERLAY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_YUY2_OVERLAY",SDL_YUY2_OVERLAY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_UYVY_OVERLAY",SDL_UYVY_OVERLAY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_YVYU_OVERLAY",SDL_YVYU_OVERLAY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GRAB_QUERY",SDL_GRAB_QUERY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GRAB_OFF",SDL_GRAB_OFF,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GRAB_ON",SDL_GRAB_ON,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_PRESSED",SDL_PRESSED,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_RELEASED",SDL_RELEASED,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_QUERY",SDL_QUERY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_IGNORE",SDL_IGNORE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_DISABLE",SDL_DISABLE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_ENABLE",SDL_ENABLE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_ADDEVENT",SDL_ADDEVENT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_PEEKEVENT",SDL_PEEKEVENT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_GETEVENT",SDL_GETEVENT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_ALLEVENTS",SDL_ALLEVENTS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_ACTIVEEVENTMASK",SDL_ACTIVEEVENTMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_KEYDOWNMASK",SDL_KEYDOWNMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_KEYUPMASK",SDL_KEYUPMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_MOUSEMOTIONMASK",SDL_MOUSEMOTIONMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_MOUSEBUTTONDOWNMASK",SDL_MOUSEBUTTONDOWNMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_MOUSEBUTTONUPMASK",SDL_MOUSEBUTTONUPMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_MOUSEEVENTMASK",SDL_MOUSEEVENTMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYAXISMOTIONMASK",SDL_JOYAXISMOTIONMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYBALLMOTIONMASK",SDL_JOYBALLMOTIONMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYHATMOTIONMASK",SDL_JOYHATMOTIONMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYBUTTONDOWNMASK",SDL_JOYBUTTONDOWNMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYBUTTONUPMASK",SDL_JOYBUTTONUPMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYEVENTMASK",SDL_JOYEVENTMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_VIDEORESIZEMASK",SDL_VIDEORESIZEMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_VIDEOEXPOSEMASK",SDL_VIDEOEXPOSEMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_QUITMASK",SDL_QUITMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_SYSWMEVENTMASK",SDL_SYSWMEVENTMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_NOEVENT",SDL_NOEVENT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_ACTIVEEVENT",SDL_ACTIVEEVENT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_KEYDOWN",SDL_KEYDOWN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_KEYUP",SDL_KEYUP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_MOUSEMOTION",SDL_MOUSEMOTION,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_MOUSEBUTTONDOWN",SDL_MOUSEBUTTONDOWN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_MOUSEBUTTONUP",SDL_MOUSEBUTTONUP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYAXISMOTION",SDL_JOYAXISMOTION,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYBALLMOTION",SDL_JOYBALLMOTION,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYHATMOTION",SDL_JOYHATMOTION,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYBUTTONDOWN",SDL_JOYBUTTONDOWN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_JOYBUTTONUP",SDL_JOYBUTTONUP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_QUIT",SDL_QUIT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_SYSWMEVENT",SDL_SYSWMEVENT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_EVENT_RESERVEDA",SDL_EVENT_RESERVEDA,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_EVENT_RESERVEDB",SDL_EVENT_RESERVEDB,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_VIDEORESIZE",SDL_VIDEORESIZE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_VIDEOEXPOSE",SDL_VIDEOEXPOSE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_EVENT_RESERVED2",SDL_EVENT_RESERVED2,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_EVENT_RESERVED3",SDL_EVENT_RESERVED3,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_EVENT_RESERVED4",SDL_EVENT_RESERVED4,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_EVENT_RESERVED5",SDL_EVENT_RESERVED5,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_EVENT_RESERVED6",SDL_EVENT_RESERVED6,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_EVENT_RESERVED7",SDL_EVENT_RESERVED7,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_USEREVENT",SDL_USEREVENT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_NUMEVENTS",SDL_NUMEVENTS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_APPMOUSEFOCUS",SDL_APPMOUSEFOCUS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_APPINPUTFOCUS",SDL_APPINPUTFOCUS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_APPACTIVE",SDL_APPACTIVE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_UNKNOWN",SDLK_UNKNOWN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_FIRST",SDLK_FIRST,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_BACKSPACE",SDLK_BACKSPACE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_TAB",SDLK_TAB,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_CLEAR",SDLK_CLEAR,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RETURN",SDLK_RETURN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_PAUSE",SDLK_PAUSE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_ESCAPE",SDLK_ESCAPE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_SPACE",SDLK_SPACE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_EXCLAIM",SDLK_EXCLAIM,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_QUOTEDBL",SDLK_QUOTEDBL,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_HASH",SDLK_HASH,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_DOLLAR",SDLK_DOLLAR,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_AMPERSAND",SDLK_AMPERSAND,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_QUOTE",SDLK_QUOTE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LEFTPAREN",SDLK_LEFTPAREN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RIGHTPAREN",SDLK_RIGHTPAREN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_ASTERISK",SDLK_ASTERISK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_PLUS",SDLK_PLUS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_COMMA",SDLK_COMMA,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_MINUS",SDLK_MINUS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_PERIOD",SDLK_PERIOD,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_SLASH",SDLK_SLASH,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_0",SDLK_0,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_1",SDLK_1,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_2",SDLK_2,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_3",SDLK_3,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_4",SDLK_4,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_5",SDLK_5,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_6",SDLK_6,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_7",SDLK_7,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_8",SDLK_8,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_9",SDLK_9,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_COLON",SDLK_COLON,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_SEMICOLON",SDLK_SEMICOLON,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LESS",SDLK_LESS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_EQUALS",SDLK_EQUALS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_GREATER",SDLK_GREATER,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_QUESTION",SDLK_QUESTION,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_AT",SDLK_AT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LEFTBRACKET",SDLK_LEFTBRACKET,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_BACKSLASH",SDLK_BACKSLASH,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RIGHTBRACKET",SDLK_RIGHTBRACKET,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_CARET",SDLK_CARET,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_UNDERSCORE",SDLK_UNDERSCORE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_BACKQUOTE",SDLK_BACKQUOTE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_a",SDLK_a,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_b",SDLK_b,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_c",SDLK_c,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_d",SDLK_d,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_e",SDLK_e,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_f",SDLK_f,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_g",SDLK_g,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_h",SDLK_h,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_i",SDLK_i,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_j",SDLK_j,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_k",SDLK_k,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_l",SDLK_l,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_m",SDLK_m,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_n",SDLK_n,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_o",SDLK_o,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_p",SDLK_p,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_q",SDLK_q,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_r",SDLK_r,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_s",SDLK_s,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_t",SDLK_t,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_u",SDLK_u,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_v",SDLK_v,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_w",SDLK_w,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_x",SDLK_x,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_y",SDLK_y,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_z",SDLK_z,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_DELETE",SDLK_DELETE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_0",SDLK_WORLD_0,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_1",SDLK_WORLD_1,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_2",SDLK_WORLD_2,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_3",SDLK_WORLD_3,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_4",SDLK_WORLD_4,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_5",SDLK_WORLD_5,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_6",SDLK_WORLD_6,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_7",SDLK_WORLD_7,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_8",SDLK_WORLD_8,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_9",SDLK_WORLD_9,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_10",SDLK_WORLD_10,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_11",SDLK_WORLD_11,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_12",SDLK_WORLD_12,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_13",SDLK_WORLD_13,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_14",SDLK_WORLD_14,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_15",SDLK_WORLD_15,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_16",SDLK_WORLD_16,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_17",SDLK_WORLD_17,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_18",SDLK_WORLD_18,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_19",SDLK_WORLD_19,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_20",SDLK_WORLD_20,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_21",SDLK_WORLD_21,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_22",SDLK_WORLD_22,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_23",SDLK_WORLD_23,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_24",SDLK_WORLD_24,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_25",SDLK_WORLD_25,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_26",SDLK_WORLD_26,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_27",SDLK_WORLD_27,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_28",SDLK_WORLD_28,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_29",SDLK_WORLD_29,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_30",SDLK_WORLD_30,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_31",SDLK_WORLD_31,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_32",SDLK_WORLD_32,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_33",SDLK_WORLD_33,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_34",SDLK_WORLD_34,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_35",SDLK_WORLD_35,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_36",SDLK_WORLD_36,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_37",SDLK_WORLD_37,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_38",SDLK_WORLD_38,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_39",SDLK_WORLD_39,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_40",SDLK_WORLD_40,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_41",SDLK_WORLD_41,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_42",SDLK_WORLD_42,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_43",SDLK_WORLD_43,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_44",SDLK_WORLD_44,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_45",SDLK_WORLD_45,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_46",SDLK_WORLD_46,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_47",SDLK_WORLD_47,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_48",SDLK_WORLD_48,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_49",SDLK_WORLD_49,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_50",SDLK_WORLD_50,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_51",SDLK_WORLD_51,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_52",SDLK_WORLD_52,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_53",SDLK_WORLD_53,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_54",SDLK_WORLD_54,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_55",SDLK_WORLD_55,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_56",SDLK_WORLD_56,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_57",SDLK_WORLD_57,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_58",SDLK_WORLD_58,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_59",SDLK_WORLD_59,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_60",SDLK_WORLD_60,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_61",SDLK_WORLD_61,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_62",SDLK_WORLD_62,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_63",SDLK_WORLD_63,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_64",SDLK_WORLD_64,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_65",SDLK_WORLD_65,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_66",SDLK_WORLD_66,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_67",SDLK_WORLD_67,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_68",SDLK_WORLD_68,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_69",SDLK_WORLD_69,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_70",SDLK_WORLD_70,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_71",SDLK_WORLD_71,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_72",SDLK_WORLD_72,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_73",SDLK_WORLD_73,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_74",SDLK_WORLD_74,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_75",SDLK_WORLD_75,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_76",SDLK_WORLD_76,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_77",SDLK_WORLD_77,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_78",SDLK_WORLD_78,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_79",SDLK_WORLD_79,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_80",SDLK_WORLD_80,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_81",SDLK_WORLD_81,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_82",SDLK_WORLD_82,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_83",SDLK_WORLD_83,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_84",SDLK_WORLD_84,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_85",SDLK_WORLD_85,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_86",SDLK_WORLD_86,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_87",SDLK_WORLD_87,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_88",SDLK_WORLD_88,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_89",SDLK_WORLD_89,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_90",SDLK_WORLD_90,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_91",SDLK_WORLD_91,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_92",SDLK_WORLD_92,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_93",SDLK_WORLD_93,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_94",SDLK_WORLD_94,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_WORLD_95",SDLK_WORLD_95,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP0",SDLK_KP0,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP1",SDLK_KP1,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP2",SDLK_KP2,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP3",SDLK_KP3,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP4",SDLK_KP4,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP5",SDLK_KP5,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP6",SDLK_KP6,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP7",SDLK_KP7,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP8",SDLK_KP8,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP9",SDLK_KP9,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP_PERIOD",SDLK_KP_PERIOD,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP_DIVIDE",SDLK_KP_DIVIDE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP_MULTIPLY",SDLK_KP_MULTIPLY,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP_MINUS",SDLK_KP_MINUS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP_PLUS",SDLK_KP_PLUS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP_ENTER",SDLK_KP_ENTER,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_KP_EQUALS",SDLK_KP_EQUALS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_UP",SDLK_UP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_DOWN",SDLK_DOWN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RIGHT",SDLK_RIGHT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LEFT",SDLK_LEFT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_INSERT",SDLK_INSERT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_HOME",SDLK_HOME,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_END",SDLK_END,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_PAGEUP",SDLK_PAGEUP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_PAGEDOWN",SDLK_PAGEDOWN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F1",SDLK_F1,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F2",SDLK_F2,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F3",SDLK_F3,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F4",SDLK_F4,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F5",SDLK_F5,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F6",SDLK_F6,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F7",SDLK_F7,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F8",SDLK_F8,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F9",SDLK_F9,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F10",SDLK_F10,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F11",SDLK_F11,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F12",SDLK_F12,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F13",SDLK_F13,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F14",SDLK_F14,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_F15",SDLK_F15,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_NUMLOCK",SDLK_NUMLOCK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_CAPSLOCK",SDLK_CAPSLOCK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_SCROLLOCK",SDLK_SCROLLOCK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RSHIFT",SDLK_RSHIFT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LSHIFT",SDLK_LSHIFT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RCTRL",SDLK_RCTRL,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LCTRL",SDLK_LCTRL,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RALT",SDLK_RALT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LALT",SDLK_LALT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RMETA",SDLK_RMETA,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LMETA",SDLK_LMETA,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LSUPER",SDLK_LSUPER,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_RSUPER",SDLK_RSUPER,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_MODE",SDLK_MODE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_COMPOSE",SDLK_COMPOSE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_HELP",SDLK_HELP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_PRINT",SDLK_PRINT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_SYSREQ",SDLK_SYSREQ,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_BREAK",SDLK_BREAK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_MENU",SDLK_MENU,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_POWER",SDLK_POWER,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_EURO",SDLK_EURO,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDLK_LAST",SDLK_LAST,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_NONE",KMOD_NONE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_LSHIFT",KMOD_LSHIFT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_RSHIFT",KMOD_RSHIFT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_LCTRL",KMOD_LCTRL,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_RCTRL",KMOD_RCTRL,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_LALT",KMOD_LALT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_RALT",KMOD_RALT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_LMETA",KMOD_LMETA,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_RMETA",KMOD_RMETA,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_NUM",KMOD_NUM,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_CAPS",KMOD_CAPS,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_MODE",KMOD_MODE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_RESERVED",KMOD_RESERVED,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_CTRL",KMOD_CTRL,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_SHIFT",KMOD_SHIFT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_ALT",KMOD_ALT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("KMOD_META",KMOD_META,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_BUTTON_LEFT",SDL_BUTTON_LEFT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_BUTTON_MIDDLE",SDL_BUTTON_MIDDLE,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_BUTTON_RIGHT",SDL_BUTTON_RIGHT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_BUTTON_LMASK",SDL_BUTTON_LMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_BUTTON_MMASK",SDL_BUTTON_MMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_BUTTON_RMASK",SDL_BUTTON_RMASK,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_CENTERED",SDL_HAT_CENTERED,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_UP",SDL_HAT_UP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_RIGHT",SDL_HAT_RIGHT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_DOWN",SDL_HAT_DOWN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_LEFT",SDL_HAT_LEFT,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_RIGHTUP",SDL_HAT_RIGHTUP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_RIGHTDOWN",SDL_HAT_RIGHTDOWN,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_LEFTUP",SDL_HAT_LEFTUP,CONST_CS | CONST_PERSISTENT);
	REGISTER_LONG_CONSTANT("SDL_HAT_LEFTDOWN",SDL_HAT_LEFTDOWN,CONST_CS | CONST_PERSISTENT);
	#ifdef HAVE_SDL_SMPEG
		REGISTER_LONG_CONSTANT("SMPEG_ERROR",SMPEG_ERROR,CONST_CS | CONST_PERSISTENT);
		REGISTER_LONG_CONSTANT("SMPEG_STOPPED",SMPEG_STOPPED,CONST_CS | CONST_PERSISTENT);
		REGISTER_LONG_CONSTANT("SMPEG_PLAYING",SMPEG_PLAYING,CONST_CS | CONST_PERSISTENT);
	#endif

	return SUCCESS;
}
PHP_MSHUTDOWN_FUNCTION(sdl) {
	return SUCCESS;	
}
PHP_RINIT_FUNCTION(sdl) {
	return SUCCESS;	
}
PHP_RSHUTDOWN_FUNCTION(sdl) {
	return SUCCESS;	
}
PHP_MINFO_FUNCTION(sdl) {
	php_info_print_table_start();
	php_info_print_table_header(2, "sdl support", "enabled");
	php_info_print_table_end();
}	
/*******************************
 * End PHP *_FUNCTIONS
 *******************************/

/*******************************
 * Stuff/Conversion Code
 *******************************/
/* getting from sdl_stuff.c */
#define TRUE (0==0)
#define FALSE (!TRUE)

// finding a element by index from an array.
static int getArrayValueByIndex(zval array, long index, zval **dest) {	
	zval **dest1;
	if (zend_hash_index_find(Z_ARRVAL(array),index, (void **)&dest1)==FAILURE) {
		php_error(E_WARNING, "%s() unable to find %d in array",
					get_active_function_name(TSRMLS_C),index);
		return FALSE;	
	}
	*dest=*dest1;
	return TRUE;
}

// finding a element by string key from an array.
static int getArrayValueByString(zval array, char *key, zval **dest) {
	long key_length=0;
	zval **dest1;
	key_length=strlen(key);
	if (key && zend_hash_find(Z_ARRVAL(array),key,key_length+1,(void **)&dest1)==FAILURE) {
		php_error(E_WARNING, "%s() unable to find %s in array",
					get_active_function_name(TSRMLS_C),key);
		return FALSE;
	}
	*dest=*dest1;
	return TRUE;
}

int XX(void) {
	php_printf("Hello world");
	return 1;
}
void mysdl_error(const char *msg) {
	if (MYGLOBALS(show_sdl_errors)) {
		php_error(E_WARNING,"function:%s, error in %s: SDL Error: %s",
			get_active_function_name(TSRMLS_C),msg,SDL_GetError());
	}
}
//SDL_Rect->Array.
static void rect2array(SDL_Rect r, zval *a)
{
	array_init(a);
	add_assoc_long(a, "x", r.x);
	add_assoc_long(a, "y", r.y);
	add_assoc_long(a, "w", r.w);
	add_assoc_long(a, "h", r.h);
}

static int array2rect(zval srcrect, SDL_Rect *r) {
	zval *handle;
	if (!getArrayValueByString(srcrect,"x",&handle)) {
		r->x=0;
	} else {
		r->x=Z_LVAL_P(handle);
	}
	if (!getArrayValueByString(srcrect,"y",&handle)) {
		r->y=0;
	} else {
		r->y=Z_LVAL_P(handle);
	}
	if (!getArrayValueByString(srcrect,"w",&handle)) {
		r->w=0;
	} else {
		r->w=Z_LVAL_P(handle);
	}
	if (!getArrayValueByString(srcrect,"h",&handle)) {
		r->h=0;
	} else {
		r->h=Z_LVAL_P(handle);
	}					

}
//SDL_PixelFormat -> Array 
static void pf2array(SDL_PixelFormat *pixelformat, zval *pixelformat_array TSRMLS_DC)
{
	zval *palette, *colors, *color;
	int handle, i;

	handle = zend_list_insert(pixelformat, le_pixelformat);
	
	array_init(pixelformat_array);
	add_assoc_resource(pixelformat_array, "handle", handle);
	zend_list_addref(handle);

	add_assoc_long(pixelformat_array, "BitsPerPixel", pixelformat->BitsPerPixel);
	add_assoc_long(pixelformat_array, "BytesPerPixel", pixelformat->BytesPerPixel);
	add_assoc_long(pixelformat_array, "Rmask", pixelformat->Rmask);
	add_assoc_long(pixelformat_array, "Gmask", pixelformat->Gmask);
	add_assoc_long(pixelformat_array, "Bmask", pixelformat->Bmask);
	add_assoc_long(pixelformat_array, "Amask", pixelformat->Amask);
	add_assoc_long(pixelformat_array, "Rshift", pixelformat->Rshift);
	add_assoc_long(pixelformat_array, "Gshift", pixelformat->Gshift);
	add_assoc_long(pixelformat_array, "Bshift", pixelformat->Bshift);
	add_assoc_long(pixelformat_array, "Ashift", pixelformat->Ashift);
	add_assoc_long(pixelformat_array, "Rloss", pixelformat->Rloss);
	add_assoc_long(pixelformat_array, "Gloss", pixelformat->Gloss);
	add_assoc_long(pixelformat_array, "Bloss", pixelformat->Bloss);
	add_assoc_long(pixelformat_array, "Aloss", pixelformat->Aloss);
	add_assoc_long(pixelformat_array, "colorkey", pixelformat->colorkey);
	add_assoc_long(pixelformat_array, "alpha", pixelformat->alpha);

	if (pixelformat->palette == NULL) {
		add_assoc_null(pixelformat_array, "palette");
	} else {
		MAKE_STD_ZVAL(palette);
		array_init(palette);
		MAKE_STD_ZVAL(colors);
		add_assoc_long(palette, "ncolors", pixelformat->palette->ncolors);
		array_init(colors);
	
		for(i=0; i < pixelformat->palette->ncolors; i++)
		{
			MAKE_STD_ZVAL(color);
			array_init(color);
			add_assoc_long(color, "r", pixelformat->palette->colors[i].r);
			add_assoc_long(color, "g", pixelformat->palette->colors[i].g);
			add_assoc_long(color, "b", pixelformat->palette->colors[i].b);
			add_next_index_zval(colors, color);
		}
		add_assoc_zval(palette, "colors", colors);
		add_assoc_zval(pixelformat_array, "palette", palette);
	}
}

// SDL_Surface -> Array
static void surf2array(SDL_Surface *surface, zval *surface_array TSRMLS_DC)
{
	zval *format, *rect;
	int handle;

	handle = zend_list_insert(surface, le_surface);

	array_init(surface_array);
	add_assoc_resource(surface_array, "handle", handle);
	zend_list_addref(handle);

	add_assoc_long(surface_array, "flags", surface->flags);
	add_assoc_long(surface_array, "w", surface->w);
	add_assoc_long(surface_array, "h", surface->h);
	add_assoc_long(surface_array, "pitch", surface->pitch);
	add_assoc_long(surface_array, "refcount", surface->refcount);

	MAKE_STD_ZVAL(format);
	pf2array(surface->format, format TSRMLS_CC);
	add_assoc_zval(surface_array, "format", format);

	MAKE_STD_ZVAL(rect);
	rect2array(&surface->clip_rect, rect);
	add_assoc_zval(surface_array, "clip_rect", rect);
}

static void videoinfo2array(SDL_VideoInfo *from, zval *to TSRMLS_DC) {
	zval *fmt;
	array_init(to);
	
	add_assoc_long(to, "hw_available", from->hw_available);
	add_assoc_long(to, "wm_available", from->wm_available);
	add_assoc_long(to, "blit_hw", from->blit_hw);
	add_assoc_long(to, "blit_hw_CC", from->blit_hw_CC);
	add_assoc_long(to, "blit_hw_A", from->blit_hw_A);
	add_assoc_long(to, "blit_sw", from->blit_sw);
	add_assoc_long(to, "blit_sw_CC", from->blit_sw_CC);
	add_assoc_long(to, "blit_sw_A", from->blit_sw_A);
	add_assoc_long(to, "blit_fill", from->blit_fill);
	add_assoc_long(to, "video_mem", from->video_mem);

	MAKE_STD_ZVAL(fmt);
	pf2array(from->vfmt, fmt TSRMLS_CC);
	add_assoc_zval(to, "vfmt", fmt);
}
/* end getting from sdl_stuff.c*/

/*******************************
 * Stuff/Conversion Code
 *******************************/

/*******************************
 * Functions Code
 *******************************/
PHP_FUNCTION(sdl_init) {
	int flags;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l", &flags)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		if (SDL_Init(flags)==-1) { mysdl_error("SDL_Init"); RETURN_FALSE; } RETURN_TRUE;
	}
}
PHP_FUNCTION(sdl_initsubsystem) {
	int flags;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l", &flags)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		if (SDL_InitSubSystem(flags)==-1) { mysdl_error("SDL_InitSubSystem"); RETURN_FALSE; } RETURN_TRUE;
			
	}
}
PHP_FUNCTION(sdl_quitsubsystem) {
	int flags;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l", &flags)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		SDL_QuitSubSystem(flags);
	}
}
PHP_FUNCTION(sdl_wasinit) {
	int flags;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l", &flags)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		ZVAL_LONG(return_value,SDL_WasInit(flags));
	}
}
PHP_FUNCTION(sdl_quit) {
SDL_Quit();
}
PHP_FUNCTION(sdl_geterror) {
ZVAL_STRING(return_value,SDL_GetError(),0);
}
PHP_FUNCTION(sdl_mustlock) {
	zval *surf;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &surf)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	ZVAL_LONG(return_value,SDL_MUSTLOCK(s));
			
	}
}
PHP_FUNCTION(sdl_getvideosurface) {

			SDL_Surface *surf; surf=SDL_GetVideoSurface();
			if (!surf) { mysdl_error("couldn't get surface"); RETURN_FALSE }
			surf2array(surf, return_value TSRMLS_CC);
			
}
PHP_FUNCTION(sdl_getvideoinfo) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_videodrivername) {
char name[256]; RETURN_STRING(SDL_VideoDriverName((char *)name,255),1);
}
PHP_FUNCTION(sdl_listmodes) {
	zval *format;
	long flags;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zl", &format,&flags)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *dest,*ret1;
				SDL_PixelFormat pf1;	
				SDL_Rect **modes;
				int i;
				if (getArrayValueByString(*format,"BitsPerPixel",&dest)) {
					pf1.BitsPerPixel=Z_LVAL_P(dest);
					modes = SDL_ListModes(&pf1, flags);
				} else {
					modes = SDL_ListModes(NULL, flags);
				}
				if (modes==NULL) RETURN_FALSE;
				for (i=0;modes[i];i++) {
					array_init(ret1);
					add_assoc_long(ret1, "x", modes[i]->x);
					add_assoc_long(ret1, "y", modes[i]->y);
					add_assoc_long(ret1, "w", modes[i]->w);
					add_assoc_long(ret1, "h", modes[i]->h);
					add_next_index_zval(return_value,ret1);					
				}
			
	}
}
PHP_FUNCTION(sdl_videmodeok) {
	int width;
	int height;
	int bpp;
	int flags;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llll", &width,&height,&bpp,&flags)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		ZVAL_LONG(return_value,SDL_VideoModeOk(width,height,bpp,flags));
	}
}
PHP_FUNCTION(sdl_setvideomode) {
	int width;
	int height;
	int bpp;
	int flags;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llll", &width,&height,&bpp,&flags)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Surface *surf; surf=SDL_SetVideoMode(width,height,bpp,flags); 
				if (!surf) { mysdl_error("couldnt create surface"); RETURN_FALSE; }
				surf2array(surf,return_value TSRMLS_CC);				
			
	}
}
PHP_FUNCTION(sdl_updaterect) {
	zval *surf;
	long x;
	long y;
	long width;
	long height;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zllll", &surf,&x,&y,&width,&height)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	SDL_UpdateRect(s,x,y,width,height);
			
	}
}
PHP_FUNCTION(sdl_updaterects) {
	zval *surf;
	int numrects;
	zval *rects;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zlz", &surf,&numrects,&rects)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle,*x,*y,*w,*h,*e;
				SDL_Surface *s;
				int n_rects,i;
				SDL_Rect *r;
				n_rects=zend_hash_next_free_element(Z_ARRVAL_P(rects));

				if (numrects>n_rects) numrects=n_rects;
				if (numrects==0) RETURN_FALSE;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);

				r=(SDL_Rect *)emalloc(numrects*sizeof(SDL_Rect));
				for (i=0;i<numrects;i++) {
					if (!getArrayValueByIndex(*rects,i,&e)) {
						RETURN_FALSE;
					}
					array2rect(*e,&(r[i]));
				}
				SDL_UpdateRects(s,numrects,r);
				efree(r);
			
	}
}
PHP_FUNCTION(sdl_flip) {
	zval *surf;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &surf)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	ZVAL_LONG(return_value,SDL_Flip(s));
			
	}
}
PHP_FUNCTION(sdl_setcolors) {
	zval *surf;
	zval *colors;
	int firstcolor;
	int ncolors;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzll", &surf,&colors,&firstcolor,&ncolors)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *color,*r,*g,*b;
				SDL_Color *colors1;
				int i;
				long result;
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);

			 	colors1  = (SDL_Color *)emalloc(ncolors*sizeof(SDL_Color));
			 	for (i=0;i<ncolors;i++) {
					if (!getArrayValueByIndex(*colors,i,&color))
						RETURN_FALSE;

					getArrayValueByString(*color,"r",&r);
					getArrayValueByString(*color,"g",&g);					
					getArrayValueByString(*color,"r",&b);					
					colors1[i].r=Z_LVAL_P(r);
					colors1[i].g=Z_LVAL_P(g);					
					colors1[i].r=Z_LVAL_P(b);					
				}						 	
				result = SDL_SetColors(s, colors1, firstcolor, ncolors);
				ZVAL_LONG(return_value,result);							
			
	}
}
PHP_FUNCTION(sdl_setpalette) {
	zval *surf;
	int flags;
	zval **colors;
	int firstcolor;
	int ncolors;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zlall", &surf,&flags,colors,&firstcolor,&ncolors)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *color,*r,*g,*b;
				SDL_Color *colors1;
				int i;
				long result;
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);

			 	colors1  = (SDL_Color *)emalloc(ncolors*sizeof(SDL_Color));

			 	for (i=0;i<ncolors;i++) {
					if (!getArrayByIndex(*colors,i,&color)) 
						RETURN_FALSE;
					getArrayValueByString(*color,"r",&r);
					getArrayValueByString(*color,"g",&g);					
					getArrayValueByString(*color,"r",&b);					
					colors1[i].r=Z_LVAL_P(r);
					colors1[i].g=Z_LVAL_P(g);					
					colors1[i].r=Z_LVAL_P(b);					
				}
						 	
				result = SDL_SetPalette(s, flags, colors1, firstcolor, ncolors);
				ZVAL_LONG(return_value,result);							

			
	}
}
PHP_FUNCTION(sdl_setgamma) {
	float r;
	float g;
	float b;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ddd", &r,&g,&b)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
			ZVAL_LONG(return_value,SDL_SetGamma(r,g,b));
			
	}
}
PHP_FUNCTION(sdl_getgammaramp) {
	zval *redtable;
	zval *greentable;
	zval *bluetable;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &redtable,&greentable,&bluetable)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				Uint16 r[256],g[256],b[256];
				int result,i;
				result=SDL_GetGammaRamp(r,g,b);
				
				for (i=0;i<256;i++) {
					add_index_long(redtable,i,r[i]);
					add_index_long(greentable,i,g[i]);					
					add_index_long(bluetable,i,b[i]);										
				}
				RETURN_LONG(result);
			
	}
}
PHP_FUNCTION(sdl_setgammaramp) {
	zval *redtable;
	zval *greentable;
	zval *bluetable;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &redtable,&greentable,&bluetable)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				Uint16 r[256],g[256],b[256];
				zval *r1, *g1, *b1;
				int result,i;
				
				for (i=0;i<256;i++) {
					if (getArrayByIndexValue(*redtable,i,&r1)) {
						r[i]=Z_LVAL_P(r1);
					} else {
						r[i]=0;
					}
					if (getArrayByIndexValue(*greentable,i,&g1)) {
						g[i]=Z_LVAL_P(g1);
					} else {
						g[i]=0;
					}
					if (getArrayByIndexValue(*bluetable,i,&b1)) {
						b[i]=Z_LVAL_P(b1);
					} else {
						b[i]=0;
					}
				}
				RETURN_LONG(SDL_SetGammaRamp(r, g, b));				
			
	}
}
PHP_FUNCTION(sdl_maprgb) {
	zval *fmt;
	int r;
	int g;
	int b;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zlll", &fmt,&r,&g,&b)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_PixelFormat *f;
				zval *handle;
				if (!getArrayValueByString(*fmt,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(f,SDL_PixelFormat *,&handle,-1,le_pixelformat_name,le_pixelformat);
				ZEND_LONG(return_value,SDL_MapRGB(f,r,g,b));
			
	}
}
PHP_FUNCTION(sdl_maprgba) {
	zval *fmt;
	int r;
	int g;
	int b;
	int a;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zllll", &fmt,&r,&g,&b,&a)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_PixelFormat *f;
				zval *handle;
				if (!getArrayValueByString(*fmt,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(f,SDL_PixelFormat *,&handle,-1,le_pixelformat_name,le_pixelformat);
				ZEND_LONG(return_value,SDL_MapRGBA(f,r,g,b,a));			
			
	}
}
PHP_FUNCTION(sdl_getrgb) {
	long pixel;
	zval *fmt;
	zval *r;
	zval *g;
	zval *b;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lzzzz", &pixel,&fmt,&r,&g,&b)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				Uint8 r1,g1,b1;				
				SDL_PixelFormat *f;
				zval *handle;
				if (!getArrayValueByString(*fmt,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(f,SDL_PixelFormat *,&handle,-1,le_pixelformat_name,le_pixelformat);
			 	SDL_GetRGB(pixel, f, &r1, &g1, &b1);
			 	ZVAL_LONG(r,r1);
			 	ZVAL_LONG(g,g1);
			 	ZVAL_LONG(b,b1);			 	
			
	}
}
PHP_FUNCTION(sdl_getrgba) {
	long pixel;
	zval *fmt;
	zval *r;
	zval *g;
	zval *b;
	zval *a;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lzzzzz", &pixel,&fmt,&r,&g,&b,&a)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				Uint8 r1,g1,b1,a1;
				SDL_PixelFormat *f;
				zval *handle;
				if (!getArrayValueByString(*fmt,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(f,SDL_PixelFormat *,&handle,-1,le_pixelformat_name,le_pixelformat);
			 	SDL_GetRGBA(pixel, f, &r1, &g1, &b1, &a1);
			 	ZVAL_LONG(r,r1);
			 	ZVAL_LONG(g,g1);
			 	ZVAL_LONG(b,b1);
			 	ZVAL_LONG(a,a1);
			
	}
}
PHP_FUNCTION(sdl_creatergbsurface) {
	int flags;
	int width;
	int height;
	int depth;
	int Rmask;
	int Gmask;
	int Bmask;
	int Amask;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llllllll", &flags,&width,&height,&depth,&Rmask,&Gmask,&Bmask,&Amask)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Surface *surf;
				surf=SDL_CreateRGBSurface(flags, width, height, depth, Rmask, Gmask, Bmask, Amask);
				if (!surf) { mysdl_error("couldnt create surface"); RETURN_FALSE; }
				surf2array(surf,return_value TSRMLS_CC);
			
	}
}
PHP_FUNCTION(sdl_creatergbsurfacefrom) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_freesurface) {
	zval *surf;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &surf)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Surface *s;
				SDL_PixelFormat *f;
				zval *handle,*format;				
				int handle1;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
				handle1=Z_LVAL_P(handle);				
				ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	zend_list_delete(handle1);
				if (!getArrayValueByString(*surf,"format",&format)) {
					RETURN_FALSE;
				}
				if (!getArrayValueByString(*format,"handle",&handle)) {
					RETURN_FALSE;
				}
				handle1=Z_LVAL_P(handle);
			 	ZEND_FETCH_RESOURCE(f,SDL_PixelFormat *,&handle,-1,le_pixelformat_name,le_pixelformat);
			 	zend_list_delete(handle1);
			 	SDL_FreeSurface(s);
				
			
	}
}
PHP_FUNCTION(sdl_locksurface) {
	zval *surf;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &surf)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	ZVAL_LONG(return_value,SDL_LockSurface(s));
			
	}
}
PHP_FUNCTION(sdl_unlocksurface) {
	zval *surf;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &surf)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	SDL_UnlockSurface(s);
			
	}
}
PHP_FUNCTION(sdl_loadbmp) {
	char *file;
	int file_length;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s", &file,&file_length)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
			SDL_Surface *s;
			s=SDL_LoadBMP(file);
			if (!s) { mysdl_error("couldnt create surface"); RETURN_FALSE; }
			surf2array(s,return_value TSRMLS_C);			
			
	}
}
PHP_FUNCTION(sdl_savebmp) {
	zval *surf;
	char *file;
	int file_length;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zs", &surf,&file,&file_length)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	ZVAL_LONG(return_value,SDL_SaveBMP(s,file));
			
	}
}
PHP_FUNCTION(sdl_setcolorkey) {
	zval *surf;
	long flag;
	long key;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zll", &surf,&flag,&key)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
				ZVAL_LONG(return_value,SDL_SetColorKey(s,flag,key));			
			
	}
}
PHP_FUNCTION(sdl_setalpha) {
	zval *surf;
	long flag;
	long alpha;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zll", &surf,&flag,&alpha)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
				ZVAL_LONG(return_value,SDL_SetColorKey(s,flag,alpha));			
			
	}
}
PHP_FUNCTION(sdl_setcliprect) {
	zval *surf;
	zval *rect;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &surf,&rect)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Surface *s;
				SDL_Rect r;				
				zval *handle1,*handle2;

				if (!getArrayValueByString(*surf,"handle",&handle1)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle1,-1,le_surface_name,le_surface);

				/* to go on */
				/* search for x,y,w,h in array rect. */			
				array2rect(*rect,&r);

				SDL_SetClipRect(s, &r);

				if (!getArrayValueByString(*surf,"clip_rect",&handle2)) {
					RETURN_FALSE;
				}
				rect2array((SDL_Rect)s->clip_rect,handle2);
				add_assoc_long(handle2,"x",s->clip_rect.x);
				add_assoc_long(handle2,"y",s->clip_rect.y);				
				add_assoc_long(handle2,"w",s->clip_rect.w);				
				add_assoc_long(handle2,"h",s->clip_rect.h);				
			
	}
}
PHP_FUNCTION(sdl_getcliprect) {
	zval *surf;
	zval *rect;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &surf,&rect)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Rect r;
				zval *handle;
				SDL_Surface *s;
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
				SDL_GetClipRect(s,&r);
				array_init(rect);
				add_assoc_long(rect,"x",r.x);
				add_assoc_long(rect,"y",r.y);
				add_assoc_long(rect,"w",r.w);
				add_assoc_long(rect,"h",r.h);
			
	}
}
PHP_FUNCTION(sdl_convertsurface) {
	zval *surf;
	zval *pf;
	int flags;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzl", &surf,&pf,&flags)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
			
				SDL_Surface *s,*d;
				SDL_PixelFormat *f;				
				zval *handle1,*handle2;				
				if (!getArrayValueByString(*surf,"handle",&handle1)) {
					RETURN_FALSE;
				}
				ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle1,-1,le_surface_name,le_surface);
				if (!getArrayValueByString(*pf,"handle",&handle2)) {
					RETURN_FALSE;
				}
			 	ZEND_FETCH_RESOURCE(f,SDL_PixelFormat *,&handle2,-1,le_pixelformat_name,le_pixelformat);
			 	d=SDL_ConvertSurface(s,f,flags);
				surf2array(d,return_value TSRMLS_CC); 	
			
	}
}
PHP_FUNCTION(sdl_blitsurface) {
	zval *src;
	zval *srcrect;
	zval *dst;
	zval *dstrect;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzzz", &src,&srcrect,&dst,&dstrect)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Surface *s,*d;
				SDL_Rect sr,dr;
				zval *handle;				
				int srcrect_null, dstrect_null;
				if (!getArrayValueByString(*src,"handle",&handle)) {
					RETURN_FALSE;
				}
				ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
				if (!getArrayValueByString(*dst,"handle",&handle)) {
					RETURN_FALSE;
				}
				ZEND_FETCH_RESOURCE(d,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
				srcrect_null=(Z_TYPE_P(srcrect)==IS_ARRAY)?0:1;
				dstrect_null=(Z_TYPE_P(dstrect)==IS_ARRAY)?0:1;
				if (dstrect_null==0) {
					array2rect(*dstrect,&dr);
				}
				if (srcrect_null==0) {
					array2rect(*srcrect,&sr);
				}
				RETURN_LONG(SDL_BlitSurface(s, (srcrect_null) ? NULL : &sr, d, (dstrect_null) ? NULL : &dr));
			
	}
}
PHP_FUNCTION(sdl_fillrect) {
	zval *surf;
	zval *rect;
	int color;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzl", &surf,&rect,&color)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Surface *s;
				zval *handle;				
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
				ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);

			
	}
}
PHP_FUNCTION(sdl_displayformat) {
	zval *surf;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &surf)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Surface *s,*d;
				zval *handle;				
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
				ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	d=SDL_DisplayFormat(s);
			 	if (!d) {
					php_error(E_WARNING, "%s() unable to create new surface: %s",
						get_active_function_name(TSRMLS_C),SDL_GetError());			 	
					RETURN_FALSE;
			 	}
				surf2array(d,return_value TSRMLS_CC);
			
	}
}
PHP_FUNCTION(sdl_displayformatalpha) {
	zval *surf;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &surf)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Surface *s,*d;
				zval *handle;				
				if (!getArrayValueByString(*surf,"handle",&handle)) {
					RETURN_FALSE;
				}
				ZEND_FETCH_RESOURCE(s,SDL_Surface *,&handle,-1,le_surface_name,le_surface);
			 	d=SDL_DisplayFormatAlpha(s);
			 	if (!d) {
					php_error(E_WARNING, "%s() unable to create new surface: %s",
						get_active_function_name(TSRMLS_C),SDL_GetError());			 	
					RETURN_FALSE;
			 	}
				surf2array(d,return_value TSRMLS_CC);			
			
	}
}
PHP_FUNCTION(sdl_warpmouse) {
	int x;
	int y;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll", &x,&y)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		SDL_WarpMouse(x,y);
	}
}
PHP_FUNCTION(sdl_createcursor) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_freecursor) {
	zval *cursor;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &cursor)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Cursor *c;
				zval *handle;				
				if (!getArrayValueByString(*cursor,"handle",&handle)) {
					RETURN_FALSE;
				}
				ZEND_FETCH_RESOURCE(c,SDL_Cursor *,&handle,-1,le_cursor_name,le_cursor);
				SDL_FreeCursor(c);
				zend_list_delete(Z_LVAL_P(cursor));
			
	}
}
PHP_FUNCTION(sdl_setcursor) {
	zval *cursor;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &cursor)==FAILURE) { 
		/* manage error */ 
	} else {
		/* manage ok */
		
				SDL_Cursor *c;
				zval *handle;				
				if (!getArrayValueByString(*cursor,"handle",&handle)) {
					RETURN_FALSE;
				}
				ZEND_FETCH_RESOURCE(c,SDL_Cursor *,&handle,-1,le_cursor_name,le_cursor);
				SDL_FreeCursor(c);

			
	}
}
PHP_FUNCTION(sdl_getcursor) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_showcursor) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_gl_loadlibrary) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_gl_getprocaddress) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_gl_getattribute) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_gl_setattribute) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_gl_swapbuffers) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_createyuvoverlay) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_lockyuvoverlay) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_unlockyuvoverlay) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_displayyuvoverlay) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_freeyuvoverlay) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_getpixels) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
PHP_FUNCTION(sdl_putpixels) {
php_error(E_WARNING, "function %s() not implemented",get_active_function_name(TSRMLS_C));
}
#ifdef HAVE_SDL_SMPEG
PHP_FUNCTION(XX) {
ZVAL_LONG(return_value,XX(flags));
}
#endif

/*******************************
 * End Functions Code
 *******************************/