<?
include_once("test.php");

function waitKeyQ() {
	$ended=0;
	while ($ended==0) {
		while (SDL_PollEvent(&$event)) {
			switch($event["type"]) {					
			case SDL_QUIT:
				echo "SDL_Quit received, quitting\n";
				$ended=1;
				break;
			case SDL_KEYDOWN:
				$keysym=$event["key"]["keysym"]["sym"];
				if ($keysym==SDLK_q) {
					echo "Q pressed, quitting\n";
					$ended=1;
				}
				break;
			}
		}
	}

}
dl('sdl.so');
class test_v001 extends test{
	function do_test($idx) {
		switch($idx) {
		case 1:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			print_r($screen);
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;
			
		case 2:		
			echo "Starting\n";
			echo "Pressing Q to exit\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_SWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);
			function drawRect($s,$x,$y,$w,$h,$r,$g,$b,$a) {
				$f=$s["format"];
				$c=SDL_MapRGBA($f,$r,$g,$b,$a);
				$rect=array(
					"x"=>$x,"y"=>$y,"w"=>$w,"h"=>$h
				);
				SDL_FillRect($s,$rect,$c);				
				SDL_UpdateRect($s,$x,$y,$w,$h);
			}

			drawRect($screen,100,100,50,50,255,0,0,0);
			drawRect($screen,100,150,50,50,0,255,0,0);
			drawRect($screen,100,200,50,50,0,0,255,0);			

			drawRect($screen,150,100,50,50,255,0,0,0);
			drawRect($screen,150,150,50,50,255,255,0,0);
			drawRect($screen,150,200,50,50,255,0,255,0);						

			drawRect($screen,200,100,50,50,255,255,0,0);
			drawRect($screen,200,150,50,50,255,255,0,0);
			drawRect($screen,200,200,50,50,255,255,255,0);			
			
			waitKeyQ();
			
			$ret=SDL_Quit();
			break;						
							
		case 3:		
			echo "Starting\n";
			echo "Pressing Q to exit\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_SWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);
			$img=SDL_LoadBMP("contrib/prova.bmp");
			print_r($img);
			$ended=0;
			$r=$img["clip_rect"];
			$r["x"]=50;
			$r["y"]=50;			
			
			SDL_BlitSurface($img,$img["cliprect"],$screen,$r);
			SDL_UpdateRect($screen,0,0,800,600);			
			
			waitKeyQ();
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;
			
		case 4:
			echo "Starting, opening 800x600, 32bit and closing it\n";			
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_SWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);
			echo "Print structure\n";						
			print_r($screen);
			echo "Using SDL_GetVideoSurface()\n";
			$s=SDL_GetVideoSurface();
			echo "Print structure\n";						
			print_r($s);
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;
			
		case 5:
			echo "Starting, opening 800x600, 32bit and closing it\n";			
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_SWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);
			echo "Using SDL_GetVideoInfo()\n";
			$s=SDL_GetVideoInfo();
			echo "Print structure\n";						
			print_r($s);
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;
					
		case 6:
			echo "Starting, opening 800x600, 32bit and closing it\n";			
			SDL_Init(SDL_INIT_VIDEO);
			echo "getting SDL_VideoDriverName()\n";
			$s=SDL_VideoDriverName();
			echo "VideoDriverName:[$s]\n";						
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;				
		
		case 7:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			echo "getting SDL_ListModes()\n";
			$flags=SDL_SWSURFACE;			
			$format["BitsPerPixel"]=32;
			$s=SDL_ListModes($format,$flags);			
			echo "ListModes:\n";						
			print_r($s);
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;				

		case 8:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			echo "getting SDL_ListModes()\n";
			$flags=SDL_SWSURFACE;			
			$format["BitsPerPixel"]=32;
			$s=SDL_ListModes(NULL,$flags);	
			echo "ListModes:\n";			
			if ($s==-1) echo "All Modes available\n";
			else 			
				print_r($s);
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;		

		case 9:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			echo "Calling SDL_VideoModeOk\n";			
			$s=SDL_VideoModeOK(640, 480, 16, SDL_HWSURFACE);
			if (!$s) 
				echo "Mode not available";
			else 
				echo "Mode available, BPP suggested: $s\n";
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;		

		case 10:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			echo "Calling SDL_GetGammaRamp\n";			
			$flags=SDL_SWSURFACE;			
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$s=SDL_GetGammaRamp(&$r,&$g,&$b);
			var_dump($s);
			var_dump($r);
			var_dump($g);			
			var_dump($b);			
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;		
		case 11:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			echo "Calling SDL_CreateRGBSurface\n";			
			$Rmask = 0x000000ff;
			$Gmask = 0x0000ff00;
			$Bmask = 0x00ff0000;
			$Amask = 0xff000000;
			$flags=SDL_SWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);			
			$surf1=SDL_CreateRGBSurface(SDL_SRCALPHA,128,128,32,$Rmask,$Gmask,$Bmask,$Amask);
			
			function drawRect($s,$x,$y,$w,$h,$r,$g,$b,$a) {
				$f=$s["format"];
				$c=SDL_MapRGBA($f,$r,$g,$b,$a);
				$rect=array(
					"x"=>$x,"y"=>$y,"w"=>$w,"h"=>$h
				);
				SDL_FillRect($s,$rect,$c);				
				SDL_UpdateRect($s,$x,$y,$w,$h);
			}
			drawRect($surf1,10,10,50,50,255,0,0,255);
			SDL_BlitSurface($surf1,$surf1["clip_rect"],$screen,$surf1["clip_rect"]);			
			SDL_UpdateRect($screen,0,0,640,480);			
			var_dump($surf1);

			waitKeyQ();
			$ret=SDL_Quit();						
			echo "Quitting\n";
			
			break;		

		case 12:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			echo "Saving screen to bmp (out.bmp)\n";			
			$flags=SDL_SWSURFACE;			
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);

			function drawRect($s,$x,$y,$w,$h,$r,$g,$b,$a) {
				$f=$s["format"];
				$c=SDL_MapRGBA($f,$r,$g,$b,$a);
				$rect=array(
					"x"=>$x,"y"=>$y,"w"=>$w,"h"=>$h
				);
				SDL_FillRect($s,$rect,$c);				
				SDL_UpdateRect($s,$x,$y,$w,$h);
			}

			for ($i=0;$i<256;$i++) {
				drawRect($screen,$i,0,1,100,$i,0,0,255);
				drawRect($screen,$i,100,1,100,0,$i,0,255);
				drawRect($screen,$i,200,1,100,0,0,$i,255);
			}
			SDL_UpdateRect($screen,0,0,640,480);
			SDL_SaveBMP($screen,"out.bmp");
			$ret=SDL_Quit();			
			// a5d4faea0f231f70ce50407c8feb9f5f (out.bmp)
			echo "Quitting\n";
			break;		

		case 13:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_SWSURFACE;			
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$f=$screen["format"];
			$x1=SDL_MapRGBA($f,0xab,0xcd,0xef,255);
			$x=SDL_GetRGBA($x1,$f,&$r,&$g,&$b,&$a);
			echo "MapRGBA(0xab,0xcd,0xef,255)-> GetRGBA -> [$r|$g|$b|$a]\n";
			echo "X1:".sprintf("%X\n",$x1);
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;		

		case 14:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_SWSURFACE;			
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$f=$screen["format"];
			$x1=SDL_MapRGB($f,0xab,0xcd,0xef);
			$x=SDL_GetRGB($x1,$f,&$r,&$g,&$b);
			echo "MapRGB(0xab,0xcd,0xef)-> GetRGB -> [$r|$g|$b]\n";
			echo "X1:".sprintf("%X\n",$x1);
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;		
			
		case 15:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_SWSURFACE;			
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);

			function drawRect($s,$x,$y,$w,$h,$r,$g,$b,$a) {
				$f=$s["format"];
				$c=SDL_MapRGBA($f,$r,$g,$b,$a);
				$rect=array(
					"x"=>$x,"y"=>$y,"w"=>$w,"h"=>$h
				);
				SDL_FillRect($s,$rect,$c);				
				//SDL_UpdateRect($s,$x,$y,$w,$h);
			}
			drawRect($screen,0,0,640,480,255,0,0,255);
			$rects[]=array(
				"x"=>50,"y"=>50,"w"=>100,"h"=>100
			);
			$rects[]=array(
				"x"=>200,"y"=>50,"w"=>100,"h"=>100
			);
			$ret=SDL_UpdateRects($screen,2,$rects);
			print_r($ret);
			waitKeyQ();			
			$ret=SDL_Quit();			
			echo "Quitting\n";
			break;

		case 16:
			echo "Starting\n";		
			SDL_Init(SDL_INIT_VIDEO);
			echo "Calling SDL_CreateRGBSurfaceFrom\n";			
			$Rmask = 0x000000ff;
			$Gmask = 0x0000ff00;
			$Bmask = 0x00ff0000;
			$Amask = 0xff000000;
			$flags=SDL_SWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);			
			$buffer=str_repeat(chr(0),256*128*4);
			
			for ($x=0;$x<256;$x++) {
				for ($y=0;$y<128;$y++) {
					$off=$x+$y*256;
					$buffer[$off*4]=chr(0xff);
					$buffer[$off*4+1]=chr(0x00+$y*2);
					$buffer[$off*4+2]=chr(0x00+$x);
					$buffer[$off*4+3]=chr(0xff);
				}
			}
			$surf1=SDL_CreateRGBSurfaceFrom(&$buffer,256,128,32,256*4,$Rmask,$Gmask,$Bmask,$Amask);

			SDL_BlitSurface($surf1,$surf1["clip_rect"],$screen,$surf1["clip_rect"]);
			SDL_UpdateRect($screen,0,0,640,480);			
			var_dump($surf1);

			waitKeyQ();
			$ret=SDL_Quit();						
			echo "Quitting\n";
			
			break;		


		}
	}
	function get_test_list() {
		return array(
			1=>"sdl_setvideomode and quit",
			2=>"blitting rects and  quit",
			3=>"blitting bmp image and quit",
			4=>"getvideosurface test",
			5=>"getvideoinfo test",
			6=>"getvideodriver test",
			7=>"listmodes test",																						
			8=>"listmodes test 2",
			9=>"videomodeok test",
			10=>"getgammaramp test",
			11=>"creatergbsurface test",
			12=>"savebmp test",						
			13=>"maprgba/getrgba test",						
			14=>"maprgb/getrgb test",						
			15=>"updaterects test",						
			16=>"creatergbsurfacefrom test",
		);
	}
}
?>
