#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "phtml_parse.h"

#define fatal(reason) do { fputs(reason,stderr); abort(); } while(0)

void output_string(int type, size_t len, char *string, void *ignore);

int simplify=0;

int
main (int argc, char *argv[]) {
  if ( argc > 1 )
    if ( strcmp (argv[1], "--simplify") )
	 simplify=1;

#ifdef PHTML_DEBUG
  phtmlparse_file(stdin, 
		       LEX_PHP | LEX_ASP_TAG | LEX_SHORT_TAG | LEX_DEBUG 
		       | LEX_OUTPUT_ERRORS | LEX_FATAL_ERRORS,
		       &output_string, NULL);
#else
  phtmlparse_file(stdin, 
		       LEX_PHP | LEX_ASP_TAG | LEX_SHORT_TAG 
		       | LEX_OUTPUT_ERRORS | LEX_FATAL_ERRORS,
		       &output_string, NULL);
#endif
  exit(0);
}
int last_type=-1;
void
output_string(int type, size_t len, char *string, void *ignore) {
  char *desc=0;
  if( simplify ) {
    if(phtmlparse_is_script (type))
      type = SCRIPT;
    if(phtmlparse_is_text (type)) 
      type = TEXT;
  }
  if (type != last_type) {
    switch (type) {
    case TEXT:  desc="***HTML text\n"; break;
    case SCRIPT: desc="***Embedded Script\n"; break;
    case SCRIPT_START: desc="***Script Start Token\n"; break;
    case SCRIPT_END: desc="***Script End Token\n"; break;
    case QUOTE : desc="***Script Single Quote Mark\n"; break;
    case QQUOTE : desc="***Script Double Quote Mark\n"; break;
    case HERE_START : desc="***Script start of a here document\n"; break;
    case HERE_STOP : desc="***Script end of a here docuement\n"; break;
    case HSTRING : desc="***Script here document\n"; break;
    case STRING : desc="***Script Single Quoted String\n"; break;
    case SSTRING : desc="***Script Double Quoted String\n"; break;
    case COMMENT : desc="***Script Comment\n"; break; 
    case END_FILE : desc="" ; break; /* no text at EOF */
    }
    if ( (last_type != -1) && (type != END_FILE) )
      putchar('\n'); 
    if (desc == 0) {
      /* we should have covered all cases */
      fprintf (stderr, "internal error 2: unknown parse type (%d)\n", type);
      abort ();
    }
    fputs(desc,stdout);
    last_type = type;
  }
  if ( ! fwrite (string,1,len,stdout) == len ) {
    fatal ("write failed");
  }	;
}


