/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef ANIMATEDMESH_H
#define ANIMATEDMESH_H

#include "mesh.h"
#include "include.h"

class CAnimatedMesh : public CMesh
{
public:
	CAnimatedMesh(	index_t nvertices,
					const index_t *indices, 
					index_t nindices);

	virtual ~CAnimatedMesh(void);

	void AddFrame(double frame,const float *vertices,const float *texcoords=NULL,const float *normals=NULL);
	
	virtual int Draw(int pass,double frame,pMaterial force = NULL);
	virtual int DrawShadowVolume(double frame,const CVector3 &light,bool directional);
	virtual float Intersect(double frame,const CCoord3 &pos,const CVector3 &move,float radius,CCoord3 *intersection);

private:
	typedef std::map<double,float *> KeyMap_t;
	
	void BuildFrame(double frame);
	void Interpolate(const KeyMap_t &keymap,double frame,float *buffer,index_t size);

	virtual void EnableShadowVolume(void);
	
	KeyMap_t mVertexKeyMap;
	KeyMap_t mNormalKeyMap;
	KeyMap_t mTexCoordKeyMap;

	double mCurrentFrame;
};

typedef CSmartPtr<CAnimatedMesh> pAnimatedMesh;

#endif

