/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef BUFFER_H
#define BUFFER_H

#include "bufferbase.h"
#include "exception.h"
#include "smartptr.h"
#include "include.h"

// Classe Buffer
// Encapsule un IBufferBase, permet de typer les donnes stockes
template<typename T>
class CBuffer : public IRefCount
{
public:
	CBuffer(CSmartPtr<IBufferBase> buffer);							// Constructeur (prend le buffer  encapsuler)
	virtual ~CBuffer(void);											// Destructeur
	size_t getCount(void) const;									// retourne le nombre d'lments
	
	void *Bind(void);												// Attache
	void Unbind(void);												// Dtache
	void *Offset(size_t offset=0);									// Offset en pointeur
	void Fill(const T *ptr,size_t nbr,GLenum usage=GL_STATIC_DRAW);	// remplit le buffer
	void Replace(size_t offset,const T *ptr,size_t nbr);			// remplace une zone
	T *Lock(size_t offset,size_t nbr,GLenum access=GL_READ_ONLY);	// verrouille le buffer pour accs
	void Unlock(void);												// dverrouille le buffer

	void Add(const T *ptr,size_t nbr,GLenum usage=GL_STATIC_DRAW);	// Ajoute des donnes  la suite

protected:
	CSmartPtr<IBufferBase> mBuffer;		// buffer encapsul
	size_t mCount;						// nombre d'lments dans le buffer
};

#include "buffer.inl"

#endif
