/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef BUFFERARRAY_H
#define BUFFERARRAY_H

#include "bufferbase.h"
#include "include.h"

// Classe CBufferArray
// Un IBufferBase stock en mmoire
class CBufferArray : public IBufferBase
{
public:
	CBufferArray(void);
	~CBufferArray(void);
	
	void *Bind(void);
	void Unbind(void);
	void *Offset(size_t offset);
	void Fill(const void *ptr,size_t size,GLenum usage=GL_STATIC_DRAW);
	void Replace(size_t offset,const void *ptr,size_t size);
	void *Lock(size_t offset,size_t size,GLenum access=GL_READ_ONLY);
	void Unlock(void);
 
private:
	char *mBuffer;
};

#endif
