/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef BUFFEROBJECT_H
#define BUFFEROBJECT_H

#include "bufferbase.h"
#include "include.h"

// Classe CBufferObject
// Un IBufferBase stock directement dans la carte graphique
// Prend en template le type de buffer OpenGL
template<GLenum T>
class CBufferObject : public IBufferBase
{
public:
	CBufferObject(void);
	~CBufferObject(void);

	void *Bind(void);
	void Unbind(void);
	void *Offset(size_t offset);
	void Fill(const void *ptr,size_t size,GLenum usage=GL_STATIC_DRAW);
	void Replace(size_t offset,const void *ptr,size_t size);
	void *Lock(size_t offset,size_t size,GLenum access=GL_READ_ONLY);
	void Unlock(void);

private:
	GLuint mVBO;
};

// Les deux types de CBufferObject possibles
typedef CBufferObject<GL_ELEMENT_ARRAY_BUFFER>	CIndexBufferObject;
typedef CBufferObject<GL_ARRAY_BUFFER>			CDataBufferObject;

#include "bufferobject.inl"

#endif
