/***************************************************************************
 *   Copyright (C) 2006 by Paul-Louis Ageneau                              *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// Constructeur
template<GLenum T>
CBufferObject<T>::CBufferObject(void)
{
	glGenBuffersARB(1,&mVBO);				// Rcupre un nom pour le buffer
}

// Destructeur
template<GLenum T>
CBufferObject<T>::~CBufferObject(void)
{
	glDeleteBuffersARB(1,&mVBO);			// Dtruit le buffer
}

template<GLenum T>
void *CBufferObject<T>::Bind(void)
{
	glBindBufferARB(T,mVBO);			// attache le buffer
	return NULL;
}

template<GLenum T>
void CBufferObject<T>::Unbind(void)
{
	glBindBufferARB(T,0);				// dtache le buffer
}

template<GLenum T>
void *CBufferObject<T>::Offset(size_t offset)
{
	return reinterpret_cast<void*>(offset);
}

// remplit le buffer
template<GLenum T>
void CBufferObject<T>::Fill(const void *ptr,size_t size,GLenum usage)
{
	mSize=size;
	glBindBufferARB(T,mVBO);				// attache le buffer
	glBufferDataARB(T,size,ptr,usage);		// remplit
}

// remplace une zone du buffer
template<GLenum T>
void CBufferObject<T>::Replace(size_t offset,const void *ptr,size_t size)
{
	glBindBufferARB(T,mVBO);				// attache le buffer
	glBufferSubDataARB(T,offset,size,ptr);
}

// verrouille
template<GLenum T>
void *CBufferObject<T>::Lock(size_t offset,size_t size,GLenum access)
{
	glBindBufferARB(T,mVBO);				// attache le buffer
	void *ptr = glMapBufferARB(T,access);	// mappe le buffer

	if(ptr) return ptr;
	else throw CGlError();
}

// dverrouille
template<GLenum T>
void CBufferObject<T>::Unlock(void)
{
	glUnmapBufferARB(T);
}
