/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "camera.h"
#include "sound.h"

pCamera CCamera::Current = NULL;
pCamera CCamera::Default = new COrthoCamera();

CCamera::CCamera(void)
{ 
	mNear=1.0f;
	mFar=1000.0f;
	mFov=45.0f; 
}

CCamera::~CCamera(void)
{

}

void CCamera::setRange(float dnear,float dfar)
{
	mNear=dnear;
	mFar=dfar;
}

void CCamera::setFov(float angle)
{ 
	mFov=angle;
}

void CCamera::Clear(const CColor &color) const
{
	glClearColor(color.r,color.g,color.b,color.a);
	glClear(GL_COLOR_BUFFER_BIT);
}

void CCamera::Apply(void)
{
	Current = this;
	
	int width,height;
	glfwGetWindowSize(&width,&height);
	glViewport(0,0,width,height);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(mFov,double(width)/double(height),mNear,mFar);
	
	glMatrixMode(GL_MODELVIEW);
	getGlobalMatrix().Inverse().Load();

	// Efface le z-buffer et le stencil
	glDepthMask(GL_TRUE);
	glClear(GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT);
}

COrthoCamera::COrthoCamera(void)
{
	mLeft=0.f;
	mRight=1280.f;
	mDown=0.f;
	mUp=1024.f;

	mNear=-1000.f;
	mFar=1000.f;
}

COrthoCamera::~COrthoCamera(void)
{

}

void COrthoCamera::setOrtho(float left,float right,float down,float up)
{
	mLeft=left;
	mRight=right;
	mDown=down;
	mUp=up;
}

void COrthoCamera::Apply(void)
{
	Current = this;
	
	int width,height;
	glfwGetWindowSize(&width,&height);
	glViewport(0,0,width,height);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(mLeft,mRight,mDown,mUp,mNear,mFar);
	
	glMatrixMode(GL_MODELVIEW);
	getGlobalMatrix().Inverse().Load();

	// Efface le buffer de profondeur
	glDepthMask(GL_TRUE);
	glClear(GL_DEPTH_BUFFER_BIT);
}
