/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef CAMERA_H
#define CAMERA_H

#include "color.h"
#include "smartptr.h"
#include "include.h"

class CCamera;
typedef CSmartPtr<CCamera> pCamera;

#include "entity.h"

// TODO: rarrangement des classe cameras

// Classe Camera
// Entite reprensentant une camra
class CCamera : public CEntity
{
public:
	CCamera(void);				// Constructeur
	virtual ~CCamera(void);		// Destructeur

	static pCamera Current;
	static pCamera Default;		// Camera par dfault: orthogonale, utilise pour la 2D
	
	void setRange(float dnear,float dfar);
	void setFov(float angle);

	void Clear(const CColor &color) const;
	virtual void Apply(void);

protected:		
	float mNear;	// distance minimale
	float mFar;		// distance maximale
	float mFov;		// angle d'ouverture

	friend class CScene;
};

// Classe OrthoCamera
// Camera avec projection orthogonale
class COrthoCamera : public CCamera
{
public:
	COrthoCamera(void);				// Constructeur
	virtual ~COrthoCamera(void);	// Destructeur

	void setOrtho(float left,float right,float down,float up);
	void Apply(void);

protected:
	float mLeft,mRight,mDown,mUp;

};

typedef CSmartPtr<COrthoCamera> pOrthoCamera;

#endif // CAMERA_H
