/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "color.h"

CColor::CColor(float _r,float _g,float _b,float _a) : r(_r), g(_g), b(_b), a(_a)
{

}

CColor::CColor(int _r,int _g,int _b,int _a) :
	r(float(_r)/255.f), g(float(_g)/255.f), b(float(_b)/255.f), a(float(_a)/255.f)
{

}

CColor::~CColor(void)
{

}


void CColor::set(float _r,float _g,float _b,float _a)
{
	r=_r;
	g=_g;
	b=_b;
	a=_a;
}

void CColor::set(int _r,int _g,int _b,int _a)
{
	r=float(_r)/255.f;
	g=float(_g)/255.f;
	b=float(_b)/255.f;
	a=float(_a)/255.f;
}

void CColor::Display(void) const
{
	glColor4f(r,g,b,a);
}

CColor &CColor::operator*=(float f)
{
	r*=f;
	g*=f;
	b*=f;
	return (*this);
}

CColor CColor::operator*(float f)
{
	return CColor(r*f,g*f,b*f,a);
}

// cast en const float*
CColor::operator const float*() const
{
    return &r;
}

// cast en float*
CColor::operator float*()
{
    return &r;
}
