/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "directionallight.h"

// Constructeur
 CDirectionalLight::CDirectionalLight(void)
{

}

// Destructeur
 CDirectionalLight::~CDirectionalLight(void)
{

}

bool CDirectionalLight::isDirectional(void)
{
	return true;
}

int CDirectionalLight::Draw(int pass)
{
	if(pass != 0) return 0;
	if(mCastShadow) CScene::Current->RegisterShadowLight(this);
	
	int num=GL_LIGHT0+currentLightNum;
	
	glEnable(num);

	float direc[4]={0.f,0.f,0.f,0.f};
	*reinterpret_cast<CVector3*>(direc)=getGlobalMatrix().getAxisZ();
	glLightfv(num,GL_POSITION,direc);

	glLightfv(num,GL_AMBIENT,mAmbient);
	glLightfv(num,GL_DIFFUSE,mDiffuse);
	glLightfv(num,GL_SPECULAR,mSpecular);

	++currentLightNum;
	return 0;
}
