/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef PARTICLES_H
#define PARTICLES_H

#include "material.h"
#include "entity.h"
#include "particle.h"
#include "scene.h"
#include "smartptr.h"
#include "include.h"

// classe reprsentant un metteur de particules
class CEmitter : public CEntity
{
public:
	CEmitter(void);
	virtual ~CEmitter(void);

	void setMaterial(pMaterial material);
	
	void setFrequency(float frequency);
	void setSpeed(const CVector3 &speed,const CVector3 &random,bool relative=true);
	void setPartLife(float life,float random);
	void setFriction(const CVector3 &friction,bool relative=false);
	void setPartSize(float x,float y);
	void setPartRotation(float speed,bool random);
	
	pParticle CreateParticle(void);
	
	virtual void Parameter(const std::string &param,const std::string &data);
	virtual bool Update(double time);

	// Les infos sur l'mission
	float 		mFrequency;		// frquence d'mission
	CVector3	mStartSpeed;		// vitesse d'mission (par seconde)
	CVector3	mRandomSpeed;		// alatoire absolu max pour la vitesse d'mission
	float		mStartLife;		// vie des particules au dpart (secondes)
	float		mRandomLife;		// alatoire absolu max pour la vie
	CVector3	mFriction;			// friction (par seconde)
	CVector3	mGlobalFriction;
	float		mSizex,mSizey;	// taille des particules
	float		mRotSpeed;		// rotation des particules
	bool 		mIsRotRandom;		// rotation Z alatoire
	bool		mIsRelativeSpeed;
	bool		mIsRelativeFriction;

	pMaterial	mMaterial;			// matriau

private:
	float		mCooldown;			// reste temporel
	CCoord3		mOldPos;
	friend class CScene;
};

typedef CSmartPtr<CEmitter> pEmitter;
typedef CEmitter CPointEmitter;
typedef CSmartPtr<CPointEmitter> pPointEmitter;

/*
class CBoxEmitter : public CEmitter
{
public:
	CBoxEmitter(const CBox &box);
	~CBoxEmitter(void);

	void setBox(const CBox &box);

private:
	Box _Box;

	pParticle CreateParticle(void);

};

typedef SmartPtr<BoxEmitter> pBoxEmitter;
*/

#endif // PARTICLES_H
