/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "exception.h"

// Constructeur
CException::CException(const std::string& Message) :
mMessage(Message)
{

}

// Destructeur
CException::~CException() throw()
{

}

// Renvoie le message associ  l'exception
const char* CException::what() const throw()
{
    return mMessage.c_str();
}


CAssertException::CAssertException(const std::string& File, int Line, const std::string& Message)
{
	std::stringstream msg;
	msg<<Message<<" dans "<<File<<" ligne "<<Line;

	mMessage=msg.str();
}

CLoadingFailed::CLoadingFailed(const std::string& File, const std::string& Message)
{
	std::stringstream msg;
	msg<<"Erreur lors du chargement de "<<File<<" : "<<Message;

	mMessage=msg.str();
}

CUnsupported::CUnsupported(const std::string& Feature)
{
	std::stringstream msg;
	msg<<"Fonctionnalit non supporte : "<<Feature;

	mMessage=msg.str();
}

COutOfMemory::COutOfMemory(void) :
CException("Mmoire insuffisante")
{

}

CDivideByZero::CDivideByZero(void) :
CException("Division par zro")
{
	
}

CGlError::CGlError(void)
{
	mMessage = "Erreur OpenGL: ";
	switch(glGetError())
	{
	case GL_INVALID_ENUM:		mMessage+="spcification invalide";	break;
	case GL_INVALID_VALUE:		mMessage+="paramtre invalide";		break;
	case GL_INVALID_OPERATION:	mMessage+="opration invalide";		break;
	case GL_STACK_OVERFLOW:		mMessage+="dbordement de la pile";	break;
	case GL_STACK_UNDERFLOW:	mMessage+="la pile est vide";		break;
	case GL_OUT_OF_MEMORY:		mMessage+="mmoire insuffisante";	break;
	default:					mMessage+="erreur inconnue";		break;
	}
}
