/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef FRUSTUM_H
#define FRUSTUM_H

#include "plane.h"
#include "vector3.h"
#include "smartptr.h"
#include "include.h"

class CFrustum : public IRefCount
{
public:
	CFrustum(void);
	~CFrustum(void);
	
	void Extract();
	
	bool PointInFrustum(const CCoord3 &p) const;
	bool SphereInFrustum(const CCoord3 &centre, float radius) const;
	bool SphereInFrustum(float radius) const;
	bool BoxInFrustum(const CCoord3 &p1,const CCoord3 &p2) const;

private:
	CPlane mPlane[6];

};

typedef CSmartPtr<CFrustum> pFrustum;

#endif
