/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef INCLUDE_H
#define INCLUDE_H

#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <ctime>
#include <cstring>

#include <algorithm>
#include <limits>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
#include <map>
#include <set>
#include <stack>

typedef signed char		sint8_t;	// 8 bits
typedef signed short	sint16_t;	// 16 bits
typedef signed int		sint32_t;	// 32 bits

typedef unsigned char	uint8_t;	// 8 bits
typedef unsigned short	uint16_t;	// 16 bits
typedef unsigned int	uint32_t;	// 32 bits

typedef float			float32_t;	// float 32 bits
typedef double			float64_t;	// float 64 bits

#define GLEW_STATIC 1	// linkage statique de GLEW

#if defined(_WIN32) || defined(_WIN64)
	#include "GL/glew.h"
	#include "GL/glfw.h"
#else
	#include <GL/glew.h>
	#include <GL/glfw.h>
#endif

#define PI			3.14159265f
#define PIDIV180	0.01745329f
#define SQRT2		1.41421356f
#define SQRT3		1.73205081f

#define EPSILON		0.001f
#define	INFINI		1000000.f

#define Log	std::cout

#include "exception.h"

// lecture d'un angle de puis un flux
// TODO: prise en charge des radians
inline float getangle(std::istream &in)
{
	float a;
	in>>a;
	return a*PIDIV180;
}

// Diffrence d'angles
inline float diffAngles(float a,float b)
{
	float d = b-a;
	while(d > PI) d-=PI*2;
	while(d <= -PI) d+=PI*2;
	return d;
}

#endif	// INCLUDE_H
