/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "light.h"

int ILight::currentLightNum=0;

// Constructeur
ILight::ILight(void):
	mCastShadow(false),
	mShadowColor(0,0,0,128)
{
	
}

// Destructeur
ILight::~ILight(void)
{

}

void ILight::CastShadow(bool enable,const CColor &color)
{
	mCastShadow = enable;
	mShadowColor = color;
}

bool ILight::isDirectional(void)
{
	return false;
}

void ILight::Parameter(const std::string &param,const std::string &data)
{
	std::stringstream sdata(data);

	if(param == "ambient")				sdata>>mAmbient;
	else if(param == "diffuse")			sdata>>mDiffuse;
	else if(param == "specular")		sdata>>mSpecular;
	else if(param == "shadow")			mCastShadow = (data=="true");
	else if(param == "shadowcolor")		sdata >> mShadowColor;
	else CEntity::Parameter(param,data);
}

int ILight::Reset(void)
{
	// Dsactive toutes les lumires
	for(int i=0;i<=currentLightNum;++i) glDisable(GL_LIGHT0+i);

	int temp=currentLightNum;
	currentLightNum=0;
	return temp;
}
