/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef LIGHT_H
#define LIGHT_H

#include "smartptr.h"

class ILight;
typedef CSmartPtr<ILight> pLight;

#include "entity.h"
#include "color.h"
#include "include.h"

// Classe Light
class ILight : public CEntity
{
public:
	ILight(void);			// Constructeur
	virtual ~ILight(void);	// Destructeur virtuel

	inline void setAmbient(const CColor &color)		{mAmbient = color;}
	inline void setDiffuse(const CColor &color)		{mDiffuse = color;}
	inline void setSpecular(const CColor &color)	{mSpecular = color;}
	
	void CastShadow(bool enable,const CColor &color=CColor(0,0,0,128));
	virtual bool isDirectional(void);
	
	void Parameter(const std::string &param,const std::string &data);
	virtual int Draw(int pass) =0;

	static int Reset(void);

protected:		
	static int currentLightNum;
	
	CColor mAmbient;
	CColor mDiffuse;
	CColor mSpecular;

	bool mCastShadow;
	CColor mShadowColor;

	friend class CScene;
};

#endif	// LIGHT_H
