/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef MATERIAL_H
#define MATERIAL_H

#include "scriptable.h"
#include "texture.h"
#include "resource.h"
#include "color.h"
#include "scriptable.h"
#include "smartptr.h"
#include "include.h"

class CMaterial;
typedef CSmartPtr<CMaterial> pMaterial;

// Classe Materiau
class CMaterial : public IResource, public IScriptable
{  
public:
	static const pMaterial Default;	// Materiau par dfaut
	
	// Constructeur
	CMaterial(void);
	CMaterial(pTexture texture,float alpha=1.f);
	
	// Destructeur
	~CMaterial(void);
	
	void Parameter(const std::string &param,const std::string &data);
	pScriptable Tag(const std::string &tag);
	
	// Couleurs
	inline void setAmbient(const CColor &c)		{mAmbient=c;}
	inline void setDiffuse(const CColor &c)		{mDiffuse=c;}
	inline void setSpecular(const CColor &c)	{mSpecular=c;}
	inline void setEmissive(const CColor &c) 	{mEmissive=c;}
	inline void setShininess(int value) 		{mShininess=value;}
	inline void setAlpha(float alpha) 			{mDiffuse.a=alpha;}
	inline void setAlpha(int alpha) 			{mDiffuse.a=float(alpha)/255.f;}
	
	void setRgbScale(GLuint scale);
	void setTexture(pTexture texture,int level=0);
	void setTextureMode(int level,GLuint mode,GLuint source0=GL_PREVIOUS,GLuint source1=GL_TEXTURE,GLuint source2=GL_TEXTURE);
	
	bool hasBlending(void) const;
	
	bool Bind(int pass=-1,float alpha=1.f,bool repeat = true);
	void Unbind(void);

private:
	CColor	mAmbient;
	CColor	mDiffuse;
	CColor	mSpecular;
	CColor	mEmissive;
	int		mShininess;
	GLint	mRgbScale;
	
	struct TextureHolder_t
	{
		pTexture	Texture;
		GLuint		Mode;
		GLuint		Source[3];
	};

	typedef std::map<int,TextureHolder_t> TexturesMap_t;
	TexturesMap_t mTextures;
};

#endif	// MATERIAL_H

