 /***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "md2loader.h"
#include "mediamanager.h"
#include "resourcemanager.h"
#include "material.h"
#include "texture.h"

float CMd2Loader::mAnorms[162][3] = {
	#include "anorms.h"
};

#define INVALID_TEXCOORD std::numeric_limits<float>::infinity()

// Constructeur
CMd2Loader::CMd2Loader(void)
{

}

// Destructeur
CMd2Loader::~CMd2Loader(void)
{

}
/*
CMesh* CMd2Loader::Load(const std::string &filename)
{
	// Ouverture du fichier
	std::ifstream file;
	file.open(filename.c_str(),std::ios::in|std::ios::binary);
	if(!file.is_open()) throw CLoadingFailed(filename, "Ouverture impossible");
	
	// Lecture de l'en-tte
	md2_header_t header;
	file.read((char*)&header,sizeof(md2_header_t));
	
	// Contrle du magic number et de la version
	if(header.ident!=844121161 || header.version!=8 ) 
	{
		file.close();
		throw CLoadingFailed(filename, "Format invalide ou fichier corrompu");
	}

	CMesh::index_t *vert_indices = new CMesh::index_t[header.nu_faces*3];
	CMesh::index_t *tex_indices = new CMesh::index_t[header.nu_faces*3];
	CMesh::index_t *conv_indices = new CMesh::index_t[header.nu_faces*3];
	float *texcoords = new float[header.nu_tex*2];

	// Lecture des coordonnes de texture
	file.seekg(header.offset_tex);
	for(int i=0; i<header.nu_tex; ++i)
	{
		sint16_t s,t;
		file.read((char*)&s,2);
		file.read((char*)&t,2);
		
		texcoords[i*2]=float(s)/header.skinwidth;
		texcoords[i*2+1]=1.f-float(t)/header.skinheight;
	}
	
	// Lecture des triangles
	file.seekg(header.offset_faces);
	for(int i=0; i<header.nu_faces; ++i)
	{
		uint16_t vert[3];
		uint16_t tex[3]; 
		
		file.read((char*)vert,6);
		file.read((char*)tex,6);

		vert_indices[i*3]=vert[2];
		vert_indices[i*3+1]=vert[1];
		vert_indices[i*3+2]=vert[0];

		tex_indices[i*3]=tex[2];
		tex_indices[i*3+1]=tex[1];
		tex_indices[i*3+2]=tex[0];
	}
	
	float *conv_texcoords = new float[header.nu_faces*6];
	
	// Rarrangement des coordonnes de texture
	for(int i=0; i<header.nu_faces*3; ++i)
	{
			std::copy(texcoords+tex_indices[i]*2,texcoords+tex_indices[i]*2+2,conv_texcoords+i*2);
			conv_indices[i]=i;
	}
	
	delete[] texcoords;
	delete[] tex_indices;
	
	// Cration du mesh
	CAnimatedMesh *mesh = new CAnimatedMesh(header.nu_faces*3,conv_indices,header.nu_faces*3);
	delete[] conv_indices;
	
	mesh->AddFrame(0,NULL,conv_texcoords);
	delete[] conv_texcoords;
	
	float *vertices = new float[header.nu_vert*3];
	float *conv_vertices = new float[header.nu_faces*9];
	
	// Lecture des frames
	file.seekg(header.offset_frames);
	for(int i=0; i<header.nu_frames; ++i)
	{
		float32_t		scale[3];
		float32_t		translate[3];
		char            name[16];

		// Lecture des donnes de la frame
		file.read((char*)scale,12);
		file.read((char*)translate,12);
		file.read((char*)name,16);
		
		std::cout<<scale[0]<<", "<<scale[1]<<", "<<scale[2]<<std::endl;
		
		// Lecture des vertices
		for(int j=0; j<header.nu_vert; ++j)
		{
			uint8_t			v[3];
			uint8_t			norm;
			file.read((char*)v,3);
			file.read((char*)&norm,1);

			// Transformations
			vertices[j*3]=float(v[0])*scale[0]+translate[0];
			vertices[j*3+1]=float(v[1])*scale[1]+translate[1];
			vertices[j*3+2]=float(v[2])*scale[2]+translate[2];
		}

		// Rarrangement des vertices
		for(int j=0; j<header.nu_faces*3; ++j)
			std::copy(vertices+vert_indices[j]*3,vertices+vert_indices[j]*3+3,conv_vertices+j*3);

		// Ajout de la frame au mesh
		mesh->AddFrame(i,conv_vertices,NULL);
	}

	delete[] vertices;
	delete[] conv_vertices;
	delete[] vert_indices;
	
	// Chargement de la texture
	file.seekg(header.offset_skins);
	for(int i=0; i<header.nu_skins; ++i)
	{
		char skin[68];
		file.read(skin,68);

		try
		{
			const char *name=skin;
			for(const char *c=skin;*c!='\0';++c) if(*c=='/') name=c+1;
			pTexture texture=CMediaManager::Instance()->Get<CTexture>(name);
			mesh->setMaterial(new CMaterial(texture),0);
			break;
		}
		catch(...)
		{
			//if(i==header.nu_skins-1) throw;
		}
	}


	file.close();
	return mesh;
}
*/

CMesh* CMd2Loader::Load(const std::string &filename)
{
	// Ouverture du fichier
	std::ifstream file;
	file.open(filename.c_str(),std::ios::in|std::ios::binary);
	if(!file.is_open()) throw CLoadingFailed(filename, "Ouverture impossible");
	
	// Lecture de l'en-tte
	md2_header_t header;
	file.read((char*)&header,sizeof(md2_header_t));
	
	// Contrle du magic number et de la version
	if(header.ident!=844121161 || header.version!=8 ) 
	{
		file.close();
		throw CLoadingFailed(filename, "Format invalide ou fichier corrompu");
	}

	CMesh::index_t *indices = new CMesh::index_t[header.nu_glcmds*3];	// Trop grand exprs
	float *texcoords = new float[header.nu_glcmds*2];					// Trop grand exprs
	for(int i=0; i<header.nu_vert; ++i) texcoords[i*2]=INVALID_TEXCOORD;

	typedef std::multimap<int,int> ReallocMap_t;
	ReallocMap_t reallocMap;

	// Lecture des commandes OpenGL
	file.seekg(header.offset_glcmds);
	int offset = 0;
	int nbrVerts = header.nu_vert;
	for(;;)
    {
		sint32_t i;
		file.read((char*)&i,4);
		if(file.gcount()!=4) 
			break;	// TODO: gestion erreur
		if(!i) break;
		
		bool fan=(i<0);
		if(fan) i=-i;

		sint32_t index1,index2;
		for(int j=0; j<i; ++j)
        {
			float32_t u,v;
			file.read((char*)&u,4);
			file.read((char*)&v,4);

			sint32_t index3;
			file.read((char*)&index3,4);

			// Rallocation si mme mesh avec coordonnes de texture diffrentes
			if(texcoords[index3*2]!=INVALID_TEXCOORD)
			{
				if(std::fabs(texcoords[index3*2]-u)>EPSILON
					|| std::fabs(1.f-texcoords[index3*2+1]-v)>EPSILON)
				{
					reallocMap.insert(std::make_pair(index3*3,nbrVerts*3));
					index3 = nbrVerts;
					++nbrVerts;
				}
			}

			// Copie des coordonnes de texture
			texcoords[index3*2] = u;
			texcoords[index3*2+1] =	1.f-v;
			
			// Copie des indices
			if(j>=2)
			{
				if(!fan && j%2)
				{
					indices[offset] = index1;
					indices[offset+2] = index3;
				}
				else {
					indices[offset] = index3;
					indices[offset+2] = index1;
				}
				indices[offset+1] = index2;
				offset+=3;
			}

			// Gestion des strips/fans
			if(fan)
			{
				if(!j) std::swap(index1,index3);
				else std::swap(index2,index3);
			}
			else {
				std::swap(index1,index2);
				std::swap(index2,index3);
			}
        }
    }
	
	// Cration du mesh
	CAnimatedMesh *mesh = new CAnimatedMesh(nbrVerts,indices,offset);
	delete[] indices;
	
	mesh->AddFrame(0,NULL,texcoords);
	delete[] texcoords;
	
	float *vertices = new float[nbrVerts*3];
	float *normals = new float[nbrVerts*3];
	
	// Lecture des frames
	file.seekg(header.offset_frames);
	for(int i=0; i<header.nu_frames; ++i)
	{
		float32_t		scale[3];
		float32_t		translate[3];
		char            name[16];

		// Lecture des donnes de la frame
		file.read((char*)scale,12);
		file.read((char*)translate,12);
		file.read((char*)name,16);
		
		ReallocMap_t::iterator it=reallocMap.begin();

		// Lecture des vertices
		for(int j=0; j<header.nu_vert*3; j+=3)
		{
			uint8_t			v[3];
			uint8_t			norm;
			file.read((char*)v,3);
			file.read((char*)&norm,1);

			// Transformations
			vertices[j]=float(v[0])*scale[0]+translate[0];
			vertices[j+1]=float(v[1])*scale[1]+translate[1];
			vertices[j+2]=float(v[2])*scale[2]+translate[2];
			normals[j]=mAnorms[norm][0];
			normals[j+1]=mAnorms[norm][1];
			normals[j+2]=mAnorms[norm][2];
			
			// Copie ventuelle pour les vertices rallous
			while(it != reallocMap.end())
			{
				if(it->first<=j)
				{
					if(it->first==j)
					{
						vertices[it->second]	= vertices[j];
						vertices[it->second+1]= vertices[j+1];
						vertices[it->second+2]= vertices[j+2];
						normals[it->second]=mAnorms[norm][0];
						normals[it->second+1]=mAnorms[norm][1];
						normals[it->second+2]=mAnorms[norm][2];
					}
					++it;
				}
				else break;
			}
		}

		// Ajout de la frame au mesh
		mesh->AddFrame(i,vertices,NULL,normals);
	}

	delete[] vertices;
	delete[] normals;
	
	// Chargement de la texture
	file.seekg(header.offset_skins);
	for(int i=0; i<header.nu_skins; ++i)
	{
		char skin[68];
		file.read(skin,68);

		try
		{
			const char *name=skin;
			for(const char *c=skin;*c!='\0';++c) if(*c=='/') name=c+1;
			pTexture texture=CMediaManager::Instance()->Get<CTexture>(name);
			mesh->setMaterial(new CMaterial(texture),0);
			break;
		}
		catch(...)
		{
			//if(i==header.nu_skins-1) throw;
		}
	}


	file.close();
	return mesh;
}
